/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.app.decompiler.PrettyPrinter;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ExportToCAction
extends AbstractDecompilerAction {
    private static final ImageIcon EXPORT_ICON = ResourceManager.loadImage((String)"images/page_edit.png");
    private static final String LAST_USED_C_FILE = "last.used.decompiler.c.export.file";

    public ExportToCAction() {
        super("Export to C");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ToolBarExport"));
        this.setToolBarData(new ToolBarData((Icon)EXPORT_ICON, "Local"));
        this.setDescription("Export the current function to C");
    }

    private File readLastUsedFile() {
        String filename = Preferences.getProperty((String)LAST_USED_C_FILE);
        if (filename == null) {
            return null;
        }
        return new File(filename);
    }

    private void saveLastUsedFileFile(File file) {
        Preferences.setProperty((String)LAST_USED_C_FILE, (String)file.getAbsolutePath());
        Preferences.store();
    }

    private File getFile(DecompilerPanel decompilerPanel) {
        File file;
        File lastUsedFile = this.readLastUsedFile();
        String[] extensions = new String[]{"h", "c", "cpp"};
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)decompilerPanel);
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(extensions, "C/C++ Files"));
        if (lastUsedFile != null) {
            fileChooser.setSelectedFile(lastUsedFile);
        }
        if ((file = fileChooser.getSelectedFile()) == null) {
            return null;
        }
        this.saveLastUsedFileFile(file);
        boolean hasExtension = false;
        String path = file.getAbsolutePath();
        for (String element : extensions) {
            if (!path.toLowerCase().endsWith("." + element)) continue;
            hasExtension = true;
        }
        if (!hasExtension) {
            file = new File(path + ".c");
        }
        return file;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return context.getFunction() != null && context.getCCodeModel() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        File file = this.getFile(context.getDecompilerPanel());
        if (file == null) {
            return;
        }
        if (file.exists() && OptionDialog.showYesNoDialog((Component)context.getDecompilerPanel(), (String)"Overwrite Existing File?", (String)"Do you want to overwrite the existing file?") == 2) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(file));
            ClangTokenGroup grp = context.getCCodeModel();
            PrettyPrinter printer = new PrettyPrinter(context.getFunction(), grp);
            DecompiledFunction decompFunc = printer.print(true);
            writer.write(decompFunc.getC());
            writer.close();
            context.setStatusMessage("Successfully exported function(s) to " + file.getAbsolutePath());
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)context.getDecompilerPanel(), (String)"Export to C Failed", (Object)("Error exporting to C: " + e));
        }
    }
}

