/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;
import utility.function.Callback;

public class ConvertConstantTask
implements Callback {
    private DecompilerActionContext context;
    private Program program;
    private Address convertAddress;
    private String convertName;
    private Varnode convertVn;
    private long convertHash;
    private int convertIndex;
    private boolean convertSigned;
    private Address altAddress = null;
    private int altIndex;
    private String altName = null;
    private long altValue;

    public ConvertConstantTask(Varnode vn, boolean isSigned) {
        this.convertVn = vn;
        this.convertSigned = isSigned;
    }

    public ConvertConstantTask(DecompilerActionContext context, String name, Address addr, Varnode vn, long hash, int index) {
        this.context = context;
        this.program = context.getProgram();
        this.convertName = name;
        this.convertAddress = addr;
        this.convertVn = vn;
        this.convertHash = hash;
        this.convertIndex = index;
    }

    public void setAlternate(String name, Address addr, int index, long value) {
        this.altName = name;
        this.altAddress = addr;
        this.altValue = value;
        this.altIndex = index;
    }

    public long getValue() {
        return this.convertVn.getOffset();
    }

    public int getSize() {
        return this.convertVn.getSize();
    }

    public boolean isSigned() {
        return this.convertSigned;
    }

    private void removePrimaryReference() {
        EquateTable equateTable = this.program.getEquateTable();
        List equates = equateTable.getEquates(this.convertAddress);
        for (Equate equate : equates) {
            List references = equate.getReferences(this.convertAddress);
            for (EquateReference ref : references) {
                if (ref.getDynamicHashValue() != this.convertHash) continue;
                if (equate.getReferenceCount() <= 1) {
                    equateTable.removeEquate(equate.getName());
                } else {
                    equate.removeReference(this.convertHash, this.convertAddress);
                }
                return;
            }
        }
    }

    private void removeAlternateReference() {
        EquateTable equateTable = this.program.getEquateTable();
        List equates = equateTable.getEquates(this.altAddress);
        for (Equate equate : equates) {
            List references = equate.getReferences(this.altAddress);
            for (EquateReference ref : references) {
                if (ref.getOpIndex() != this.altIndex) continue;
                if (equate.getReferenceCount() <= 1) {
                    equateTable.removeEquate(equate.getName());
                } else {
                    equate.removeReference(this.altAddress, this.altIndex);
                }
                return;
            }
        }
    }

    private void addPrimaryEquate() throws DuplicateNameException, InvalidInputException {
        EquateTable equateTable = this.program.getEquateTable();
        Equate equate = equateTable.getEquate(this.convertName);
        if (equate != null && equate.getValue() != this.convertVn.getOffset()) {
            String msg = "Equate named " + this.convertName + " already exists with value of " + equate.getValue() + ".";
            throw new DuplicateNameException(msg);
        }
        if (equate == null) {
            equate = equateTable.createEquate(this.convertName, this.convertVn.getOffset());
        }
        if (this.convertHash != 0L) {
            equate.addReference(this.convertHash, this.convertAddress);
        } else {
            equate.addReference(this.convertAddress, this.convertIndex);
        }
    }

    private void addAlternateEquate() throws InvalidInputException, DuplicateNameException {
        EquateTable equateTable = this.program.getEquateTable();
        Equate equate = equateTable.getEquate(this.altName);
        if (equate != null && equate.getValue() != this.altValue) {
            String msg = "Equate named " + this.altName + " already exists with value of " + equate.getValue() + ".";
            throw new DuplicateNameException(msg);
        }
        if (equate == null) {
            equate = equateTable.createEquate(this.altName, this.altValue);
        }
        equate.addReference(this.altAddress, this.altIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPrimaryEquate() {
        int transaction = this.program.startTransaction("Convert constant");
        boolean commit = false;
        try {
            if (this.altAddress != null) {
                this.removeAlternateReference();
            }
            this.removePrimaryReference();
            this.addPrimaryEquate();
            commit = true;
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Convert Failed", (Object)e.getMessage());
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, null, (String)"Convert Failed", (Object)e.getMessage());
        }
        finally {
            this.program.endTransaction(transaction, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAlternateEquate() {
        int transaction = this.program.startTransaction("Convert constant");
        boolean commit = false;
        try {
            this.addAlternateEquate();
            commit = true;
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Convert Failed", (Object)e.getMessage());
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, null, (String)"Convert Failed", (Object)e.getMessage());
        }
        finally {
            this.program.endTransaction(transaction, commit);
        }
    }

    private boolean isAlternatePlaced() {
        HighFunction highFunction = this.context.getHighFunction();
        if (highFunction == null) {
            return false;
        }
        Varnode vn = DynamicHash.findVarnode((PcodeSyntaxTree)highFunction, (Address)this.convertAddress, (long)this.convertHash);
        if (vn == null) {
            return false;
        }
        HighSymbol symbol = vn.getHigh().getSymbol();
        if (!(symbol instanceof EquateSymbol)) {
            return false;
        }
        EquateSymbol eqSymbol = (EquateSymbol)symbol;
        return eqSymbol.getPCAddress().equals((Object)this.altAddress);
    }

    public void call() {
        if (this.isAlternatePlaced()) {
            return;
        }
        this.applyPrimaryEquate();
    }

    public void runTask() {
        if (this.altAddress != null) {
            this.applyAlternateEquate();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                return;
            }
            this.context.getComponentProvider().doWhenNotBusy(this);
        } else {
            this.applyPrimaryEquate();
        }
    }
}

