/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Program;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.HelpLocation;

public class ConvertCharAction
extends ConvertConstantAction {
    public ConvertCharAction(DecompilePlugin plugin) {
        super(plugin, "Convert To Char", 5);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionConvert"));
        this.setPopupMenuData(new MenuData(new String[]{"Char"}, "Decompile"));
    }

    @Override
    public String getMenuPrefix() {
        return "Char: ";
    }

    private static void generateHexEscape(StringBuilder buffer, int value) {
        String res = Integer.toHexString(value);
        int pad = res.length();
        pad = pad > 4 ? 8 : (pad > 2 ? 4 : 2);
        pad -= res.length();
        buffer.append("'\\x");
        for (int i = 0; i < pad; ++i) {
            buffer.append('0');
        }
        buffer.append(res.toLowerCase());
        buffer.append('\'');
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        byte[] bytes = new byte[size];
        BigEndianDataConverter.INSTANCE.putValue(value, size, bytes, 0);
        return StringDataInstance.getCharRepresentation((DataType)ByteDataType.dataType, (byte[])bytes, null);
    }

    private static boolean codePointNeedsEscape(int codepoint) {
        int characterClass = Character.getType(codepoint);
        switch (characterClass) {
            case 12: {
                return codepoint != 32;
            }
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned) {
        StringBuilder buffer = new StringBuilder();
        if (size > 1) {
            buffer.append('L');
        }
        if (size == 1 && value >= 127L || ConvertCharAction.codePointNeedsEscape((int)value)) {
            switch ((int)value) {
                case 0: {
                    buffer.append("'\\0'");
                    break;
                }
                case 7: {
                    buffer.append("'\\a'");
                    break;
                }
                case 8: {
                    buffer.append("'\\b'");
                    break;
                }
                case 9: {
                    buffer.append("'\\t'");
                    break;
                }
                case 10: {
                    buffer.append("'\\n'");
                    break;
                }
                case 11: {
                    buffer.append("'\\v'");
                    break;
                }
                case 12: {
                    buffer.append("'\\f'");
                    break;
                }
                case 13: {
                    buffer.append("'\\r'");
                    break;
                }
                case 34: {
                    buffer.append("\\\"");
                    break;
                }
                case 92: {
                    buffer.append("\\\\");
                    break;
                }
                case 39: {
                    buffer.append("\\'");
                    break;
                }
                default: {
                    ConvertCharAction.generateHexEscape(buffer, (int)value);
                    break;
                }
            }
        } else {
            buffer.append('\'').append((char)value).append('\'');
        }
        return buffer.toString();
    }
}

