/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.HighlightToken;
import java.util.Objects;

class TokenKey {
    private ClangToken token;

    TokenKey(ClangToken token) {
        this.token = Objects.requireNonNull(token);
    }

    public TokenKey(HighlightToken t) {
        this(t.getToken());
    }

    public int hashCode() {
        String text = this.token.getText();
        return text == null ? 0 : text.hashCode();
    }

    public boolean equals(Object obj) {
        int otherPositionInLine;
        ClangLine otherLineParent;
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClangToken otherToken = ((TokenKey)obj).token;
        if (this.token.getClass() != otherToken.getClass()) {
            return false;
        }
        if (!Objects.equals(this.token.getText(), otherToken.getText())) {
            return false;
        }
        ClangLine lineParent = this.token.getLineParent();
        if (!this.sameLines(lineParent, otherLineParent = otherToken.getLineParent())) {
            return false;
        }
        if (lineParent == null) {
            return false;
        }
        int positionInLine = lineParent.indexOfToken(this.token);
        return positionInLine == (otherPositionInLine = otherLineParent.indexOfToken(otherToken));
    }

    private boolean sameLines(ClangLine l1, ClangLine l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        return l1.getLineNumber() == l2.getLineNumber();
    }

    public String toString() {
        return this.token.toString();
    }
}

