/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.label.GDHtmlLabel;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.component.ApplyFunctionSignatureAction;
import ghidra.app.decompiler.component.CDisplayPanel;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DualDecompileResultsListener;
import ghidra.app.decompiler.component.DualDecompilerActionContext;
import ghidra.app.decompiler.component.DualDecompilerFieldPanelCoordinator;
import ghidra.app.decompiler.component.LocationClangHighlightController;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.app.util.viewer.util.TitledPanel;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionUtility;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public abstract class DecompilerCodeComparisonPanel<T extends DualDecompilerFieldPanelCoordinator>
extends CodeComparisonPanel<DualDecompilerFieldPanelCoordinator> {
    private static final String NO_FUNCTION_TITLE = "No Function";
    static final String OPTIONS_TITLE = "Decompiler";
    private JSplitPane splitPane;
    private CDisplayPanel[] cPanels = new CDisplayPanel[2];
    private DualDecompilerFieldPanelCoordinator dualDecompilerCoordinator;
    private DecompileData leftDecompileData;
    private DecompileData rightDecompileData;
    private boolean isMatchingConstantsExactly = true;
    private DecompileOptions leftDecompileOptions;
    private DecompileOptions rightDecompileOptions;
    private ApplyFunctionSignatureAction applyFunctionSignatureAction;
    private ClangHighlightController[] highlightControllers = new ClangHighlightController[2];
    private ArrayList<DualDecompileResultsListener> dualDecompileResultsListenerList = new ArrayList();
    private String leftTitle = "No Function";
    private String rightTitle = "No Function";
    private ProgramLocationListener leftDecompilerLocationListener;
    private ProgramLocationListener rightDecompilerLocationListener;

    public DecompilerCodeComparisonPanel(String owner, PluginTool tool) {
        super(owner, tool);
        this.functions = new Function[2];
        this.buildPanel();
        this.loadFunctions(null, null);
        this.highlightControllers[0] = new LocationClangHighlightController();
        this.highlightControllers[1] = new LocationClangHighlightController();
        this.setHighlightControllers(this.highlightControllers[0], this.highlightControllers[1]);
        this.initialize();
    }

    private void initialize() {
        ToolOptions options = this.tool.getOptions(OPTIONS_TITLE);
        this.leftDecompileOptions.grabFromToolAndProgram(null, options, this.functions[0] != null ? this.functions[0].getProgram() : null);
        this.rightDecompileOptions.grabFromToolAndProgram(null, options, this.functions[1] != null ? this.functions[1].getProgram() : null);
        this.setFieldPanelCoordinator(this.createFieldPanelCoordinator());
        this.setScrollingSyncState(true);
        this.createActions();
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return "Decompile View";
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    private void setTitles(String leftTitle, String rightTitle) {
        this.setLeftTitle(leftTitle);
        this.setRightTitle(rightTitle);
    }

    private void setTitle(TitledPanel titlePanel, String titlePrefix, String title) {
        String htmlPrefix;
        if (!((String)titlePrefix).isEmpty()) {
            titlePrefix = (String)titlePrefix + " ";
        }
        if (title.startsWith(htmlPrefix = "<HTML>")) {
            titlePanel.setTitleName(htmlPrefix + HTMLUtilities.friendlyEncodeHTML((String)titlePrefix) + title.substring(htmlPrefix.length()));
        } else {
            titlePanel.setTitleName((String)titlePrefix + title);
        }
    }

    public void setLeftTitle(String leftTitle) {
        this.leftTitle = leftTitle;
        this.setTitle(this.titlePanels[0], this.leftTitlePrefix, leftTitle);
    }

    public void setRightTitle(String rightTitle) {
        this.rightTitle = rightTitle;
        this.setTitle(this.titlePanels[1], this.rightTitlePrefix, rightTitle);
    }

    private void setTitles(Function leftFunction, Function rightFunction) {
        this.setTitles(this.getTitleForFunction(leftFunction), this.getTitleForFunction(rightFunction));
    }

    private String getTitleForFunction(Function function) {
        Object title = NO_FUNCTION_TITLE;
        if (function != null) {
            String programName = function.getProgram().getDomainFile().getPathname();
            title = function.getName(true) + "  [" + programName + "]";
        }
        return title;
    }

    public boolean isMatchingConstantsExactly() {
        return this.isMatchingConstantsExactly;
    }

    public void loadFunctions(Function leftFunction, Function rightFunction) {
        if (leftFunction == this.functions[0] && rightFunction == this.functions[1]) {
            return;
        }
        if (leftFunction != this.functions[0]) {
            this.leftDecompileData = null;
        }
        if (rightFunction != this.functions[1]) {
            this.rightDecompileData = null;
        }
        this.notifyDecompileResultsListeners();
        Program leftProgram = leftFunction != null ? leftFunction.getProgram() : null;
        Program rightProgram = rightFunction != null ? rightFunction.getProgram() : null;
        this.setPrograms(leftProgram, rightProgram);
        this.loadLeftFunction(leftFunction);
        this.loadRightFunction(rightFunction);
        if (this.getShowTitles()) {
            this.setTitles(leftFunction, rightFunction);
        } else {
            this.setTitles("", "");
        }
        if (this.dualDecompilerCoordinator != null) {
            this.dualDecompilerCoordinator.leftLocationChanged(null);
        }
    }

    private void notifyDecompileResultsListeners() {
        for (DualDecompileResultsListener listener : this.dualDecompileResultsListenerList) {
            listener.decompileResultsSet(this.leftDecompileData, this.rightDecompileData);
        }
    }

    private void loadLeftFunction(Function function) {
        if (function == this.functions[0]) {
            return;
        }
        this.functions[0] = function;
        this.cPanels[0].showFunction(function);
    }

    private void loadRightFunction(Function function) {
        if (function == this.functions[1]) {
            return;
        }
        this.functions[1] = function;
        this.cPanels[1].showFunction(function);
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        this.leftDecompileOptions = new DecompileOptions();
        this.rightDecompileOptions = new DecompileOptions();
        this.cPanels[0] = new CDisplayPanel(this.leftDecompileOptions, decompileData -> this.leftDecompileDataSet(decompileData));
        this.cPanels[1] = new CDisplayPanel(this.rightDecompileOptions, decompileData -> this.rightDecompileDataSet(decompileData));
        this.leftDecompilerLocationListener = (leftLocation, trigger) -> {
            if (this.dualDecompilerCoordinator != null) {
                this.dualDecompilerCoordinator.leftLocationChanged(leftLocation);
            }
        };
        this.rightDecompilerLocationListener = (rightLocation, trigger) -> {
            if (this.dualDecompilerCoordinator != null) {
                this.dualDecompilerCoordinator.rightLocationChanged(rightLocation);
            }
        };
        this.cPanels[0].setProgramLocationListener(this.leftDecompilerLocationListener);
        this.cPanels[1].setProgramLocationListener(this.rightDecompilerLocationListener);
        for (int i = 0; i < this.cPanels.length; ++i) {
            FieldPanel fieldPanel = this.cPanels[i].getDecompilerPanel().getFieldPanel();
            fieldPanel.addFocusListener((FocusListener)((Object)this));
            fieldPanel.addMouseListener((MouseListener)new DualDecompilerMouseListener(i));
        }
        this.setDualPanelFocus(this.currProgramIndex);
        String leftTitle1 = FunctionUtility.getFunctionTitle((Function)this.functions[0]);
        String rightTitle1 = FunctionUtility.getFunctionTitle((Function)this.functions[1]);
        GDHtmlLabel leftTitleLabel = new GDHtmlLabel(leftTitle1);
        GDHtmlLabel rightTitleLabel = new GDHtmlLabel(rightTitle1);
        this.titlePanels[0] = new TitledPanel((JLabel)leftTitleLabel, (JComponent)this.cPanels[0], 5);
        this.titlePanels[1] = new TitledPanel((JLabel)rightTitleLabel, (JComponent)this.cPanels[1], 5);
        this.titlePanels[0].setMinimumSize(new Dimension(50, this.titlePanels[0].getMinimumSize().height));
        this.titlePanels[1].setMinimumSize(new Dimension(50, this.titlePanels[1].getMinimumSize().height));
        this.splitPane = new JSplitPane(1, true, (Component)this.titlePanels[0], (Component)this.titlePanels[1]);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerSize(4);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.splitPane, "Center");
    }

    public boolean addDualDecompileResultsListener(DualDecompileResultsListener listener) {
        return this.dualDecompileResultsListenerList.add(listener);
    }

    public boolean removeDualDecompileResultsListener(DualDecompileResultsListener listener) {
        return this.dualDecompileResultsListenerList.remove(listener);
    }

    public void setHighlightControllers(ClangHighlightController leftHighlightController, ClangHighlightController rightHighlightController) {
        this.highlightControllers[0] = leftHighlightController;
        this.highlightControllers[1] = rightHighlightController;
        this.cPanels[0].getDecompilerPanel().setHighlightController(leftHighlightController);
        this.cPanels[1].getDecompilerPanel().setHighlightController(rightHighlightController);
    }

    public void setFieldPanelCoordinator(DualDecompilerFieldPanelCoordinator fieldPanelCoordinator) {
        if (this.dualDecompilerCoordinator == fieldPanelCoordinator) {
            return;
        }
        if (this.dualDecompilerCoordinator != null) {
            this.dualDecompilerCoordinator.dispose();
            this.cPanels[0].setProgramLocationListener(null);
            this.cPanels[1].setProgramLocationListener(null);
        }
        this.dualDecompilerCoordinator = fieldPanelCoordinator;
        if (fieldPanelCoordinator != null) {
            this.cPanels[0].setProgramLocationListener(this.leftDecompilerLocationListener);
            this.cPanels[1].setProgramLocationListener(this.rightDecompilerLocationListener);
            CDisplayPanel focusedDecompilerPanel = this.getFocusedDecompilerPanel();
            ProgramLocation programLocation = focusedDecompilerPanel.getDecompilerPanel().getCurrentLocation();
            if (programLocation != null) {
                focusedDecompilerPanel.locationChanged(programLocation);
            }
        }
    }

    protected void rightDecompileDataSet(DecompileData decompileData) {
        this.rightDecompileData = decompileData;
        this.notifyDecompileResultsListeners();
    }

    protected void leftDecompileDataSet(DecompileData decompileData) {
        this.leftDecompileData = decompileData;
        this.notifyDecompileResultsListeners();
    }

    public void setTopComponent(JComponent comp) {
        if (this.topComp == comp) {
            return;
        }
        if (this.topComp != null) {
            this.remove(this.topComp);
        }
        this.topComp = comp;
        if (this.topComp != null) {
            this.add(this.topComp, "North");
        }
        this.validate();
    }

    public void setBottomComponent(JComponent comp) {
        if (this.bottomComp == comp) {
            return;
        }
        if (this.bottomComp != null) {
            this.remove(this.bottomComp);
        }
        this.validate();
        this.bottomComp = comp;
        if (this.bottomComp != null) {
            this.add(this.bottomComp, "South");
        }
        this.validate();
    }

    public CDisplayPanel getFocusedDecompilerPanel() {
        return this.cPanels[this.currProgramIndex];
    }

    public CDisplayPanel getLeftPanel() {
        return this.cPanels[0];
    }

    public CDisplayPanel getRightPanel() {
        return this.cPanels[1];
    }

    public void dispose() {
        this.setFieldPanelCoordinator((DualDecompilerFieldPanelCoordinator)null);
        this.cPanels[0].dispose();
        this.cPanels[1].dispose();
    }

    public void focusGained(FocusEvent e) {
        Component comp = e.getComponent();
        for (int i = 0; i < this.cPanels.length; ++i) {
            if (this.cPanels[i].getDecompilerPanel().getFieldPanel() != comp) continue;
            this.setDualPanelFocus(i);
        }
        this.tool.getActiveComponentProvider().contextChanged();
    }

    private void setDualPanelFocus(int leftOrRight) {
        this.currProgramIndex = leftOrRight;
        this.cPanels[leftOrRight].setBorder(FOCUS_BORDER);
        this.cPanels[leftOrRight == 0 ? 1 : 0].setBorder(NON_FOCUS_BORDER);
    }

    private void clearBothDisplaysAndShowMessage(String message) {
        this.cPanels[0].clearAndShowMessage(message);
        this.cPanels[1].clearAndShowMessage(message);
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        this.cPanels[0].setMouseNavigationEnabled(enabled);
        this.cPanels[1].setMouseNavigationEnabled(enabled);
    }

    protected void setPrograms(Program leftProgram, Program rightProgram) {
        ToolOptions options;
        ToolOptions toolOptions = options = this.tool != null ? this.tool.getOptions(OPTIONS_TITLE) : null;
        if (leftProgram != this.programs[0]) {
            this.programs[0] = leftProgram;
            if (options != null) {
                this.leftDecompileOptions.grabFromToolAndProgram(null, options, leftProgram);
            }
        }
        if (rightProgram != this.programs[1]) {
            this.programs[1] = rightProgram;
            if (options != null) {
                this.rightDecompileOptions.grabFromToolAndProgram(null, options, rightProgram);
            }
        }
    }

    public void loadData(Data leftData, Data rightData) {
        this.loadFunctions(null, null);
    }

    public void loadAddresses(Program leftProgram, Program rightProgram, AddressSetView leftAddresses, AddressSetView rightAddresses) {
        this.loadFunctions(null, null);
    }

    public DecompilerPanel getLeftDecompilerPanel() {
        return this.cPanels[0].getDecompilerPanel();
    }

    public DecompilerPanel getRightDecompilerPanel() {
        return this.cPanels[1].getDecompilerPanel();
    }

    public void updateActionEnablement() {
    }

    protected void createActions() {
        this.applyFunctionSignatureAction = new ApplyFunctionSignatureAction(this.owner);
    }

    public DockingAction[] getActions() {
        DockingAction[] codeCompActions = super.getActions();
        DockingAction[] otherActions = new DockingAction[]{this.applyFunctionSignatureAction};
        int compCount = codeCompActions.length;
        int otherCount = otherActions.length;
        DockingAction[] actions = new DockingAction[compCount + otherCount];
        System.arraycopy(codeCompActions, 0, actions, 0, compCount);
        System.arraycopy(otherActions, 0, actions, compCount, otherCount);
        return actions;
    }

    public abstract Class<? extends DecompilerCodeComparisonPanel<? extends FieldPanelCoordinator>> getPanelThisSupersedes();

    public ActionContext getActionContext(ComponentProvider provider, MouseEvent event) {
        Component component = event == null ? null : event.getComponent();
        CDisplayPanel focusedDecompilerPanel = this.getFocusedDecompilerPanel();
        DualDecompilerActionContext dualDecompContext = new DualDecompilerActionContext(provider, focusedDecompilerPanel, component);
        dualDecompContext.setCodeComparisonPanel(this);
        return dualDecompContext;
    }

    public void programRestored(Program program) {
        Program rightProgram;
        Function leftFunction = this.getLeftFunction();
        Function rightFunction = this.getRightFunction();
        Program leftProgram = leftFunction != null ? leftFunction.getProgram() : null;
        Program program2 = rightProgram = rightFunction != null ? rightFunction.getProgram() : null;
        if (leftProgram == program) {
            this.titlePanels[0].setTitleName(FunctionUtility.getFunctionTitle((Function)leftFunction));
            this.refreshLeftPanel();
        }
        if (rightProgram == program) {
            this.titlePanels[1].setTitleName(FunctionUtility.getFunctionTitle((Function)rightFunction));
            this.refreshRightPanel();
        }
    }

    private void refreshPanel(int leftOrRight) {
        Function leftFunction = this.functions[0];
        Function rightFunction = this.functions[1];
        FieldLocation leftCursorLocation = this.getLeftDecompilerPanel().getFieldPanel().getCursorLocation();
        FieldLocation rightCursorLocation = this.getRightDecompilerPanel().getFieldPanel().getCursorLocation();
        MyDecompileResultsListener listener = new MyDecompileResultsListener(leftCursorLocation, rightCursorLocation);
        this.dualDecompileResultsListenerList.clear();
        this.loadFunctions(leftOrRight == 0 ? null : leftFunction, leftOrRight == 1 ? null : rightFunction);
        this.addDualDecompileResultsListener(listener);
        this.loadFunctions(leftFunction, rightFunction);
    }

    public void refreshLeftPanel() {
        this.refreshPanel(0);
    }

    public void refreshRightPanel() {
        this.refreshPanel(1);
    }

    public boolean leftPanelHasFocus() {
        return this.currProgramIndex == 0;
    }

    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        this.leftTitlePrefix = leftTitlePrefix;
        this.rightTitlePrefix = rightTitlePrefix;
        this.setTitles(this.leftTitle, this.rightTitle);
    }

    public AddressSetView getLeftAddresses() {
        return this.functions[0] != null ? this.functions[0].getBody() : EMPTY_ADDRESS_SET;
    }

    public AddressSetView getRightAddresses() {
        return this.functions[1] != null ? this.functions[1].getBody() : EMPTY_ADDRESS_SET;
    }

    public FieldPanel getLeftFieldPanel() {
        return this.getLeftDecompilerPanel().getFieldPanel();
    }

    public FieldPanel getRightFieldPanel() {
        return this.getRightDecompilerPanel().getFieldPanel();
    }

    protected abstract DualDecompilerFieldPanelCoordinator createFieldPanelCoordinator();

    private class DualDecompilerMouseListener
    extends MouseAdapter {
        private int leftOrRight;

        DualDecompilerMouseListener(int leftOrRight) {
            this.leftOrRight = leftOrRight;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DecompilerCodeComparisonPanel.this.setDualPanelFocus(this.leftOrRight);
        }
    }

    private class MyDecompileResultsListener
    implements DualDecompileResultsListener {
        private FieldLocation leftCursorLocation;
        private FieldLocation rightCursorLocation;

        private MyDecompileResultsListener(FieldLocation leftCursorLocation, FieldLocation rightCursorLocation) {
            this.leftCursorLocation = leftCursorLocation;
            this.rightCursorLocation = rightCursorLocation;
        }

        @Override
        public void decompileResultsSet(DecompileData myLeftDecompileData, DecompileData myRightDecompileData) {
            SwingUtilities.invokeLater(() -> {
                if (myLeftDecompileData != null) {
                    this.restoreCursor(DecompilerCodeComparisonPanel.this.getLeftDecompilerPanel(), this.leftCursorLocation);
                }
                if (myRightDecompileData != null) {
                    this.restoreCursor(DecompilerCodeComparisonPanel.this.getRightDecompilerPanel(), this.rightCursorLocation);
                }
                DecompilerCodeComparisonPanel.this.removeDualDecompileResultsListener(this);
            });
        }

        private void restoreCursor(DecompilerPanel decompilerPanel, FieldLocation cursorLocation) {
            FieldPanel fieldPanel = decompilerPanel.getFieldPanel();
            FieldLocation currentLocation = fieldPanel.getCursorLocation();
            if (cursorLocation != null && !cursorLocation.equals((Object)currentLocation)) {
                fieldPanel.setCursorPosition(cursorLocation.getIndex(), cursorLocation.getFieldNum(), cursorLocation.getRow(), cursorLocation.getCol());
            }
        }
    }
}

