/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.IllegalFieldAccessException;
import db.PrimitiveField;
import db.buffers.DataBuffer;
import java.io.IOException;

public final class LongField
extends PrimitiveField {
    public static final LongField MIN_VALUE = new LongField(Long.MIN_VALUE, true);
    public static final LongField MAX_VALUE = new LongField(Long.MAX_VALUE, true);
    public static final LongField ZERO_VALUE;
    public static final LongField INSTANCE;
    private long value;

    public LongField() {
    }

    public LongField(long l) {
        this(l, false);
    }

    LongField(long l, boolean immutable) {
        super(immutable);
        this.value = l;
    }

    @Override
    void setNull() {
        super.setNull();
        this.value = 0L;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.updatingPrimitiveValue();
        this.value = value;
    }

    @Override
    int length() {
        return 8;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putLong(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.updatingPrimitiveValue();
        this.value = buf.getLong(offset);
        return offset + 8;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 8;
    }

    @Override
    byte getFieldType() {
        return 3;
    }

    @Override
    public String getValueAsString() {
        return "0x" + Long.toHexString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LongField)) {
            return false;
        }
        return ((LongField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        if (!(o instanceof LongField)) {
            throw new UnsupportedOperationException("may only compare similar Field types");
        }
        LongField f = (LongField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        long otherValue = buffer.getLong(offset);
        if (this.value == otherValue) {
            return 0;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 1;
    }

    @Override
    public LongField copyField() {
        if (this.isNull()) {
            LongField copy = new LongField();
            copy.setNull();
            return copy;
        }
        return new LongField(this.getLongValue());
    }

    @Override
    public LongField newField() {
        return new LongField();
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{(byte)(this.value >> 56), (byte)(this.value >> 48), (byte)(this.value >> 40), (byte)(this.value >> 32), (byte)(this.value >> 24), (byte)(this.value >> 16), (byte)(this.value >> 8), (byte)this.value};
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (bytes == null) {
            this.setNull();
            return;
        }
        if (bytes.length != 8) {
            throw new IllegalFieldAccessException();
        }
        this.updatingPrimitiveValue();
        this.value = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    LongField getMinValue() {
        return MIN_VALUE;
    }

    @Override
    LongField getMaxValue() {
        return MAX_VALUE;
    }

    static {
        INSTANCE = ZERO_VALUE = new LongField(0L, true);
    }
}

