/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryDataBuffer;
import db.Buffer;
import db.Field;
import db.IllegalFieldAccessException;
import db.LegacyIndexField;
import db.buffers.DataBuffer;
import ghidra.util.exception.AssertException;
import java.io.IOException;

class IndexField
extends Field {
    static final int MAX_INDEX_FIELD_LENGTH = 64;
    private Field primaryKey;
    private Field nonTruncatedIndexedField;
    private Field indexedField;
    private boolean isTruncated = false;

    IndexField(Field indexedField, Field primaryKey) {
        if (primaryKey.isVariableLength()) {
            throw new IllegalArgumentException("variable length primaryKey not supported");
        }
        this.primaryKey = primaryKey.copyField();
        this.nonTruncatedIndexedField = indexedField;
        this.indexedField = indexedField;
        if (indexedField.isVariableLength() && indexedField.length() >= 64) {
            this.indexedField = indexedField.copyField();
            this.indexedField.truncate(64);
            this.isTruncated = true;
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    void setNull() {
        throw new IllegalFieldAccessException("Index field may not be set null");
    }

    Field getIndexedField() {
        return this.indexedField;
    }

    @Deprecated
    Field getNonTruncatedIndexField() {
        return this.nonTruncatedIndexedField;
    }

    @Deprecated
    boolean usesTruncatedFieldValue() {
        return this.isTruncated;
    }

    Field getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    int length() {
        return this.indexedField.length() + this.primaryKey.length();
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        offset = this.indexedField.write(buf, offset);
        return this.primaryKey.write(buf, offset);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        offset = this.indexedField.read(buf, offset);
        return this.primaryKey.read(buf, offset);
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return this.indexedField.readLength(buf, offset) + this.primaryKey.length();
    }

    @Override
    public boolean isVariableLength() {
        return this.indexedField.isVariableLength();
    }

    @Override
    public IndexField copyField() {
        return new IndexField(this.indexedField.copyField(), this.primaryKey.copyField());
    }

    @Override
    public IndexField newField() {
        return new IndexField(this.indexedField.newField(), this.primaryKey.newField());
    }

    IndexField newIndexField(Field indexValue, Field key) {
        if (!indexValue.isSameType(this.indexedField) || !this.primaryKey.isSameType(this.getPrimaryKey())) {
            throw new IllegalArgumentException("incorrect index value or key type");
        }
        return new IndexField(indexValue, key);
    }

    @Override
    final IndexField getMinValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    final IndexField getMaxValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    byte getFieldType() {
        return IndexField.getIndexFieldType(this.indexedField, this.primaryKey);
    }

    public String toString() {
        return this.indexedField + "/" + this.primaryKey;
    }

    @Override
    public String getValueAsString() {
        return this.indexedField.getValueAsString() + " / " + this.primaryKey.getValueAsString();
    }

    boolean hasSameIndexValue(IndexField field) {
        if (field == null) {
            return false;
        }
        if (this.indexedField == null) {
            return field.indexedField == null;
        }
        return this.indexedField.equals(field.indexedField);
    }

    @Override
    public byte[] getBinaryData() {
        byte[] indexBytes = this.indexedField.getBinaryData();
        byte[] primaryKeyBytes = this.primaryKey.getBinaryData();
        int len = indexBytes.length + primaryKeyBytes.length;
        byte[] bytes = new byte[len];
        System.arraycopy(indexBytes, 0, bytes, 0, indexBytes.length);
        System.arraycopy(primaryKeyBytes, 0, bytes, indexBytes.length, primaryKeyBytes.length);
        return bytes;
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (this.isVariableLength()) {
            throw new IllegalFieldAccessException("Unsupported for variable length IndexField");
        }
        if (bytes.length != this.length()) {
            throw new IllegalFieldAccessException();
        }
        BinaryDataBuffer buffer = new BinaryDataBuffer(bytes);
        try {
            this.read(buffer, 0);
        }
        catch (IOException e) {
            throw new IllegalFieldAccessException();
        }
    }

    @Override
    public int compareTo(Field o) {
        IndexField f = (IndexField)o;
        int result = this.indexedField.compareTo(f.indexedField);
        if (result != 0) {
            return result;
        }
        return this.primaryKey.compareTo(f.primaryKey);
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        int result = this.indexedField.compareTo(buffer, offset);
        if (result != 0) {
            return result;
        }
        try {
            int indexedFieldLen = this.indexedField.readLength(buffer, offset);
            return this.primaryKey.compareTo(buffer, offset + indexedFieldLen);
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }

    @Override
    public boolean isSameType(Field field) {
        if (!(field instanceof IndexField)) {
            return false;
        }
        IndexField otherField = (IndexField)field;
        return this.indexedField.isSameType(otherField.indexedField) && this.primaryKey.isSameType(otherField.primaryKey);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IndexField f = (IndexField)obj;
        return this.primaryKey.equals(f.primaryKey) && this.indexedField.equals(f.indexedField);
    }

    @Override
    public int hashCode() {
        return this.indexedField.hashCode() * 31 + this.primaryKey.hashCode();
    }

    static byte getIndexFieldType(Field indexedFieldType, Field primaryKeyFieldType) {
        if (primaryKeyFieldType instanceof IndexField) {
            throw new IllegalArgumentException();
        }
        if (indexedFieldType instanceof IndexField) {
            throw new IllegalArgumentException();
        }
        return (byte)(primaryKeyFieldType.getFieldType() << 4 | indexedFieldType.getFieldType());
    }

    static IndexField getIndexField(byte fieldType) throws Field.UnsupportedFieldException {
        Field indexedField = Field.getField((byte)(fieldType & 0xF));
        byte primaryKeyFeldType = (byte)(fieldType >> 4 & 0xF);
        if (primaryKeyFeldType == 15) {
            throw new Field.UnsupportedFieldException(fieldType);
        }
        if (primaryKeyFeldType == 8) {
            return new LegacyIndexField(indexedField);
        }
        Field primaryKeyType = Field.getField(primaryKeyFeldType);
        return new IndexField(indexedField, primaryKeyType);
    }
}

