/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.BooleanField;
import db.Buffer;
import db.ByteField;
import db.FixedField10;
import db.IllegalFieldAccessException;
import db.IndexField;
import db.IntField;
import db.LongField;
import db.ShortField;
import db.StringField;
import db.buffers.DataBuffer;
import java.io.IOException;

public abstract class Field
implements Comparable<Field> {
    public static final Field[] EMPTY_ARRAY = new Field[0];
    static final byte BYTE_TYPE = 0;
    static final byte SHORT_TYPE = 1;
    static final byte INT_TYPE = 2;
    static final byte LONG_TYPE = 3;
    static final byte STRING_TYPE = 4;
    static final byte BINARY_OBJ_TYPE = 5;
    static final byte BOOLEAN_TYPE = 6;
    static final byte FIXED_10_TYPE = 7;
    static final byte LEGACY_INDEX_LONG_TYPE = 8;
    static final byte FIELD_RESERVED_15_TYPE = 15;
    static final byte FIELD_TYPE_MASK = 15;
    static final byte INDEX_PRIMARY_KEY_TYPE_MASK = -16;
    static final int INDEX_FIELD_TYPE_SHIFT = 4;
    private final boolean immutable;

    Field() {
        this.immutable = false;
    }

    Field(boolean immutable) {
        this.immutable = immutable;
    }

    void checkImmutable() {
        if (this.immutable) {
            throw new IllegalFieldAccessException("immutable field instance");
        }
    }

    public long getLongValue() {
        throw new IllegalFieldAccessException();
    }

    public void setLongValue(long value) {
        throw new IllegalFieldAccessException();
    }

    public int getIntValue() {
        throw new IllegalFieldAccessException();
    }

    public void setIntValue(int value) {
        throw new IllegalFieldAccessException();
    }

    public short getShortValue() {
        throw new IllegalFieldAccessException();
    }

    public void setShortValue(short value) {
        throw new IllegalFieldAccessException();
    }

    public byte getByteValue() {
        throw new IllegalFieldAccessException();
    }

    public void setByteValue(byte value) {
        throw new IllegalFieldAccessException();
    }

    public boolean getBooleanValue() {
        throw new IllegalFieldAccessException();
    }

    public void setBooleanValue(boolean value) {
        throw new IllegalFieldAccessException();
    }

    public abstract byte[] getBinaryData();

    public abstract void setBinaryData(byte[] var1);

    public String getString() {
        throw new IllegalFieldAccessException();
    }

    public void setString(String str) {
        throw new IllegalFieldAccessException();
    }

    void truncate(int length) {
        throw new UnsupportedOperationException("Field may not be truncated");
    }

    public boolean isVariableLength() {
        return false;
    }

    public boolean isSameType(Field field) {
        return field != null && field.getClass() == this.getClass();
    }

    public abstract Field copyField();

    public abstract Field newField();

    abstract byte getFieldType();

    abstract int write(Buffer var1, int var2) throws IOException;

    abstract int read(Buffer var1, int var2) throws IOException;

    abstract int readLength(Buffer var1, int var2) throws IOException;

    abstract int length();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String getValueAsString();

    abstract Field getMinValue();

    abstract Field getMaxValue();

    public abstract boolean isNull();

    abstract void setNull();

    abstract int compareTo(DataBuffer var1, int var2);

    @Override
    public abstract int compareTo(Field var1);

    static Field getField(byte fieldType) throws UnsupportedFieldException {
        if (fieldType == 136) {
            throw new UnsupportedFieldException(fieldType);
        }
        if ((fieldType & 0xFFFFFFF0) == 0) {
            switch (fieldType & 0xF) {
                case 3: {
                    return LongField.INSTANCE;
                }
                case 2: {
                    return IntField.INSTANCE;
                }
                case 4: {
                    return StringField.INSTANCE;
                }
                case 1: {
                    return ShortField.INSTANCE;
                }
                case 0: {
                    return ByteField.INSTANCE;
                }
                case 6: {
                    return BooleanField.INSTANCE;
                }
                case 5: {
                    return BinaryField.INSTANCE;
                }
                case 7: {
                    return FixedField10.INSTANCE;
                }
            }
        } else {
            return IndexField.getIndexField(fieldType);
        }
        throw new UnsupportedFieldException(fieldType);
    }

    static byte getFixedType(int fixedLength) {
        if (fixedLength == 10) {
            return 7;
        }
        throw new IllegalArgumentException("Unsupported fixed-length binary type size: " + fixedLength);
    }

    static Field getFixedField(int size) {
        switch (size) {
            case 1: {
                return new ByteField();
            }
            case 4: {
                return new IntField();
            }
            case 8: {
                return new LongField();
            }
            case 10: {
                return new FixedField10();
            }
        }
        throw new IllegalArgumentException("Unsupported fixed-field length: " + size);
    }

    public static boolean canIndex(Field field) {
        if (field == null) {
            return false;
        }
        if (field instanceof IndexField) {
            return false;
        }
        return !field.isSameType(BooleanField.INSTANCE) && !field.isSameType(ByteField.INSTANCE);
    }

    public static class UnsupportedFieldException
    extends IOException {
        UnsupportedFieldException(byte fieldType) {
            super("Unsupported DB field type: 0x" + Integer.toHexString(fieldType & 0xFF));
        }

        UnsupportedFieldException(String msg) {
            super(msg);
        }
    }
}

