/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.framework.options.ToolOptions;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;

public class ApplyMarkupItemTask
extends VtTask {
    protected final Collection<VTMarkupItem> markupItems;
    protected final ToolOptions options;

    public ApplyMarkupItemTask(VTSession session, Collection<VTMarkupItem> markupItems, ToolOptions options) {
        this("Apply Markup Items", session, markupItems, options);
    }

    ApplyMarkupItemTask(String title, VTSession session, Collection<VTMarkupItem> markupItems, ToolOptions options) {
        super(title, session);
        this.markupItems = markupItems;
        this.options = options;
    }

    @Override
    protected boolean shouldSuspendSessionEvents() {
        return this.markupItems.size() > 20;
    }

    protected VTMarkupItemApplyActionType getApplyActionType(VTMarkupItem markupItem, ToolOptions markupItemOptions) {
        VTMarkupType markupType = markupItem.getMarkupType();
        VTMarkupItemApplyActionType applyActionType = markupType.getApplyAction(markupItemOptions);
        return applyActionType;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.markupItems.size());
        for (VTMarkupItem markupItem : this.markupItems) {
            monitor.checkCanceled();
            try {
                markupItem.getAssociation().setAccepted();
                VTMarkupItemApplyActionType actionType = this.getApplyActionType(markupItem, this.options);
                if (actionType == null) continue;
                markupItem.apply(actionType, this.options);
                monitor.incrementProgress(1L);
            }
            catch (VTAssociationStatusException | VersionTrackingApplyException e) {
                this.reportError(e);
            }
        }
        return true;
    }
}

