/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.framework.options.SaveState;
import ghidra.util.exception.AssertException;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.ResourceManager;

public abstract class Filter<T> {
    private Set<FilterStatusListener> listeners = new HashSet<FilterStatusListener>();

    public abstract boolean passesFilter(T var1);

    public abstract FilterEditingStatus getFilterStatus();

    public abstract void clearFilter();

    public abstract JComponent getComponent();

    public void dispose() {
        this.listeners.clear();
    }

    public void addFilterStatusListener(FilterStatusListener listener) {
        this.listeners.add(listener);
    }

    protected void fireStatusChanged(FilterEditingStatus status) {
        for (FilterStatusListener listener : this.listeners) {
            listener.filterStatusChanged(status);
        }
    }

    public abstract FilterShortcutState getFilterShortcutState();

    public abstract void readConfigState(SaveState var1);

    public abstract void writeConfigState(SaveState var1);

    public abstract boolean isSubFilterOf(Filter<T> var1);

    public Filter<T> createCopy() {
        Filter<T> copy = this.createEmptyCopy();
        SaveState ss = new SaveState();
        this.writeConfigState(ss);
        copy.readConfigState(ss);
        return copy;
    }

    protected Filter<T> createEmptyCopy() {
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(null);
            Filter newInstance = (Filter)constructor.newInstance(null);
            return newInstance;
        }
        catch (Exception e) {
            throw new AssertException("Exception copying filter '" + clazz.getSimpleName() + "'--missing empty constructor?", (Throwable)e);
        }
    }

    public static enum FilterEditingStatus {
        NONE("", null),
        DIRTY("Filter contents have changed, but are not yet applied", ResourceManager.loadImage((String)"images/bullet_black.png")),
        ERROR("Filter contents are not valid", ResourceManager.loadImage((String)"images/no_small.png")),
        APPLIED("Filter applied", ResourceManager.loadImage((String)"images/bullet_green.png"));

        private final String description;
        private final Icon icon;

        private FilterEditingStatus(String description, Icon icon) {
            this.description = description;
            this.icon = icon;
        }

        String getDescription() {
            return this.description;
        }

        Icon getIcon() {
            return this.icon;
        }
    }

    public static enum FilterShortcutState {
        ALWAYS_PASSES,
        REQUIRES_CHECK,
        NEVER_PASSES;

    }
}

