/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBSymbol;
import agent.lldb.model.iface2.LldbModelTargetSymbolContainer;
import agent.lldb.model.impl.LldbModelTargetModuleImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetSymbolImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SymbolContainer", elements={@TargetElementType(type=LldbModelTargetSymbolImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetSymbolContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetSymbolContainer {
    protected final LldbModelTargetModuleImpl module;

    public LldbModelTargetSymbolContainerImpl(LldbModelTargetModuleImpl module) {
        super(module.getModel(), (TargetObject)module, "Symbols", "SymbolContainer");
        this.module = module;
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listModuleSymbols(this.module.getModule()).thenAccept(byName -> {
            List symbols;
            LldbModelTargetSymbolContainerImpl lldbModelTargetSymbolContainerImpl = this;
            synchronized (lldbModelTargetSymbolContainerImpl) {
                symbols = byName.values().stream().map(this::getTargetSymbol).collect(Collectors.toList());
            }
            this.setElements(symbols, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized LldbModelTargetSymbolImpl getTargetSymbol(SBSymbol symbol) {
        TargetObject targetObject = this.getMapObject(symbol);
        if (targetObject != null) {
            LldbModelTargetSymbolImpl targetSymbol = (LldbModelTargetSymbolImpl)targetObject;
            targetSymbol.setModelObject(symbol);
            return targetSymbol;
        }
        return new LldbModelTargetSymbolImpl(this, symbol);
    }
}

