/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.gadp;

import agent.lldb.gadp.LldbGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.util.classfinder.ExtensionPointProperties;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="LLVM lldb local agent via GADP/TCP", htmlDetails="Launch a new agent using LLVM's lldb.")
@ExtensionPointProperties(priority=100)
public class LldbLocalDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    protected String remote = "none";
    @ConfigurableFactory.FactoryOption(value="DebugConnect options (.server)")
    public final ConfigurableFactory.Property<String> agentRemoteOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentRemote, this::setAgentRemote);
    protected String transport = "none";
    @ConfigurableFactory.FactoryOption(value="Remote process server options (untested)")
    public final ConfigurableFactory.Property<String> agentTransportOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentTransport, this::setAgentTransport);

    public boolean isCompatible() {
        String osname = System.getProperty("os.name");
        return osname.contains("Mac OS X") || osname.contains("Linux") || osname.contains("Windows");
    }

    public String getAgentTransport() {
        return this.transport;
    }

    public void setAgentTransport(String transport) {
        this.transport = transport;
    }

    public String getAgentRemote() {
        return this.remote;
    }

    public void setAgentRemote(String remote) {
        this.remote = remote;
    }

    protected String getThreadName() {
        return "Local LLDB Agent stdout";
    }

    protected Class<?> getServerClass() {
        return LldbGadpServer.class;
    }

    protected void completeCommandLine(List<String> cmd) {
        cmd.add(this.getServerClass().getCanonicalName());
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
    }
}

