/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.analysis.SH4AddressAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SH4EarlyAddressAnalyzer
extends SH4AddressAnalyzer {
    public SH4EarlyAddressAnalyzer() {
        this.setPriority(AnalysisPriority.DISASSEMBLY);
    }

    @Override
    public AddressSetView flowConstants(final Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, final TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                if (refType.isFlow()) {
                    if (address.isExternalAddress()) {
                        return true;
                    }
                    if (instr.getFlowType().isCall()) {
                        SH4EarlyAddressAnalyzer.this.propagateR12ToCall(program, context, address);
                    }
                    if (refType.isComputed()) {
                        boolean doRef = super.evaluateReference(context, instr, pcodeop, address, size, refType);
                        if (!doRef) {
                            return false;
                        }
                        if (SH4EarlyAddressAnalyzer.this.checkComputedRelativeBranch(program, monitor, instr, address, refType, pcodeop)) {
                            return false;
                        }
                        return doRef;
                    }
                }
                return false;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, null, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }
}

