/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.test.AbstractDockingTest;
import ghidra.GhidraTestApplicationLayout;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.TestApplicationUtils;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.mgr.ServiceManager;
import ghidra.program.database.ProgramBuilder;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.OldLanguageMappingService;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.test.ProjectTestUtils;
import ghidra.test.ScriptTaskListener;
import ghidra.test.TestEnv;
import ghidra.test.TestProcessorConstants;
import ghidra.test.TestProgramManager;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.RollbackException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.BeforeClass;
import utility.application.ApplicationLayout;
import utility.function.ExceptionalCallback;
import utility.function.ExceptionalFunction;
import utility.function.ExceptionalSupplier;

public abstract class AbstractGhidraHeadlessIntegrationTest
extends AbstractDockingTest {
    private static final String PROJECT_NAME_SUFFIX = BATCH_MODE ? "_BatchTestProject" : "_DevTestProject";
    public static final String PROJECT_NAME = AbstractGhidraHeadlessIntegrationTest.createProjectName();
    private static Language SLEIGH_X86_64_LANGUAGE;
    private static Language SLEIGH_X86_LANGUAGE;
    private static Language SLEIGH_8051_LANGUAGE;
    private static Language Z80_LANGUAGE;

    private static String createProjectName() {
        File repoDirectory = TestApplicationUtils.getInstallationDirectory();
        return repoDirectory.getName() + PROJECT_NAME_SUFFIX;
    }

    public AbstractGhidraHeadlessIntegrationTest() {
        AbstractGhidraHeadlessIntegrationTest.setErrorGUIEnabled((boolean)false);
    }

    protected ApplicationLayout createApplicationLayout() {
        try {
            return new GhidraTestApplicationLayout(new File(AbstractGhidraHeadlessIntegrationTest.getTestDirectoryPath()));
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }

    protected ApplicationConfiguration createApplicationConfiguration() {
        return new HeadlessGhidraApplicationConfiguration();
    }

    protected void initializeSystemProperties() {
        super.initializeSystemProperties();
        System.setProperty("ghidra.user.scripts.dir", AbstractGhidraHeadlessIntegrationTest.getTestDirectoryPath());
    }

    @BeforeClass
    public static void cleanDbTestDir() {
        if (!BATCH_MODE) {
            TestProgramManager.cleanDbTestDir();
        }
    }

    public static boolean deleteProject(String directory, String name) {
        return ProjectTestUtils.deleteProject(directory, name);
    }

    public static LanguageCompilerSpecPair getLanguageCompilerSpecPair(String oldLanguageName) throws LanguageNotFoundException {
        LanguageCompilerSpecPair pair = OldLanguageMappingService.lookupMagicString((String)oldLanguageName, (boolean)true);
        if (pair == null) {
            throw new LanguageNotFoundException("Old language not found: " + oldLanguageName);
        }
        return pair;
    }

    public static ProgramDB createDefaultProgram(String name, String languageString, Object consumer) throws Exception {
        if (consumer == null) {
            throw new IllegalArgumentException("null consumer not permitted");
        }
        ProgramBuilder builder = new ProgramBuilder(name, languageString, consumer);
        ProgramDB p = builder.getProgram();
        return p;
    }

    public static ProgramDB createDefaultProgram(String name, String languageString, String compilerSpecID, Object consumer) throws Exception {
        if (consumer == null) {
            throw new IllegalArgumentException("null consumer not permitted");
        }
        ProgramBuilder builder = new ProgramBuilder(name, languageString, compilerSpecID, consumer);
        ProgramDB p = builder.getProgram();
        return p;
    }

    public static boolean applyCmd(Program program, Command cmd) throws RollbackException {
        int txId = program.startTransaction(cmd.getName());
        boolean commit = true;
        try {
            boolean status = cmd.applyTo((DomainObject)program);
            program.flushEvents();
            AbstractGhidraHeadlessIntegrationTest.waitForSwing();
            if (!status) {
                Msg.error(null, (Object)("Could not apply command: " + cmd.getStatusMsg()));
            }
            boolean bl = status;
            return bl;
        }
        catch (RollbackException e) {
            commit = false;
            throw e;
        }
        finally {
            program.endTransaction(txId, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void tx(Program p, ExceptionalCallback<E> c) {
        int txId = p.startTransaction("Test - Function in Transaction");
        boolean commit = true;
        try {
            c.call();
            p.flushEvents();
            AbstractGhidraHeadlessIntegrationTest.waitForSwing();
        }
        catch (Exception e) {
            commit = false;
            AbstractGhidraHeadlessIntegrationTest.failWithException((String)("Exception modifying program '" + p.getName() + "'"), (Throwable)e);
        }
        finally {
            p.endTransaction(txId, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T tx(Program p, ExceptionalSupplier<T, E> s) {
        int txId = p.startTransaction("Test - Function in Transaction");
        boolean commit = true;
        try {
            Object t = s.get();
            p.flushEvents();
            AbstractGhidraHeadlessIntegrationTest.waitForSwing();
            Object object = t;
            return (T)object;
        }
        catch (Exception e) {
            commit = false;
            AbstractGhidraHeadlessIntegrationTest.failWithException((String)("Exception modifying program '" + p.getName() + "'"), (Throwable)e);
        }
        finally {
            p.endTransaction(txId, commit);
        }
        return null;
    }

    public static <E extends Exception> void modifyProgram(Program p, ExceptionalCallback<E> c) {
        AbstractGhidraHeadlessIntegrationTest.tx(p, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, E extends Exception> R modifyProgram(Program program, ExceptionalFunction<Program, R, E> f) {
        Assert.assertNotNull((String)"Program cannot be null", (Object)program);
        Object result = null;
        boolean commit = false;
        int tx = program.startTransaction("Test");
        try {
            result = f.apply((Object)program);
            commit = true;
        }
        catch (Exception e) {
            AbstractGhidraHeadlessIntegrationTest.failWithException((String)("Exception modifying program '" + program.getName() + "'"), (Throwable)e);
        }
        finally {
            program.endTransaction(tx, commit);
        }
        return (R)result;
    }

    public static void undo(UndoableDomainObject dobj, boolean wait) {
        Runnable r = () -> {
            try {
                dobj.undo();
                dobj.flushEvents();
            }
            catch (IOException e) {
                Msg.error(AbstractGhidraHeadlessIntegrationTest.class, (Object)"Exception performing undo operation", (Throwable)e);
            }
        };
        AbstractGhidraHeadlessIntegrationTest.runSwing((Runnable)r, (boolean)wait);
        if (wait) {
            AbstractGhidraHeadlessIntegrationTest.waitForSwing();
        }
    }

    public static void redo(UndoableDomainObject dobj, boolean wait) {
        Runnable r = () -> {
            try {
                dobj.redo();
                dobj.flushEvents();
            }
            catch (IOException e) {
                Msg.error(AbstractGhidraHeadlessIntegrationTest.class, (Object)"Exception performing redo operation", (Throwable)e);
            }
        };
        AbstractGhidraHeadlessIntegrationTest.runSwing((Runnable)r, (boolean)wait);
        if (wait) {
            AbstractGhidraHeadlessIntegrationTest.waitForSwing();
        }
    }

    public static void undo(UndoableDomainObject dobj) {
        AbstractGhidraHeadlessIntegrationTest.undo(dobj, true);
    }

    public static void redo(UndoableDomainObject dobj) {
        AbstractGhidraHeadlessIntegrationTest.redo(dobj, true);
    }

    public static void undo(UndoableDomainObject dobj, int count) {
        for (int i = 0; i < count; ++i) {
            AbstractGhidraHeadlessIntegrationTest.undo(dobj);
        }
    }

    public static void redo(UndoableDomainObject dobj, int count) {
        for (int i = 0; i < count; ++i) {
            AbstractGhidraHeadlessIntegrationTest.redo(dobj);
        }
    }

    public static <T extends Plugin> T getPlugin(PluginTool tool, Class<T> c) {
        List list = tool.getManagedPlugins();
        for (Plugin p : list) {
            if (p.getClass() != c) continue;
            return (T)((Plugin)c.cast(p));
        }
        return null;
    }

    public AddressSet toAddressSet(List<Address> addrs) {
        AddressSet set = new AddressSet();
        for (Address addr : addrs) {
            set.add(addr);
        }
        return set;
    }

    public AddressSet toAddressSet(Address start, Address end) {
        AddressSet set = new AddressSet();
        set.addRange(start, end);
        return set;
    }

    public AddressSet toAddressSet(AddressRange ... ranges) {
        AddressSet set = new AddressSet();
        for (AddressRange range : ranges) {
            set.add(range);
        }
        return set;
    }

    public void goTo(PluginTool tool, Program p, Address addr) {
        GoToService goTo = (GoToService)tool.getService(GoToService.class);
        if (goTo != null) {
            goTo.goTo(addr);
            AbstractGhidraHeadlessIntegrationTest.waitForSwing();
            return;
        }
        tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent("Test", new ProgramLocation(p, addr), p));
        AbstractGhidraHeadlessIntegrationTest.waitForSwing();
    }

    public void goTo(PluginTool tool, Program p, String addrString) {
        AddressFactory factory = p.getAddressFactory();
        Address addr = factory.getAddress(addrString);
        tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent("Test", new ProgramLocation(p, addr), p));
        AbstractGhidraHeadlessIntegrationTest.waitForSwing();
    }

    public void makeSelection(PluginTool tool, Program p, List<Address> addrs) {
        AddressSet set = this.toAddressSet(addrs);
        this.makeSelection(tool, p, (AddressSetView)set);
    }

    public void makeSelection(PluginTool tool, Program p, Address from, Address to) {
        ProgramSelection selection = new ProgramSelection(from, to);
        tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("Test", selection, p));
        AbstractGhidraHeadlessIntegrationTest.waitForSwing();
    }

    public void makeSelection(PluginTool tool, Program p, AddressRange ... ranges) {
        AddressSet set = this.toAddressSet(ranges);
        this.makeSelection(tool, p, (AddressSetView)set);
    }

    public void makeSelection(PluginTool tool, Program p, AddressSetView addresses) {
        ProgramSelection selection = new ProgramSelection(addresses);
        tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("Test", selection, p));
        AbstractGhidraHeadlessIntegrationTest.waitForSwing();
    }

    public Symbol getUniqueSymbol(Program program, String name) {
        return this.getUniqueSymbol(program, name, null);
    }

    public Symbol getUniqueSymbol(Program program, String name, Namespace namespace) {
        List symbols = program.getSymbolTable().getSymbols(name, namespace);
        if (symbols.size() == 1) {
            return (Symbol)symbols.get(0);
        }
        return null;
    }

    public void debugProgramInTool(Program p, String address) throws Exception {
        if (BATCH_MODE) {
            throw new AssertionFailedError("Take out the call to this method--it is for debugging only");
        }
        long duration = 5L;
        TestEnv env = new TestEnv();
        try {
            PluginTool tool = env.launchDefaultTool(p);
            CodeBrowserPlugin plugin = AbstractGhidraHeadlessIntegrationTest.getPlugin(tool, CodeBrowserPlugin.class);
            if (address != null) {
                plugin.goToField(p.getAddressFactory().getAddress(address), "Address", 0, 0);
            }
            Msg.info((Object)((Object)this), (Object)"Opened test program in tool");
            long minutesInMillis = 60000L * duration;
            AbstractGhidraHeadlessIntegrationTest.sleep((long)minutesInMillis);
            throw new AssertionFailedError("Take out the call to this method--it is for debugging only");
        }
        catch (Throwable throwable) {
            env.dispose();
            throw throwable;
        }
    }

    public void waitForScriptCompletion(ScriptTaskListener listener, long timeoutMS) {
        String scriptName = listener.getScriptName();
        long start = System.currentTimeMillis();
        Msg.debug((Object)((Object)this), (Object)("Waiting for script " + scriptName + ": " + new Date(start)));
        while (!listener.isCompleted()) {
            AbstractGhidraHeadlessIntegrationTest.sleep((long)DEFAULT_WAIT_DELAY);
            long currentTime = System.currentTimeMillis();
            if (currentTime - start <= timeoutMS) continue;
            Msg.error((Object)((Object)this), (Object)("Timeout on script: " + scriptName + ": " + new Date(currentTime)));
            throw new RuntimeException("Timeout waiting for task to complete");
        }
        Msg.debug((Object)((Object)this), (Object)("Script " + scriptName + " completed: " + new Date(System.currentTimeMillis())));
    }

    public static <T> void replaceService(PluginTool tool, Class<? extends T> service, T replacement) {
        ServiceManager serviceManager = (ServiceManager)AbstractGhidraHeadlessIntegrationTest.getInstanceField((String)"serviceMgr", (Object)tool);
        List extentions = (List)AbstractGhidraHeadlessIntegrationTest.getInstanceField((String)"extensionPoints", ClassSearcher.class);
        HashSet set = new HashSet(extentions);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Class c = (Class)iterator.next();
            if (!service.isAssignableFrom(c)) continue;
            iterator.remove();
            Object instance = tool.getService(service);
            serviceManager.removeService(service, instance);
        }
        Object instance = tool.getService(service);
        if (instance != null) {
            serviceManager.removeService(service, instance);
        }
        set.add(replacement.getClass());
        serviceManager.addService(service, replacement);
        ArrayList newExtensionPoints = new ArrayList(set);
        AbstractGhidraHeadlessIntegrationTest.setInstanceField((String)"extensionPoints", ClassSearcher.class, newExtensionPoints);
    }

    public static synchronized LanguageService getLanguageService() {
        return DefaultLanguageService.getLanguageService();
    }

    public static Language getSLEIGH_X86_LANGUAGE() {
        if (SLEIGH_X86_LANGUAGE == null) {
            try {
                SLEIGH_X86_LANGUAGE = AbstractGhidraHeadlessIntegrationTest.getLanguageService().getDefaultLanguage(TestProcessorConstants.PROCESSOR_X86);
            }
            catch (LanguageNotFoundException languageNotFoundException) {
                // empty catch block
            }
        }
        return SLEIGH_X86_LANGUAGE;
    }

    public static Language getSLEIGH_X86_64_LANGUAGE() {
        if (SLEIGH_X86_64_LANGUAGE == null) {
            try {
                SLEIGH_X86_64_LANGUAGE = AbstractGhidraHeadlessIntegrationTest.getLanguageService().getLanguage(new LanguageID("x86:LE:64:default"));
            }
            catch (LanguageNotFoundException languageNotFoundException) {
                // empty catch block
            }
        }
        return SLEIGH_X86_64_LANGUAGE;
    }

    public static Language getSLEIGH_8051_LANGUAGE() {
        if (SLEIGH_8051_LANGUAGE == null) {
            try {
                SLEIGH_8051_LANGUAGE = AbstractGhidraHeadlessIntegrationTest.getLanguageService().getDefaultLanguage(TestProcessorConstants.PROCESSOR_8051);
            }
            catch (LanguageNotFoundException languageNotFoundException) {
                // empty catch block
            }
        }
        return SLEIGH_8051_LANGUAGE;
    }

    public static Language getZ80_LANGUAGE() {
        if (Z80_LANGUAGE == null) {
            try {
                Z80_LANGUAGE = AbstractGhidraHeadlessIntegrationTest.getLanguageService().getDefaultLanguage(TestProcessorConstants.PROCESSOR_Z80);
            }
            catch (LanguageNotFoundException languageNotFoundException) {
                // empty catch block
            }
        }
        return Z80_LANGUAGE;
    }
}

