/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.OperandFieldHelper;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;

public class OperandFieldFactory
extends OperandFieldHelper {
    public static final String FIELD_NAME = "Operands";

    public OperandFieldFactory() {
        super(FIELD_NAME);
    }

    protected OperandFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        return super.getField(proxy.getObject(), proxy, varWidth);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField lf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof OperandFieldLocation)) {
            return null;
        }
        OperandFieldLocation loc = (OperandFieldLocation)programLoc;
        if (!this.hasSamePath(lf, (ProgramLocation)loc)) {
            return null;
        }
        return this.getFieldLocation(index, fieldNum, lf, loc.getOperandIndex(), loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider hsProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new OperandFieldFactory(formatModel, hsProvider, displayOptions, fieldOptions);
    }
}

