/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import db.DBHandle;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public class GzfLoader
implements Loader {
    public static final String GZF_NAME = "GZF Input Format";

    @Override
    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 0;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null && options.size() > 0) {
            return "GzfLoader takes no options";
        }
        return null;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomainObject> load(ByteProvider provider, String programName, DomainFolder programFolder, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        DomainObject dobj;
        if (programFolder == null) {
            dobj = this.loadPackedProgramDatabase(provider, programName, consumer, monitor);
        } else {
            DomainFile df = this.doLoad(provider, programName, programFolder, monitor);
            boolean success = false;
            try {
                if (!"Program".equals(df.getContentType())) {
                    throw new IOException("File imported is not a Program: " + programName);
                }
                monitor.setMessage("Opening " + programName);
                dobj = df.getDomainObject(consumer, true, false, monitor);
                success = true;
            }
            finally {
                if (!success) {
                    df.delete();
                }
            }
        }
        ArrayList<DomainObject> results = new ArrayList<DomainObject>();
        results.add(dobj);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainObject loadPackedProgramDatabase(ByteProvider provider, String programName, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException, LanguageNotFoundException {
        File file = provider.getFile();
        File tmpFile = null;
        if (file == null) {
            file = tmpFile = GzfLoader.createTmpFile(provider, monitor);
        }
        try {
            ProgramDB dobj;
            PackedDatabase packedDatabase = PackedDatabase.getPackedDatabase((File)file, (boolean)true, (TaskMonitor)monitor);
            boolean success = false;
            DBHandle dbh = null;
            try {
                if (!"Program".equals(packedDatabase.getContentType())) {
                    throw new IOException("File imported is not a Program: " + programName);
                }
                monitor.setMessage("Restoring " + provider.getName());
                dbh = packedDatabase.open(monitor);
                dobj = new ProgramDB(dbh, 3, monitor, consumer);
                success = true;
            }
            finally {
                if (!success) {
                    if (dbh != null) {
                        dbh.close();
                    } else {
                        packedDatabase.dispose();
                    }
                }
            }
            ProgramDB programDB = dobj;
            return programDB;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    public boolean loadInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Program program, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException("cannot add GZF to program");
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (GzfLoader.isGzfFile(provider)) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, false));
        }
        return loadSpecs;
    }

    @Override
    public String getPreferredFileName(ByteProvider provider) {
        return FilenameUtils.removeExtension((String)provider.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainFile doLoad(ByteProvider provider, String programName, DomainFolder programFolder, TaskMonitor monitor) throws InvalidNameException, CancelledException, IOException {
        File file = provider.getFile();
        File tmpFile = null;
        if (file == null) {
            file = tmpFile = GzfLoader.createTmpFile(provider, monitor);
        }
        DomainFolder folder = programFolder;
        monitor.setMessage("Restoring " + provider.getName());
        try {
            DomainFile df;
            DomainFile domainFile = df = folder.createFile(programName, file, monitor);
            return domainFile;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private static File createTmpFile(ByteProvider provider, TaskMonitor monitor) throws IOException {
        File tmpFile = File.createTempFile("ghidra_gzf_loader", null);
        try (InputStream is = provider.getInputStream(0L);
             FileOutputStream fos = new FileOutputStream(tmpFile);){
            FileUtilities.copyStreamToStream((InputStream)is, (OutputStream)fos, (TaskMonitor)monitor);
        }
        return tmpFile;
    }

    private static boolean isGzfFile(ByteProvider provider) {
        if (!provider.getName().toLowerCase().endsWith(".gzf")) {
            return false;
        }
        boolean isGZF = false;
        try (InputStream inputStream = provider.getInputStream(0L);){
            isGZF = ItemSerializer.isPackedFile((InputStream)inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isGZF;
    }

    @Override
    public String getName() {
        return GZF_NAME;
    }
}

