/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import generic.stl.Pair;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.importer.LcsHintLoadSpecChooser;
import ghidra.app.util.importer.LoadSpecChooser;
import ghidra.app.util.importer.LoaderArgsOptionChooser;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MultipleProgramsStrategy;
import ghidra.app.util.importer.OptionChooser;
import ghidra.app.util.importer.SingleLoaderFilter;
import ghidra.app.util.opinion.BinaryLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class AutoImporter {
    private static final Predicate<Loader> BINARY_LOADER = new SingleLoaderFilter(BinaryLoader.class);

    private AutoImporter() {
    }

    public static Program importByUsingBestGuess(File file, DomainFolder programFolder, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        List<Program> programs = AutoImporter.importFresh(file, programFolder, consumer, messageLog, monitor, LoaderService.ACCEPT_ALL, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, null, OptionChooser.DEFAULT_OPTIONS, MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static Program importByUsingBestGuess(ByteProvider provider, DomainFolder programFolder, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        List<Program> programs = AutoImporter.importFresh(provider, programFolder, consumer, messageLog, monitor, LoaderService.ACCEPT_ALL, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, null, OptionChooser.DEFAULT_OPTIONS, MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static Program importByUsingSpecificLoaderClass(File file, DomainFolder programFolder, Class<? extends Loader> loaderClass, List<Pair<String, String>> loaderArgs, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        SingleLoaderFilter loaderFilter = new SingleLoaderFilter(loaderClass, loaderArgs);
        List<Program> programs = AutoImporter.importFresh(file, programFolder, consumer, messageLog, monitor, (Predicate<Loader>)loaderFilter, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, null, (OptionChooser)new LoaderArgsOptionChooser(loaderFilter), MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static Program importByLookingForLcs(File file, DomainFolder programFolder, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        List<Program> programs = AutoImporter.importFresh(file, programFolder, consumer, messageLog, monitor, LoaderService.ACCEPT_ALL, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, OptionChooser.DEFAULT_OPTIONS, MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static Program importByUsingSpecificLoaderClassAndLcs(File file, DomainFolder programFolder, Class<? extends Loader> loaderClass, List<Pair<String, String>> loaderArgs, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        SingleLoaderFilter loaderFilter = new SingleLoaderFilter(loaderClass, loaderArgs);
        List<Program> programs = AutoImporter.importFresh(file, programFolder, consumer, messageLog, monitor, (Predicate<Loader>)loaderFilter, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, (OptionChooser)new LoaderArgsOptionChooser(loaderFilter), MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static Program importAsBinary(File file, DomainFolder programFolder, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        List<Program> programs = AutoImporter.importFresh(file, programFolder, consumer, messageLog, monitor, BINARY_LOADER, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, OptionChooser.DEFAULT_OPTIONS, MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static Program importAsBinary(ByteProvider bytes, DomainFolder programFolder, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        List<Program> programs = AutoImporter.importFresh(bytes, programFolder, consumer, messageLog, monitor, BINARY_LOADER, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, OptionChooser.DEFAULT_OPTIONS, MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public static List<Program> importFresh(File file, DomainFolder programFolder, Object consumer, MessageLog messageLog, TaskMonitor monitor, Predicate<Loader> loaderFilter, LoadSpecChooser loadSpecChooser, String programNameOverride, OptionChooser optionChooser, MultipleProgramsStrategy multipleProgramsStrategy) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        if (file == null) {
            return null;
        }
        try (RandomAccessByteProvider provider = new RandomAccessByteProvider(file);){
            List<Program> list = AutoImporter.importFresh(provider, programFolder, consumer, messageLog, monitor, loaderFilter, loadSpecChooser, programNameOverride, optionChooser, multipleProgramsStrategy);
            return list;
        }
    }

    public static List<Program> importFresh(ByteProvider provider, DomainFolder programFolder, Object consumer, MessageLog messageLog, TaskMonitor monitor, Predicate<Loader> loaderFilter, LoadSpecChooser loadSpecChooser, String programNameOverride, OptionChooser optionChooser, MultipleProgramsStrategy multipleProgramsStrategy) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        List<Option> loaderOptions;
        if (provider == null) {
            return null;
        }
        LoadSpec loadSpec = AutoImporter.getLoadSpec(loaderFilter, loadSpecChooser, provider);
        if (loadSpec == null) {
            return null;
        }
        String programName = loadSpec.getLoader().getPreferredFileName(provider);
        if (programNameOverride != null) {
            programName = programNameOverride;
        }
        LanguageCompilerSpecPair languageCompilerSpecPair = loadSpec.getLanguageCompilerSpec();
        AddressFactory addrFactory = null;
        if (languageCompilerSpecPair != null) {
            addrFactory = DefaultLanguageService.getLanguageService().getLanguage(languageCompilerSpecPair.languageID).getAddressFactory();
        }
        if ((loaderOptions = optionChooser.choose(loadSpec.getLoader().getDefaultOptions(provider, loadSpec, null, false), addrFactory)) == null) {
            return null;
        }
        Msg.info(AutoImporter.class, (Object)("Using Loader: " + loadSpec.getLoader().getName()));
        List<DomainObject> domainObjects = loadSpec.getLoader().load(provider, programName, programFolder, loadSpec, loaderOptions, messageLog, consumer, monitor);
        return multipleProgramsStrategy.handlePrograms(AutoImporter.getPrograms(domainObjects), consumer);
    }

    private static LoadSpec getLoadSpec(Predicate<Loader> loaderFilter, LoadSpecChooser loadSpecChooser, ByteProvider provider) {
        LoaderMap loaderMap = LoaderService.getSupportedLoadSpecs(provider, loaderFilter);
        LoadSpec loadSpec = loadSpecChooser.choose(loaderMap);
        if (loadSpec != null) {
            return loadSpec;
        }
        File f = provider.getFile();
        String name = f != null ? f.getAbsolutePath() : provider.getName();
        Msg.info(AutoImporter.class, (Object)("No load spec found for import file: " + name));
        return null;
    }

    private static List<Program> getPrograms(List<DomainObject> domainObjects) {
        ArrayList<Program> programs = new ArrayList<Program>();
        for (DomainObject domainObject : domainObjects) {
            if (!(domainObject instanceof Program)) continue;
            programs.add((Program)domainObject);
        }
        return programs;
    }
}

