/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.prelink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MachoPrelinkMap {
    private Map<String, Object> map = new HashMap<String, Object>();

    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public void put(String key, long value) {
        this.map.put(key, value);
    }

    public void put(String key, boolean value) {
        this.map.put(key, value);
    }

    public void put(String key, MachoPrelinkMap value) {
        this.map.put(key, value);
    }

    public String getPrelinkBundlePath() {
        Object value = this.map.get("_PrelinkBundlePath");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getPrelinkUUID() {
        Object value = this.map.get("_PrelinkInterfaceUUID");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public long getPrelinkKmodInfo() {
        Object value = this.map.get("_PrelinkKmodInfo");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value).intValue() + 0xFFFFFFFFL;
        }
        return -1L;
    }

    public long getPrelinkExecutable() {
        Object value = this.map.get("_PrelinkExecutable");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value).intValue() + 0xFFFFFFFFL;
        }
        return -1L;
    }

    public long getPrelinkExecutableSize() {
        Object value = this.map.get("_PrelinkExecutableSize");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value).intValue() + 0xFFFFFFFFL;
        }
        return -1L;
    }

    public long getPrelinkExecutableLoadAddr() {
        Object value = this.map.get("_PrelinkExecutableLoadAddr");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value).intValue() + 0xFFFFFFFFL;
        }
        return -1L;
    }

    public long getPrelinkModuleIndex() {
        Object value = this.map.get("ModuleIndex");
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value).intValue() + 0xFFFFFFFFL;
        }
        return -1L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> keyList = new ArrayList<String>(this.map.keySet());
        Collections.sort(keyList);
        for (String key : keyList) {
            Object value = this.map.get(key);
            if (value instanceof Long) {
                long longValue = (Long)value;
                buffer.append(key + "=0x" + Long.toHexString(longValue) + "\n");
                continue;
            }
            buffer.append(key + "=" + value + "\n");
        }
        return buffer.toString();
    }
}

