/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.BuildVersionCommand;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.DyldExportsTrieCommand;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLinkerCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.EncryptedInformationCommand;
import ghidra.app.util.bin.format.macho.commands.EntryPointCommand;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.FixedVirtualMemoryFileCommand;
import ghidra.app.util.bin.format.macho.commands.FixedVirtualMemorySharedLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.FunctionStartsCommand;
import ghidra.app.util.bin.format.macho.commands.IdentCommand;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.LinkerOptionCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.PrebindChecksumCommand;
import ghidra.app.util.bin.format.macho.commands.PreboundDynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.RoutinesCommand;
import ghidra.app.util.bin.format.macho.commands.RunPathCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SourceVersionCommand;
import ghidra.app.util.bin.format.macho.commands.SubClientCommand;
import ghidra.app.util.bin.format.macho.commands.SubFrameworkCommand;
import ghidra.app.util.bin.format.macho.commands.SubLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.SubUmbrellaCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.TwoLevelHintsCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.bin.format.macho.commands.UuidCommand;
import ghidra.app.util.bin.format.macho.commands.VersionMinCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadCommand;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.util.Msg;
import java.io.IOException;

public class LoadCommandFactory {
    public static LoadCommand getLoadCommand(BinaryReader reader, MachHeader header, DyldCacheUtils.SplitDyldCache splitDyldCache) throws IOException, MachException {
        int type = reader.peekNextInt();
        switch (type) {
            case 1: {
                return new SegmentCommand(reader, header.is32bit());
            }
            case 2: {
                return new SymbolTableCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache), header);
            }
            case 3: {
                return new SymbolCommand(reader);
            }
            case 4: 
            case 5: {
                return new ThreadCommand(reader, header);
            }
            case 6: 
            case 7: {
                return new FixedVirtualMemorySharedLibraryCommand(reader);
            }
            case 8: {
                return new IdentCommand(reader);
            }
            case 9: {
                return new FixedVirtualMemoryFileCommand(reader);
            }
            case 10: {
                return new UnsupportedLoadCommand(reader, type);
            }
            case 11: {
                return new DynamicSymbolTableCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache), header);
            }
            case -2147483613: 
            case 12: 
            case 13: {
                return new DynamicLibraryCommand(reader);
            }
            case 14: 
            case 15: 
            case 39: {
                return new DynamicLinkerCommand(reader);
            }
            case 16: {
                return new PreboundDynamicLibraryCommand(reader);
            }
            case 17: {
                return new RoutinesCommand(reader, header.is32bit());
            }
            case 18: {
                return new SubFrameworkCommand(reader);
            }
            case 19: {
                return new SubUmbrellaCommand(reader);
            }
            case 20: {
                return new SubClientCommand(reader);
            }
            case 21: {
                return new SubLibraryCommand(reader);
            }
            case 22: {
                return new TwoLevelHintsCommand(reader);
            }
            case 23: {
                return new PrebindChecksumCommand(reader);
            }
            case -2147483624: {
                return new DynamicLibraryCommand(reader);
            }
            case 25: {
                return new SegmentCommand(reader, header.is32bit());
            }
            case 26: {
                return new RoutinesCommand(reader, header.is32bit());
            }
            case 27: {
                return new UuidCommand(reader);
            }
            case -2147483620: {
                return new RunPathCommand(reader);
            }
            case 29: 
            case 30: 
            case 41: 
            case 43: 
            case 46: {
                return new LinkEditDataCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
            }
            case -2147483617: {
                return new DynamicLibraryCommand(reader);
            }
            case 33: 
            case 44: {
                return new EncryptedInformationCommand(reader, header.is32bit());
            }
            case -2147483614: 
            case 34: {
                return new DyldInfoCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache), header);
            }
            case 36: 
            case 37: 
            case 47: 
            case 48: {
                return new VersionMinCommand(reader);
            }
            case 38: {
                return new FunctionStartsCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
            }
            case -2147483608: {
                return new EntryPointCommand(reader);
            }
            case 42: {
                return new SourceVersionCommand(reader);
            }
            case 32: {
                return new DynamicLibraryCommand(reader);
            }
            case 45: {
                return new LinkerOptionCommand(reader);
            }
            case 50: {
                return new BuildVersionCommand(reader);
            }
            case -2147483597: {
                return new DyldExportsTrieCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
            }
            case -2147483596: {
                return new DyldChainedFixupsCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
            }
            case -2147483595: {
                return new FileSetEntryCommand(reader);
            }
        }
        Msg.warn((Object)header, (Object)("Unsupported load command " + Integer.toHexString(type)));
        return new UnsupportedLoadCommand(reader, type);
    }

    private static BinaryReader getLinkerLoadCommandReader(BinaryReader reader, MachHeader header, DyldCacheUtils.SplitDyldCache splitDyldCache) throws MachException {
        if (splitDyldCache == null) {
            return reader.clone();
        }
        SegmentCommand linkEdit = header.getSegment("__LINKEDIT");
        if (linkEdit != null) {
            for (int i = 0; i < splitDyldCache.size(); ++i) {
                DyldCacheHeader dyldCacheHeader = splitDyldCache.getDyldCacheHeader(i);
                for (DyldCacheMappingInfo mappingInfo : dyldCacheHeader.getMappingInfos()) {
                    if (!mappingInfo.contains(linkEdit.getVMaddress())) continue;
                    return new BinaryReader(splitDyldCache.getProvider(i), true);
                }
            }
        }
        throw new MachException("__LINKEDIT segment not found in DYLD cache");
    }
}

