/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.CpuTypes;
import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeaderFileTypes;
import ghidra.app.util.bin.format.macho.MachHeaderFlags;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandFactory;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MachHeader
implements StructConverter {
    private int magic;
    private int cpuType;
    private int cpuSubType;
    private int fileType;
    private int nCmds;
    private int sizeOfCmds;
    private int flags;
    private int reserved;
    private boolean _is32bit;
    private List<LoadCommand> _commands = new ArrayList<LoadCommand>();
    private long _commandIndex;
    private BinaryReader _reader;
    private long _machHeaderStartIndexInProvider;
    private long _machHeaderStartIndex = 0L;
    private boolean _parsed = false;

    public static boolean isMachHeader(ByteProvider provider) {
        try {
            return provider.length() > 4L && MachConstants.isMagic(MachHeader.readMagic(provider, 0L));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public MachHeader(ByteProvider provider) throws IOException, MachException {
        this(provider, 0L);
    }

    public MachHeader(ByteProvider provider, long machHeaderStartIndexInProvider) throws IOException, MachException {
        this(provider, machHeaderStartIndexInProvider, true);
    }

    public MachHeader(ByteProvider provider, long machHeaderStartIndexInProvider, boolean isRemainingMachoRelativeToStartIndex) throws IOException, MachException {
        this.magic = MachHeader.readMagic(provider, machHeaderStartIndexInProvider);
        if (!MachConstants.isMagic(this.magic)) {
            throw new MachException("Invalid Mach-O binary.");
        }
        if (isRemainingMachoRelativeToStartIndex) {
            this._machHeaderStartIndex = machHeaderStartIndexInProvider;
        }
        this._machHeaderStartIndexInProvider = machHeaderStartIndexInProvider;
        this._reader = new BinaryReader(provider, this.isLittleEndian());
        this._reader.setPointerIndex(machHeaderStartIndexInProvider + 4L);
        this.cpuType = this._reader.readNextInt();
        this.cpuSubType = this._reader.readNextInt();
        this.fileType = this._reader.readNextInt();
        this.nCmds = this._reader.readNextInt();
        this.sizeOfCmds = this._reader.readNextInt();
        this.flags = this._reader.readNextInt();
        boolean bl = this._is32bit = (this.cpuType & 0x1000000) == 0;
        if (!this._is32bit) {
            this.reserved = this._reader.readNextInt();
        }
        this._commandIndex = this._reader.getPointerIndex();
    }

    public MachHeader parse() throws IOException, MachException {
        return this.parse(null);
    }

    public MachHeader parse(DyldCacheUtils.SplitDyldCache splitDyldCache) throws IOException, MachException {
        if (this._parsed) {
            return this;
        }
        long currentIndex = this._commandIndex;
        ArrayList<Long> segmentIndexes = new ArrayList<Long>();
        ArrayList<Long> nonSegmentIndexes = new ArrayList<Long>();
        for (int i = 0; i < this.nCmds; ++i) {
            this._reader.setPointerIndex(currentIndex);
            int type = this._reader.readNextInt();
            int size = this._reader.readNextInt();
            if (type == 1 || type == 25) {
                segmentIndexes.add(currentIndex);
            } else {
                nonSegmentIndexes.add(currentIndex);
            }
            currentIndex += (long)size;
        }
        ArrayList<Long> combinedIndexes = new ArrayList<Long>();
        combinedIndexes.addAll(segmentIndexes);
        combinedIndexes.addAll(nonSegmentIndexes);
        for (Long index : combinedIndexes) {
            this._reader.setPointerIndex(index);
            LoadCommand lc = LoadCommandFactory.getLoadCommand(this._reader, this, splitDyldCache);
            this._commands.add(lc);
        }
        this._parsed = true;
        return this;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getCpuType() {
        return this.cpuType;
    }

    public long getImageBase() {
        return 0L;
    }

    public int getCpuSubType() {
        return this.cpuSubType;
    }

    public int getFileType() {
        return this.fileType;
    }

    public int getNumberOfCommands() {
        return this.nCmds;
    }

    public int getSizeOfCommands() {
        return this.sizeOfCmds;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getReserved() throws MachException {
        if (this._is32bit) {
            throw new MachException("Field does not exist for 32 bit Mach-O files.");
        }
        return this.reserved;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("mach_header", 0);
        struct.add(DWORD, "magic", null);
        struct.add(DWORD, "cputype", null);
        struct.add(DWORD, "cpusubtype", null);
        struct.add(DWORD, "filetype", null);
        struct.add(DWORD, "ncmds", null);
        struct.add(DWORD, "sizeofcmds", null);
        struct.add(DWORD, "flags", null);
        if (!this._is32bit) {
            struct.add(DWORD, "reserved", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public long getStartIndex() {
        return this._machHeaderStartIndex;
    }

    public long getStartIndexInProvider() {
        return this._machHeaderStartIndexInProvider;
    }

    public boolean is32bit() {
        return this._is32bit;
    }

    public int getAddressSize() {
        return this._is32bit ? 4 : 8;
    }

    public List<SegmentCommand> getAllSegments() {
        return this.getLoadCommands(SegmentCommand.class);
    }

    public SegmentCommand getSegment(String segmentName) {
        for (SegmentCommand segment : this.getAllSegments()) {
            if (!segment.getSegmentName().equals(segmentName)) continue;
            return segment;
        }
        return null;
    }

    public Section getSection(String segmentName, String sectionName) {
        SegmentCommand segment = this.getSegment(segmentName);
        if (segment != null) {
            return segment.getSectionByName(sectionName);
        }
        return null;
    }

    public List<Section> getAllSections() {
        ArrayList<Section> tmp = new ArrayList<Section>();
        for (SegmentCommand segment : this.getAllSegments()) {
            tmp.addAll(segment.getSections());
        }
        return tmp;
    }

    public List<LoadCommand> getLoadCommands() {
        return this._commands;
    }

    public <T> List<T> getLoadCommands(Class<T> classType) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (LoadCommand command : this._commands) {
            if (!classType.isAssignableFrom(command.getClass())) continue;
            tmp.add(classType.cast(command));
        }
        return tmp;
    }

    public <T> T getFirstLoadCommand(Class<T> classType) {
        for (LoadCommand command : this._commands) {
            if (!classType.isAssignableFrom(command.getClass())) continue;
            return classType.cast(command);
        }
        return null;
    }

    public boolean isLittleEndian() {
        return this.magic == -822415874 || this.magic == -805638658;
    }

    public long getSize() {
        return this._commandIndex - this._machHeaderStartIndexInProvider;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Magic: 0x" + Integer.toHexString(this.magic));
        buffer.append('\n');
        buffer.append("CPU Type: " + CpuTypes.getProcessor(this.cpuType, this.cpuSubType).toString());
        buffer.append('\n');
        buffer.append("File Type: " + MachHeaderFileTypes.getFileTypeName(this.fileType));
        buffer.append('\n');
        buffer.append("Flags: 0x" + Integer.toBinaryString(this.flags));
        buffer.append('\n');
        buffer.append(MachHeaderFlags.getFlags(this.flags));
        buffer.append('\n');
        return buffer.toString();
    }

    public String toString() {
        return this.getDescription();
    }

    private static int readMagic(ByteProvider provider, long machHeaderStartIndexInProvider) throws IOException {
        BinaryReader br = new BinaryReader(provider, false);
        return br.readInt(machHeaderStartIndexInProvider);
    }
}

