/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class DWARFLine {
    private long unit_length;
    private int format;
    private int version;
    private long header_length;
    private int minimum_instruction_length;
    private int maximum_operations_per_instruction;
    private int default_is_stmt;
    private int line_base;
    private int line_range;
    private int opcode_base;
    private int[] standard_opcode_length;
    private List<String> include_directories;
    private List<DWARFFile> file_names;

    public static DWARFLine read(DIEAggregate diea) throws IOException, DWARFException {
        DWARFProgram dProg = diea.getProgram();
        BinaryReader reader = dProg.getDebugLine();
        long stmtListOffset = diea.getUnsignedLong(16, -1L);
        if (reader == null || stmtListOffset < 0L) {
            return null;
        }
        reader.setPointerIndex(stmtListOffset);
        DWARFLine result = new DWARFLine();
        DWARFUtil.LengthResult lengthInfo = DWARFUtil.readLength(reader, dProg.getGhidraProgram());
        result.unit_length = lengthInfo.length;
        result.format = lengthInfo.format;
        if (result.unit_length == 0L) {
            throw new DWARFException("Invalid DWARFLine length 0 at 0x" + Long.toHexString(stmtListOffset));
        }
        result.version = reader.readNextUnsignedShort();
        result.header_length = DWARFUtil.readOffsetByDWARFformat(reader, result.format);
        result.minimum_instruction_length = reader.readNextUnsignedByte();
        result.maximum_operations_per_instruction = result.version >= 4 ? reader.readNextUnsignedByte() : 1;
        result.default_is_stmt = reader.readNextUnsignedByte();
        result.line_base = reader.readNextByte();
        result.line_range = reader.readNextUnsignedByte();
        result.opcode_base = reader.readNextUnsignedByte();
        result.standard_opcode_length = new int[result.opcode_base];
        result.standard_opcode_length[0] = 1;
        for (int i = 1; i < result.opcode_base; ++i) {
            result.standard_opcode_length[i] = reader.readNextUnsignedByte();
        }
        result.include_directories = new ArrayList<String>();
        String include = reader.readNextAsciiString();
        while (include.length() != 0) {
            result.include_directories.add(include);
            include = reader.readNextAsciiString();
        }
        result.file_names = new ArrayList<DWARFFile>();
        DWARFFile file = new DWARFFile(reader);
        while (file.getName().length() != 0) {
            result.file_names.add(file);
            file = new DWARFFile(reader);
        }
        return result;
    }

    private DWARFLine() {
    }

    public String getFullFile(int index, String compileDirectory) {
        if (index == 0) {
            throw new UnsupportedOperationException("Currently does not support retrieving the primary source file.");
        }
        if (index > 0) {
            DWARFFile file = this.file_names.get(index - 1);
            File fileObj = new File(file.getName());
            if (fileObj.isAbsolute()) {
                return file.getName();
            }
            int diridx = (int)file.getDirectoryIndex();
            if (diridx == 0) {
                if (compileDirectory != null) {
                    return compileDirectory + file.getName();
                }
                throw new IllegalArgumentException("No compile directory was given when one was expected.");
            }
            if (diridx > 0) {
                String directory = this.include_directories.get(diridx - 1);
                return directory + file.getName();
            }
            throw new IndexOutOfBoundsException("Negative directory index was found: " + Integer.toString(diridx));
        }
        throw new IllegalArgumentException("Negative file index was given: " + Integer.toString(index));
    }

    public String getFile(int index, String compileDirectory) {
        if (index == 0) {
            throw new UnsupportedOperationException("Currently does not support retrieving the primary source file.");
        }
        if (index > 0) {
            DWARFFile file = this.file_names.get(index - 1);
            return FilenameUtils.getName((String)file.getName());
        }
        throw new IllegalArgumentException("Negative file index was given: " + Integer.toString(index));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Line Entry");
        buffer.append(" Include Directories: [");
        for (String dir : this.include_directories) {
            buffer.append(dir);
            buffer.append(", ");
        }
        buffer.append("] File Names: [");
        for (DWARFFile file : this.file_names) {
            buffer.append(file.toString());
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static class DWARFFile {
        private String name;
        private long directory_index;
        private long modification_time;
        private long length;

        public DWARFFile(BinaryReader reader) throws IOException {
            this.name = reader.readNextAsciiString();
            if (this.name.length() > 0) {
                this.directory_index = LEB128.readAsLong(reader, false);
                this.modification_time = LEB128.readAsLong(reader, false);
                this.length = LEB128.readAsLong(reader, false);
            }
        }

        public DWARFFile(String name, long directory_index, long modification_time, long length) {
            this.name = name;
            this.directory_index = directory_index;
            this.modification_time = modification_time;
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public long getDirectoryIndex() {
            return this.directory_index;
        }

        public long getModificationTime() {
            return this.modification_time;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Filename: ");
            buffer.append(this.name);
            buffer.append(" Length: ");
            buffer.append(Long.toHexString(this.length));
            return buffer.toString();
        }
    }
}

