/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.combobox.GComboBox;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddressInput
extends JPanel {
    private JTextField textField;
    private JComboBox<AddressSpace> combo;
    private boolean comboAdded;
    private AddressFactory addrFactory;
    private ChangeListener changeListener;
    private boolean updatingAddress;
    private boolean updateSpaceField;
    private boolean stateChanging;
    private JTextField spaceField;
    private static final Comparator<AddressSpace> ADDRESS_SPACE_SORT_COMPARATOR = new Comparator<AddressSpace>(){

        @Override
        public int compare(AddressSpace s1, AddressSpace s2) {
            if (s1.isOverlaySpace()) {
                if (!s2.isOverlaySpace()) {
                    return 1;
                }
            } else if (s2.isOverlaySpace()) {
                return -1;
            }
            return s1.getName().compareTo(s2.getName());
        }
    };

    public AddressInput(Border border) {
        this();
        this.combo.setBorder(border);
        this.textField.setBorder(border);
    }

    public AddressInput() {
        this.setLayout(new BorderLayout());
        this.textField = new JTextField(10);
        this.textField.setName("JTextField");
        this.combo = new GComboBox();
        this.combo.setName("JComboBox");
        this.add((Component)this.textField, "Center");
        this.comboAdded = false;
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddressInput.this.stateChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddressInput.this.stateChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddressInput.this.stateChanged();
            }
        });
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddressInput.this.stateChanged();
            }
        });
    }

    public void setAddress(Address addr) {
        if (this.stateChanging) {
            return;
        }
        this.updatingAddress = true;
        this.textField.setText(addr.toString(false));
        this.combo.setSelectedItem(addr.getAddressSpace());
        this.updatingAddress = false;
        if (this.updateSpaceField) {
            this.updateSpaceField = false;
            this.spaceField.setText(addr.getAddressSpace().getName());
        }
    }

    public Address getAddress() {
        String addrStr = this.textField.getText();
        AddressSpace space = this.getAddressSpace();
        try {
            return space.getAddress(addrStr);
        }
        catch (AddressFormatException e) {
            return null;
        }
    }

    public AddressSpace getAddressSpace() {
        if (this.comboAdded) {
            return (AddressSpace)this.combo.getSelectedItem();
        }
        return this.addrFactory.getDefaultAddressSpace();
    }

    public boolean hasInput() {
        return this.textField.getText().length() != 0;
    }

    public void setAddressFactory(AddressFactory factory) {
        this.setAddressFactory(factory, false, false);
    }

    public AddressFactory getAddressFactory() {
        return this.addrFactory;
    }

    public void setAddressFactory(AddressFactory factory, boolean filterOverlaySpaces, boolean allowOtherSpace) {
        this.addrFactory = factory;
        AddressSpace[] spaces = factory.getAddressSpaces();
        Arrays.sort(spaces, ADDRESS_SPACE_SORT_COMPARATOR);
        DefaultComboBoxModel<AddressSpace> model = new DefaultComboBoxModel<AddressSpace>();
        this.combo.setModel(model);
        FontMetrics fm = this.combo.getFontMetrics(this.combo.getFont());
        int width = 0;
        for (AddressSpace space : spaces) {
            if (filterOverlaySpaces && space.isOverlaySpace() || !allowOtherSpace && space.equals(AddressSpace.OTHER_SPACE)) continue;
            String s = space.toString();
            width = Math.max(width, fm.stringWidth(s));
            model.addElement(space);
        }
        if (model.getSize() > 1) {
            if (!this.comboAdded) {
                this.add(this.combo, "West");
                this.comboAdded = true;
            }
        } else if (this.comboAdded) {
            this.remove(this.combo);
            this.comboAdded = false;
        }
        this.invalidate();
    }

    public void selectDefaultAddressSpace() {
        if (this.addrFactory != null) {
            AddressSpace space = this.addrFactory.getDefaultAddressSpace();
            this.combo.setSelectedItem(space);
        }
    }

    public void clear() {
        this.textField.setText("");
    }

    public void select() {
        this.textField.selectAll();
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String value) {
        this.textField.setText(value);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public boolean containsAddressSpaces() {
        return this.comboAdded;
    }

    public void setAddressSpaceEditable(boolean state) {
        if (!state && this.comboAdded) {
            AddressSpace selectedSpace = (AddressSpace)this.combo.getSelectedItem();
            String spaceName = selectedSpace != null ? selectedSpace.getName() + ":" : "         ";
            this.spaceField = new JTextField(spaceName);
            this.spaceField.setEnabled(false);
            this.remove(this.combo);
            this.add((Component)this.spaceField, "West");
            if (this.textField.getText().length() == 0) {
                this.updateSpaceField = true;
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.textField.removeActionListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.combo.setEnabled(enabled);
    }

    public void setEditable(boolean state) {
        this.textField.setEditable(state);
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    private void stateChanged() {
        if (this.changeListener != null && !this.updatingAddress && !this.stateChanging) {
            this.stateChanging = true;
            this.changeListener.stateChanged(null);
            this.stateChanging = false;
        }
    }

    public void showAddressSpaceCombo(boolean showCombo) {
        if (showCombo) {
            if (!this.comboAdded) {
                this.add(this.combo, "West");
                this.comboAdded = true;
            }
        } else if (this.comboAdded) {
            this.remove(this.combo);
            this.comboAdded = false;
        }
        this.invalidate();
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    protected JTextField getAddressTextField() {
        return this.textField;
    }

    protected JTextField getAddressSpaceTextField() {
        return this.spaceField;
    }
}

