/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import generic.jar.ResourceFile;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.eclipse.EclipseConnection;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.app.plugin.core.script.GhidraScriptEditorComponentProvider;
import ghidra.app.plugin.core.script.ScriptList;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.EclipseIntegrationService;
import ghidra.app.services.GhidraScriptService;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Script Manager", description="Manages scripts and automatically compiles and creates actions in the tool for each script.", servicesRequired={ConsoleService.class, EclipseIntegrationService.class}, servicesProvided={GhidraScriptService.class})
public class GhidraScriptMgrPlugin
extends ProgramPlugin
implements GhidraScriptService {
    private final GhidraScriptComponentProvider provider;
    private final BundleHost bundleHost = GhidraScriptUtil.acquireBundleHostReference();
    private final ScriptList scriptList = new ScriptList(this.bundleHost);

    public GhidraScriptMgrPlugin(PluginTool tool) {
        super(tool);
        this.provider = new GhidraScriptComponentProvider(this, this.bundleHost, this.scriptList);
    }

    protected void dispose() {
        super.dispose();
        this.provider.dispose();
        GhidraScriptUtil.releaseBundleHostReference();
    }

    public void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        this.provider.readConfigState(saveState);
        GhidraScriptEditorComponentProvider.restoreState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        super.writeConfigState(saveState);
        this.provider.writeConfigState(saveState);
        GhidraScriptEditorComponentProvider.saveState(saveState);
    }

    GhidraState getCurrentState() {
        return new GhidraState(this.tool, this.tool.getProject(), this.currentProgram, this.currentLocation, this.currentSelection, this.currentHighlight);
    }

    GhidraScriptComponentProvider getProvider() {
        return this.provider;
    }

    ConsoleService getConsoleService() {
        return (ConsoleService)this.tool.getService(ConsoleService.class);
    }

    @Override
    public void runScript(String scriptName, TaskListener listener) {
        this.provider.runScript(scriptName, listener);
    }

    public void runScript(ResourceFile scriptFile) {
        this.provider.runScript(scriptFile);
    }

    @Override
    public void refreshScriptList() {
        this.provider.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean tryToEditFileInEclipse(ResourceFile file) {
        EclipseIntegrationService service = (EclipseIntegrationService)this.tool.getService(EclipseIntegrationService.class);
        ToolOptions options = service.getEclipseIntegrationOptions();
        int port = options.getInt("Script Editor Port", -1);
        if (port < 0 || port > Short.MAX_VALUE) {
            service.handleEclipseError("Option \"Script Editor Port\" is not valid.  Cannot connect to Eclipse.", true, null);
            return false;
        }
        EclipseConnection connection = service.connectToEclipse(port);
        Socket socket = connection.getSocket();
        if (socket == null) {
            return false;
        }
        PrintStream output = new PrintStream(socket.getOutputStream());
        output.print("open_" + file.getAbsolutePath());
        boolean bl = true;
        output.close();
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        service.handleEclipseError("Unexpected exception opening stream for socket to Eclipse", false, e);
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    protected void programClosed(Program program) {
        this.provider.programClosed(program);
    }
}

