/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.AddressLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.FunctionDefinitionLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.FunctionParameterNameLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.FunctionParameterTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.FunctionReturnTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.FunctionSignatureFieldLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.GenericCompositeDataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.GenericCompositeDataTypeProgramLocation;
import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeProgramLocation;
import ghidra.app.plugin.core.navigation.locationreferences.LabelLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.plugin.core.navigation.locationreferences.MnemonicLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.OperandLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.StructureMemberLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.UnionLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.VariableNameLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.VariableTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.VariableXRefLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.XRefLocationDescriptor;
import ghidra.app.services.DataTypeReference;
import ghidra.app.services.DataTypeReferenceFinder;
import ghidra.app.services.FieldMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.FieldNameFieldLocation;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.FunctionParameterNameFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.program.util.VariableXRefFieldLocation;
import ghidra.program.util.VariableXRefHeaderFieldLocation;
import ghidra.program.util.XRefFieldLocation;
import ghidra.program.util.XRefHeaderFieldLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalID;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.FilteringAccumulatorWrapper;
import ghidra.util.datastruct.SetAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class ReferenceUtils {
    private ReferenceUtils() {
    }

    private static boolean isMemoryAddress(ProgramLocation loc) {
        Program program = loc.getProgram();
        Address addr = loc.getAddress();
        if (loc instanceof FunctionLocation) {
            addr = ((FunctionLocation)loc).getFunctionAddress();
        }
        return ReferenceUtils.isMemoryAddress(program, addr);
    }

    private static boolean isMemoryAddress(Program p, Address a) {
        if (!a.isMemoryAddress()) {
            return false;
        }
        return p.getMemory().contains(a);
    }

    public static void getReferences(Accumulator<LocationReference> accumulator, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        Accumulator<LocationReference> asSet = ReferenceUtils.asSet(accumulator);
        Program program = location.getProgram();
        Address address = location.getAddress();
        Consumer<LocationReference> consumer = ref -> accumulator.add(ref);
        ReferenceUtils.accumulateDirectReferences(consumer, program, address);
        ReferenceUtils.accumulateThunkReferences(asSet, program, address, monitor);
        if (ReferenceUtils.isMemoryAddress(location)) {
            ReferenceUtils.accumulateOffcutReferencesToCodeUnitAt(asSet, location, monitor);
        }
    }

    public static Set<Address> getReferenceAddresses(ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        SetAccumulator accumulator = new SetAccumulator();
        ReferenceUtils.getReferenceAddresses((Accumulator<Address>)accumulator, location, monitor);
        return accumulator.asSet();
    }

    private static void getReferenceAddresses(Accumulator<Address> accumulator, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        Program program = location.getProgram();
        Address address = location.getAddress();
        Consumer<LocationReference> consumer = ref -> accumulator.add((Object)ref.getLocationOfUse());
        ReferenceUtils.accumulateDirectReferences(consumer, program, address);
        ReferenceUtils.accumulateThunkReferenceAddresses(accumulator, program, address, monitor);
        if (ReferenceUtils.isMemoryAddress(location)) {
            ReferenceUtils.accumulateOffcutReferenceAddresses(accumulator, location, monitor);
        }
    }

    public static boolean isOffcut(Program program, Address address) {
        if (!address.isMemoryAddress()) {
            return false;
        }
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        if (cu == null) {
            return false;
        }
        if (cu instanceof Data) {
            cu = ReferenceUtils.getDeepestDataContaining(address, program);
        }
        return !cu.getMinAddress().equals((Object)address);
    }

    @Deprecated
    public static void findDataTypeReferences(Accumulator<LocationReference> accumulator, DataType dataType, String fieldName, Program program, TaskMonitor monitor) throws CancelledException {
        ReferenceUtils.findDataTypeReferences(accumulator, dataType, fieldName, program, true, monitor);
    }

    @Deprecated(since="10.2")
    public static void findDataTypeReferences(Accumulator<LocationReference> accumulator, DataType dataType, String fieldName, Program program, boolean discoverTypes, TaskMonitor monitor) throws CancelledException {
        Objects.requireNonNull(dataType, () -> "Data Type cannot be null");
        FieldMatcher fieldMatcher = new FieldMatcher(dataType, fieldName);
        ReferenceUtils.doFindDataTypeReferences(accumulator, fieldMatcher, program, discoverTypes, monitor);
    }

    public static void findDataTypeReferences(Accumulator<LocationReference> accumulator, DataType dataType, Program program, boolean discoverTypes, TaskMonitor monitor) throws CancelledException {
        ReferenceUtils.doFindDataTypeReferences(accumulator, new FieldMatcher(dataType), program, discoverTypes, monitor);
    }

    public static void findDataTypeFieldReferences(Accumulator<LocationReference> accumulator, FieldMatcher fieldMatcher, Program program, boolean discoverTypes, TaskMonitor monitor) throws CancelledException {
        Objects.requireNonNull(fieldMatcher, "FieldMatcher cannot be null");
        ReferenceUtils.doFindDataTypeReferences(accumulator, fieldMatcher, program, discoverTypes, monitor);
    }

    private static void doFindDataTypeReferences(Accumulator<LocationReference> accumulator, FieldMatcher fieldMatcher, Program program, boolean discoverTypes, TaskMonitor monitor) throws CancelledException {
        monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        DataType dataType = fieldMatcher.getDataType();
        Listing listing = program.getListing();
        long dataCount = listing.getNumDefinedData();
        int functionCount = program.getFunctionManager().getFunctionCount();
        int totalCount = (int)dataCount + functionCount;
        monitor.initialize((long)totalCount);
        Accumulator<LocationReference> asSet = ReferenceUtils.asSet(accumulator);
        if (fieldMatcher.isIgnored()) {
            boolean localsOnly = discoverTypes;
            FunctionIterator iterator = listing.getFunctions(false);
            ReferenceUtils.findDataTypeMatchesInFunctionHeaders(asSet, iterator, dataType, localsOnly, monitor);
            localsOnly = false;
            iterator = listing.getExternalFunctions();
            ReferenceUtils.findDataTypeMatchesInFunctionHeaders(asSet, iterator, dataType, localsOnly, monitor);
        }
        Predicate<Data> dataMatcher = data -> {
            DataType baseType = ReferenceUtils.getBaseDataType(data.getDataType());
            boolean matches = ReferenceUtils.dataTypesMatch(dataType, baseType);
            return matches;
        };
        ReferenceUtils.findDataTypeMatchesInDefinedData(asSet, program, dataMatcher, fieldMatcher, monitor);
        if (discoverTypes) {
            ReferenceUtils.findDataTypeMatchesOutsideOfListing(asSet, program, dataType, fieldMatcher, monitor);
        }
        monitor.checkCanceled();
    }

    private static Accumulator<LocationReference> asSet(Accumulator<LocationReference> accumulator) {
        if (accumulator instanceof SetAccumulator) {
            return accumulator;
        }
        return new FilteringAccumulatorWrapper(accumulator, ref -> !accumulator.contains(ref));
    }

    private static void findDataTypeMatchesOutsideOfListing(Accumulator<LocationReference> accumulator, Program program, DataType dataType, FieldMatcher fieldMatcher, TaskMonitor monitor) throws CancelledException {
        List finders = ClassSearcher.getInstances(DataTypeReferenceFinder.class);
        Consumer<DataTypeReference> callback = ref -> {
            LocationReferenceContext context = ref.getContext();
            LocationReference locationReference = new LocationReference(ref.getAddress(), context);
            accumulator.add((Object)locationReference);
        };
        if (finders.isEmpty()) {
            Msg.debug(ReferenceUtils.class, (Object)("Unable to find any implementations of " + DataTypeReferenceFinder.class.getSimpleName()));
            return;
        }
        for (DataTypeReferenceFinder finder : finders) {
            finder.findReferences(program, fieldMatcher, callback, monitor);
        }
    }

    public static DataType getBaseDataType(DataType dataType) {
        return ReferenceUtils.getBaseDataType(dataType, false);
    }

    public static DataType getBaseDataType(DataType dataType, boolean includeTypedefs) {
        if (dataType instanceof Array) {
            return ReferenceUtils.getBaseDataType(((Array)dataType).getDataType(), includeTypedefs);
        }
        if (dataType instanceof Pointer) {
            DataType baseDataType = ((Pointer)dataType).getDataType();
            if (baseDataType != null) {
                return ReferenceUtils.getBaseDataType(baseDataType, includeTypedefs);
            }
        } else if (includeTypedefs && dataType instanceof TypeDef) {
            DataType baseDataType = ((TypeDef)dataType).getBaseDataType();
            return ReferenceUtils.getBaseDataType(baseDataType, includeTypedefs);
        }
        return dataType;
    }

    public static List<Variable> getVariables(Function function, boolean localsOnly) {
        if (function == null) {
            throw new NullPointerException("Function may not be null.");
        }
        ArrayList<Variable> list = new ArrayList<Variable>();
        if (localsOnly) {
            list.addAll(Arrays.asList(function.getLocalVariables()));
        } else {
            list.addAll(Arrays.asList(function.getAllVariables()));
        }
        return list;
    }

    public static LocationDescriptor getLocationDescriptor(ProgramLocation location) {
        try {
            return ReferenceUtils.getLocationDescriptorWhileWatchingForExplosiveNavigationCondition(location);
        }
        catch (Exception e) {
            Msg.debug(ReferenceUtils.class, (Object)("Unexpected exception getting descriptor for location: " + location), (Throwable)e);
            return null;
        }
    }

    private static LocationDescriptor getLocationDescriptorWhileWatchingForExplosiveNavigationCondition(ProgramLocation location) {
        Program program = location.getProgram();
        if (location instanceof FunctionSignatureFieldLocation) {
            LocationDescriptor result = ReferenceUtils.createFunctionSignatureFieldLocationDescriptor((FunctionSignatureFieldLocation)location);
            return result;
        }
        if (location instanceof MnemonicFieldLocation) {
            return ReferenceUtils.createMnemonicLocationDescriptor((MnemonicFieldLocation)location);
        }
        if (location instanceof OperandFieldLocation) {
            return ReferenceUtils.createOperandLocationDescriptor((OperandFieldLocation)location);
        }
        if (location instanceof LabelFieldLocation) {
            return new LabelLocationDescriptor(location, program);
        }
        if (location instanceof XRefFieldLocation) {
            return ReferenceUtils.createXRefLocationDescriptor(location);
        }
        if (location instanceof VariableXRefFieldLocation) {
            return ReferenceUtils.createVariableXRefLocationDescriptor(location);
        }
        if (location instanceof VariableNameFieldLocation) {
            return new VariableNameLocationDescriptor((VariableNameFieldLocation)location, program);
        }
        if (location instanceof VariableTypeFieldLocation) {
            return new VariableTypeLocationDescriptor(location, program);
        }
        if (location instanceof AddressFieldLocation) {
            return new AddressLocationDescriptor(location, program);
        }
        if (location instanceof GenericCompositeDataTypeProgramLocation) {
            GenericCompositeDataTypeProgramLocation dataTypeLocation = (GenericCompositeDataTypeProgramLocation)location;
            return new GenericCompositeDataTypeLocationDescriptor(dataTypeLocation, program);
        }
        if (location instanceof GenericDataTypeProgramLocation) {
            GenericDataTypeProgramLocation dataTypeLocation = (GenericDataTypeProgramLocation)location;
            DataType dataType = dataTypeLocation.getDataType();
            if (dataType instanceof FunctionDefinition) {
                FunctionDefinition functionDefinition = (FunctionDefinition)dataType;
                return new FunctionDefinitionLocationDescriptor(location, program, functionDefinition);
            }
            return new GenericDataTypeLocationDescriptor(location, program, dataType);
        }
        if (location instanceof FieldNameFieldLocation) {
            FieldNameFieldLocation fieldLocation = (FieldNameFieldLocation)location;
            LocationDescriptor dataMemberDescriptor = ReferenceUtils.createDataMemberLocationDescriptor(fieldLocation);
            return dataMemberDescriptor;
        }
        if (location instanceof CodeUnitLocation) {
            return new AddressLocationDescriptor(location, program);
        }
        return null;
    }

    private static LocationDescriptor createVariableXRefLocationDescriptor(ProgramLocation location) {
        if (location instanceof VariableXRefHeaderFieldLocation) {
            return null;
        }
        return new VariableXRefLocationDescriptor(location, location.getProgram());
    }

    private static LocationDescriptor createXRefLocationDescriptor(ProgramLocation location) {
        if (location instanceof XRefHeaderFieldLocation) {
            return null;
        }
        return new XRefLocationDescriptor(location, location.getProgram());
    }

    private static LocationDescriptor createFunctionSignatureFieldLocationDescriptor(FunctionSignatureFieldLocation location) {
        Program program = location.getProgram();
        if (location instanceof FunctionReturnTypeFieldLocation) {
            return new FunctionReturnTypeLocationDescriptor((ProgramLocation)location, program);
        }
        if (location instanceof FunctionParameterFieldLocation) {
            if (location instanceof FunctionParameterNameFieldLocation) {
                return new FunctionParameterNameLocationDescriptor((FunctionLocation)location, program);
            }
            return new FunctionParameterTypeLocationDescriptor((ProgramLocation)location, program);
        }
        return new FunctionSignatureFieldLocationDescriptor((FunctionLocation)location, program);
    }

    private static LocationDescriptor createMnemonicLocationDescriptor(MnemonicFieldLocation location) {
        Program program = location.getProgram();
        Data data = ReferenceUtils.getDataContainingAddress(program, location.getAddress());
        if (data == null) {
            return ReferenceUtils.createInstructionLocationDescriptor(location);
        }
        if (!data.isDefined()) {
            return null;
        }
        return new MnemonicLocationDescriptor((ProgramLocation)location, program);
    }

    private static Data getDataContainingAddress(Program program, Address address) {
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitAt(address);
        if (codeUnit == null) {
            codeUnit = listing.getCodeUnitContaining(address);
        }
        if (!(codeUnit instanceof Data)) {
            return null;
        }
        return (Data)codeUnit;
    }

    private static LocationDescriptor createInstructionLocationDescriptor(MnemonicFieldLocation location) {
        Program program = location.getProgram();
        Listing listing = program.getListing();
        Instruction instruction = listing.getInstructionAt(location.getAddress());
        if (instruction == null) {
            return null;
        }
        AddressFieldLocation addressLocation = new AddressFieldLocation(program, location.getAddress());
        return new AddressLocationDescriptor((ProgramLocation)addressLocation, program);
    }

    private static LocationDescriptor createDataMemberLocationDescriptor(FieldNameFieldLocation location) {
        Address address = location.getAddress();
        Program program = location.getProgram();
        Data outermostData = ReferenceUtils.getDataContainingAddress(program, address);
        if (outermostData == null) {
            return null;
        }
        Data subData = outermostData.getComponent(location.getComponentPath());
        LocationDescriptor descriptor = ReferenceUtils.createSubDataMemberLocationDescriptor(program, address, location, subData);
        return descriptor;
    }

    private static LocationDescriptor createSubDataMemberLocationDescriptor(Program program, Address address, FieldNameFieldLocation location, Data subData) {
        Data parent = subData.getParent();
        DataType type = parent.getDataType();
        if (type instanceof Union) {
            return new UnionLocationDescriptor((ProgramLocation)location, program);
        }
        if (type instanceof Composite) {
            String fieldName = location.getFieldName();
            return new StructureMemberLocationDescriptor((ProgramLocation)location, fieldName, program);
        }
        if (type instanceof DynamicDataType) {
            AddressFieldLocation addressLocation = new AddressFieldLocation(program, address, location.getComponentPath(), "", 0);
            return new AddressLocationDescriptor((ProgramLocation)addressLocation, program);
        }
        if (type instanceof Array) {
            AddressFieldLocation addressLocation = new AddressFieldLocation(program, address);
            AddressLocationDescriptor descriptor = new AddressLocationDescriptor((ProgramLocation)addressLocation, program);
            return descriptor;
        }
        return null;
    }

    private static LocationDescriptor createDataMemberLocationDescriptor(OperandFieldLocation location, Address address) {
        if (address.isExternalAddress()) {
            return null;
        }
        Program program = location.getProgram();
        Data outermostData = ReferenceUtils.getDataContainingAddress(program, address);
        if (outermostData == null) {
            return null;
        }
        String fieldPath = ReferenceUtils.getFieldPath(location);
        if (!fieldPath.contains(".")) {
            DataType type = outermostData.getDataType();
            if (type == DataType.DEFAULT || Undefined.isUndefined((DataType)type)) {
                return null;
            }
            GenericDataTypeLocationDescriptor dtDescriptor = ReferenceUtils.createGenericDataTypeLocationDescriptor(program, type, fieldPath);
            return dtDescriptor;
        }
        String fieldName = ReferenceUtils.getFieldName(location);
        Address parentAddress = outermostData.getMinAddress();
        int componentAddress = (int)address.subtract(parentAddress);
        Data subData = outermostData.getComponentContaining(componentAddress);
        if (subData != null) {
            int[] componentPath = subData.getComponentPath();
            FieldNameFieldLocation fieldLocation = new FieldNameFieldLocation(program, address, componentPath, fieldName, 0);
            LocationDescriptor descriptor = ReferenceUtils.createSubDataMemberLocationDescriptor(program, address, fieldLocation, subData);
            return descriptor;
        }
        DataType dt = outermostData.getDataType();
        if (dt instanceof Union) {
            AddressFieldLocation addressLocation = new AddressFieldLocation(program, address, new int[]{0}, address.toString(), 0);
            return new UnionLocationDescriptor((ProgramLocation)addressLocation, program);
        }
        return null;
    }

    private static GenericDataTypeLocationDescriptor createGenericDataTypeLocationDescriptor(OperandFieldLocation location) {
        Data data = ReferenceUtils.getDataAt((ProgramLocation)location);
        if (data == null) {
            return null;
        }
        DataType dt = data.getDataType();
        if (dt instanceof Enum) {
            String enumText = location.getOperandRepresentation();
            GenericCompositeDataTypeProgramLocation genericLocation = new GenericCompositeDataTypeProgramLocation(location.getProgram(), dt, enumText);
            return new GenericCompositeDataTypeLocationDescriptor(genericLocation, location.getProgram());
        }
        GenericDataTypeProgramLocation genericLocation = new GenericDataTypeProgramLocation(location.getProgram(), dt);
        return new GenericDataTypeLocationDescriptor(genericLocation, location.getProgram(), dt);
    }

    private static LocationDescriptor createGenericDataTypeLocationDescriptor(Program program, VariableOffset variableOffset) {
        if (variableOffset == null) {
            return null;
        }
        Variable variable = variableOffset.getVariable();
        DataType type = variable.getDataType();
        String string = variableOffset.getDataTypeDisplayText();
        GenericDataTypeLocationDescriptor descriptor = ReferenceUtils.createGenericDataTypeLocationDescriptor(program, type, string);
        return descriptor;
    }

    private static GenericDataTypeLocationDescriptor createGenericDataTypeLocationDescriptor(Program program, DataType type, String fieldPath) {
        if (fieldPath.contains("->")) {
            fieldPath = fieldPath.replace("->", ".");
        }
        DataType baseType = ReferenceUtils.getBaseDataType(type);
        String[] parts = fieldPath.split("\\.");
        if (parts.length == 1) {
            GenericDataTypeProgramLocation location = new GenericDataTypeProgramLocation(program, baseType);
            return new GenericDataTypeLocationDescriptor(location, program, baseType);
        }
        if (!(baseType instanceof Composite)) {
            return null;
        }
        Composite composite = (Composite)baseType;
        if (parts.length == 2) {
            GenericCompositeDataTypeProgramLocation location = new GenericCompositeDataTypeProgramLocation(program, (DataType)composite, parts[1]);
            return new GenericCompositeDataTypeLocationDescriptor(location, program);
        }
        Stack<String> path = new Stack<String>();
        for (int i = parts.length - 1; i >= 0; --i) {
            path.push(parts[i]);
        }
        String fieldName = (String)path.remove(0);
        path.pop();
        DataType dataType = ReferenceUtils.findLeafDataType(baseType, path);
        composite = (Composite)dataType;
        GenericCompositeDataTypeProgramLocation location = new GenericCompositeDataTypeProgramLocation(program, (DataType)composite, fieldName);
        return new GenericCompositeDataTypeLocationDescriptor(location, program);
    }

    private static Data getDeepestDataContaining(Address addr, Program program) {
        Listing listing = program.getListing();
        Data dataContaining = listing.getDataContaining(addr);
        Address start = dataContaining.getAddress();
        long depth = addr.subtract(start);
        Data primitiveAtAddr = dataContaining.getPrimitiveAt((int)depth);
        return primitiveAtAddr;
    }

    private static Data getDataAt(ProgramLocation location) {
        Program p = location.getProgram();
        Listing l = p.getListing();
        Data dataContaining = l.getDataContaining(location.getAddress());
        if (dataContaining != null) {
            return dataContaining.getComponent(location.getComponentPath());
        }
        return null;
    }

    private static DataType findLeafDataType(DataType parent, Stack<String> path) {
        DataType baseParent = ReferenceUtils.getBaseDataType(parent, true);
        if (path.isEmpty()) {
            return baseParent;
        }
        if (!(baseParent instanceof Composite)) {
            return null;
        }
        Composite composite = (Composite)baseParent;
        DataTypeComponent[] components = composite.getDefinedComponents();
        String name = path.pop();
        for (DataTypeComponent component : components) {
            if (!component.getFieldName().equals(name)) continue;
            DataType newParent = component.getDataType();
            return ReferenceUtils.findLeafDataType(newParent, path);
        }
        return null;
    }

    private static LocationDescriptor createOperandLocationDescriptor(OperandFieldLocation location) {
        Address refAddress = ReferenceUtils.getReferenceAddress(location);
        if (refAddress == null) {
            GenericDataTypeLocationDescriptor descriptor = ReferenceUtils.createGenericDataTypeLocationDescriptor(location);
            return descriptor;
        }
        Address operandAddress = location.getAddress();
        int operandIndex = location.getOperandIndex();
        Program program = location.getProgram();
        ReferenceManager referenceManager = program.getReferenceManager();
        Reference reference = referenceManager.getReference(operandAddress, refAddress, operandIndex);
        if (reference == null) {
            VariableOffset variableOffset = location.getVariableOffset();
            return ReferenceUtils.createGenericDataTypeLocationDescriptor(program, variableOffset);
        }
        LocationDescriptor dataMemberDescriptor = ReferenceUtils.createDataMemberLocationDescriptor(location, refAddress);
        if (dataMemberDescriptor != null) {
            return dataMemberDescriptor;
        }
        LocationDescriptor functionMemberDescriptor = ReferenceUtils.createFunctionMemberLocationDescriptor(location, reference, operandAddress);
        if (functionMemberDescriptor != null) {
            return functionMemberDescriptor;
        }
        return new OperandLocationDescriptor((ProgramLocation)location, program);
    }

    private static Address getReferenceAddress(OperandFieldLocation location) {
        Address refAddress = location.getRefAddress();
        if (refAddress != null) {
            return refAddress;
        }
        VariableOffset variableOffset = location.getVariableOffset();
        if (variableOffset == null) {
            return null;
        }
        Variable variable = variableOffset.getVariable();
        refAddress = variable.getMinAddress();
        return refAddress;
    }

    private static String getFieldPath(OperandFieldLocation location) {
        String rep = location.getOperandRepresentation();
        String path = rep.replace("->", ".");
        return path;
    }

    private static String getFieldName(OperandFieldLocation location) {
        String rep = location.getOperandRepresentation();
        String fieldName = rep;
        if (fieldName.contains(".")) {
            String[] path = fieldName.split("\\.");
            fieldName = path[path.length - 1];
        }
        return fieldName;
    }

    private static LocationDescriptor createFunctionMemberLocationDescriptor(OperandFieldLocation location, Reference reference, Address operandAddress) {
        Program program = location.getProgram();
        if (reference.isStackReference() || reference.isRegisterReference()) {
            ReferenceManager referenceManager = program.getReferenceManager();
            Variable referencedVariable = referenceManager.getReferencedVariable(reference);
            if (referencedVariable == null) {
                return null;
            }
            return new VariableNameLocationDescriptor(new VariableNameFieldLocation(referencedVariable.getProgram(), referencedVariable, 0), location, program);
        }
        return null;
    }

    public static void findDataTypeMatchesInDefinedData(Accumulator<LocationReference> accumulator, Program program, Predicate<Data> dataMatcher, FieldMatcher fieldMatcher, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        DataIterator dataIter = listing.getDefinedData(true);
        while (dataIter.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            Data data = dataIter.next();
            ReferenceUtils.getMatchingDataTypesReferencesFromDataAndSubData(accumulator, data, fieldMatcher, dataMatcher, monitor);
            monitor.incrementProgress(1L);
        }
    }

    private static LocationReference createReferenceFromDefinedData(Data data, FieldMatcher fieldMatcher) {
        Address dataAddress = data.getMinAddress();
        if (fieldMatcher.isIgnored()) {
            return new LocationReference(dataAddress, data.getPathName());
        }
        DataType dt = data.getDataType();
        if (dt instanceof Pointer) {
            return null;
        }
        DataType baseDt = ReferenceUtils.getBaseDataType(data.getDataType());
        if (ReferenceUtils.matchesEnumField(data, baseDt, fieldMatcher)) {
            return new LocationReference(dataAddress, fieldMatcher.getDisplayText());
        }
        DataTypeComponent component = ReferenceUtils.getDataTypeComponent(baseDt, fieldMatcher);
        if (component == null) {
            return null;
        }
        try {
            Address componentAddress = dataAddress.addNoWrap((long)component.getOffset());
            return new LocationReference(componentAddress, data.getPathName() + "." + fieldMatcher.getFieldName());
        }
        catch (AddressOverflowException e) {
            Msg.error(ReferenceUtils.class, (Object)("Unable to create address for sub-component of " + data.getPathName() + " at " + dataAddress), (Throwable)e);
            return null;
        }
    }

    private static boolean matchesEnumField(Data data, DataType dt, FieldMatcher matcher) {
        if (!(dt instanceof Enum)) {
            return false;
        }
        Enum enumm = (Enum)dt;
        List<String> names = ReferenceUtils.getEnumNames(data, enumm);
        for (String name : names) {
            long value;
            if (!matcher.matches(name, (int)(value = enumm.getValue(name)))) continue;
            return true;
        }
        return false;
    }

    private static List<String> getEnumNames(Data data, Enum enumm) {
        String enumEntryName = data.getDefaultValueRepresentation();
        ArrayList<String> enumNames = new ArrayList<String>(List.of(enumm.getNames()));
        if (enumNames.contains(enumEntryName)) {
            return List.of(enumEntryName);
        }
        if (!enumEntryName.contains(" | ")) {
            return Collections.emptyList();
        }
        String[] names = enumEntryName.split(" \\| ");
        return List.of(names);
    }

    private static DataTypeComponent getDataTypeComponent(DataType dt, FieldMatcher matcher) {
        if (dt instanceof Composite) {
            DataTypeComponent[] components;
            Composite c = (Composite)dt;
            for (DataTypeComponent component : components = c.getDefinedComponents()) {
                if (!matcher.matches(component.getFieldName(), component.getOffset())) continue;
                return component;
            }
        }
        return null;
    }

    private static void getMatchingDataTypesReferencesFromDataAndSubData(Accumulator<LocationReference> accumulator, Data data, FieldMatcher fieldMatcher, Predicate<Data> dataMatcher, TaskMonitor monitor) throws CancelledException {
        if (dataMatcher.test(data)) {
            ReferenceUtils.getMatchingDataTypesReferencesFromData(accumulator, data, fieldMatcher, monitor);
        }
        if (data.getBaseDataType() instanceof Array) {
            return;
        }
        int numComponents = data.getNumComponents();
        for (int i = 0; i < numComponents; ++i) {
            monitor.checkCanceled();
            Data subData = data.getComponent(i);
            ReferenceUtils.getMatchingDataTypesReferencesFromDataAndSubData(accumulator, subData, fieldMatcher, dataMatcher, monitor);
        }
    }

    private static void getMatchingDataTypesReferencesFromData(Accumulator<LocationReference> accumulator, Data data, FieldMatcher fieldMatcher, TaskMonitor monitor) throws CancelledException {
        LocationReference ref = ReferenceUtils.createReferenceFromDefinedData(data, fieldMatcher);
        if (ref == null) {
            return;
        }
        if (!accumulator.contains((Object)ref)) {
            accumulator.add((Object)ref);
        }
        Address dataAddress = ref.getLocationOfUse();
        Consumer<LocationReference> consumer = locationReference -> accumulator.add(locationReference);
        Program program = data.getProgram();
        ReferenceUtils.accumulateDirectReferences(consumer, program, dataAddress);
        Consumer<Reference> referenceConsumer = reference -> {
            Address toAddress = reference.getToAddress();
            if (fieldMatcher.isIgnored()) {
                accumulator.add((Object)new LocationReference((Reference)reference, ReferenceUtils.isOffcut(program, toAddress)));
                return;
            }
            if (toAddress.equals((Object)dataAddress)) {
                accumulator.add((Object)new LocationReference((Reference)reference, false));
            }
        };
        ReferenceUtils.accumulateOffcutReferences(referenceConsumer, (CodeUnit)data, monitor);
    }

    private static void findDataTypeMatchesInFunctionHeaders(Accumulator<LocationReference> accumulator, FunctionIterator iterator, DataType locationDataType, boolean localsOnly, TaskMonitor monitor) throws CancelledException {
        while (iterator.hasNext()) {
            monitor.checkCanceled();
            Function function = (Function)iterator.next();
            Address entryPoint = function.getEntryPoint();
            Program program = function.getProgram();
            DataType returnType = function.getReturnType();
            if (!localsOnly && ReferenceUtils.dataTypesMatch(locationDataType, returnType)) {
                accumulator.add((Object)new LocationReference(entryPoint));
            }
            List<Variable> variables = ReferenceUtils.getVariables(function, localsOnly);
            for (Variable variable : variables) {
                DataType variableDataType = ReferenceUtils.getBaseDataType(variable.getDataType());
                if (!ReferenceUtils.dataTypesMatch(locationDataType, variableDataType)) continue;
                VariableTypeFieldLocation location = new VariableTypeFieldLocation(program, entryPoint, variable, 0);
                location = new VariableTypeFieldLocation(program, entryPoint, variable, 0);
                String context = variable.toString();
                accumulator.add((Object)new LocationReference(entryPoint, context, (ProgramLocation)location));
            }
            monitor.incrementProgress(1L);
        }
    }

    private static boolean dataTypesMatch(DataType searchType, DataType possibleType) {
        if (ReferenceUtils.isBuiltIn(searchType)) {
            Class<?> clazz = searchType.getClass();
            return clazz.equals(possibleType.getClass());
        }
        UniversalID uid1 = searchType.getUniversalID();
        UniversalID uid2 = possibleType.getUniversalID();
        boolean equal = SystemUtilities.isEqual((Object)uid1, (Object)uid2);
        return equal;
    }

    private static boolean isBuiltIn(DataType dt) {
        SourceArchive sourceArchive = dt.getSourceArchive();
        if (sourceArchive == null) {
            return false;
        }
        return DataTypeManager.BUILT_IN_ARCHIVE_UNIVERSAL_ID.equals((Object)sourceArchive.getSourceArchiveID());
    }

    public static void getVariableReferences(Accumulator<LocationReference> accumulator, Program program, Variable variable) {
        Reference[] variableRefsTo;
        Address variableAddress = variable.getMinAddress();
        ReferenceManager referenceManager = program.getReferenceManager();
        for (Reference ref : variableRefsTo = referenceManager.getReferencesTo(variable)) {
            accumulator.add((Object)new LocationReference(ref, !ref.getToAddress().equals((Object)variableAddress)));
        }
    }

    private static void accumulateOffcutReferenceAddresses(Accumulator<Address> accumulator, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        Consumer<Reference> consumer = ref -> accumulator.add((Object)ref.getFromAddress());
        ReferenceUtils.accumulateOffcutReferences(consumer, location, monitor);
    }

    private static void accumulateOffcutReferencesToCodeUnitAt(Accumulator<LocationReference> accumulator, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        Program program = location.getProgram();
        Consumer<Reference> consumer = ref -> {
            boolean isOffcut = ReferenceUtils.isOffcut(program, ref.getToAddress());
            accumulator.add((Object)new LocationReference((Reference)ref, isOffcut));
        };
        ReferenceUtils.accumulateOffcutReferences(consumer, location, monitor);
    }

    private static void accumulateOffcutReferences(Consumer<Reference> consumer, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        Data data;
        Program program = location.getProgram();
        Listing l = program.getListing();
        CodeUnit cu = l.getCodeUnitContaining(location.getAddress());
        if (cu == null || cu.getLength() <= 1) {
            return;
        }
        if (cu instanceof Data && (data = ReferenceUtils.getDataAt(location)) != null) {
            cu = data;
        }
        ReferenceUtils.accumulateOffcutReferences(consumer, cu, monitor);
    }

    private static void accumulateOffcutReferences(Consumer<Reference> consumer, CodeUnit cu, TaskMonitor monitor) throws CancelledException {
        Program program = cu.getProgram();
        ReferenceManager referenceManager = program.getReferenceManager();
        if (cu.getLength() == 1) {
            return;
        }
        AddressSet offcut = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
        AddressIterator addresses = referenceManager.getReferenceDestinationIterator((AddressSetView)offcut, true);
        Address codeUnitAddress = cu.getAddress();
        while (addresses.hasNext()) {
            monitor.checkCanceled();
            Address addr = addresses.next();
            if (addr.equals((Object)codeUnitAddress)) continue;
            ReferenceIterator refs = referenceManager.getReferencesTo(addr);
            while (refs.hasNext()) {
                Reference ref = refs.next();
                consumer.accept(ref);
            }
        }
    }

    private static void accumulateDirectReferences(Consumer<LocationReference> consumer, Program program, Address address) {
        boolean isOffcut = ReferenceUtils.isOffcut(program, address);
        ReferenceIterator iter = program.getReferenceManager().getReferencesTo(address);
        while (iter.hasNext()) {
            Reference ref = iter.next();
            consumer.accept(new LocationReference(ref, isOffcut));
        }
    }

    private static void accumulateThunkReferenceAddresses(Accumulator<Address> accumulator, Program program, Address address, TaskMonitor monitor) throws CancelledException {
        Consumer<LocationReference> consumer = ref -> accumulator.add((Object)ref.getLocationOfUse());
        ReferenceUtils.accumulateThunkReferences(consumer, program, address, monitor);
    }

    private static void accumulateThunkReferences(Accumulator<LocationReference> accumulator, Program program, Address address, TaskMonitor monitor) throws CancelledException {
        Consumer<LocationReference> consumer = ref -> accumulator.add(ref);
        ReferenceUtils.accumulateThunkReferences(consumer, program, address, monitor);
    }

    private static void accumulateThunkReferences(Consumer<LocationReference> consumer, Program program, Address address, TaskMonitor monitor) throws CancelledException {
        Function func = program.getFunctionManager().getFunctionAt(address);
        if (func == null) {
            return;
        }
        Address[] thunkAddrs = func.getFunctionThunkAddresses();
        if (thunkAddrs == null) {
            return;
        }
        for (Address thunkAddr : thunkAddrs) {
            monitor.checkCanceled();
            ThunkReference ref = new ThunkReference(thunkAddr, func.getEntryPoint());
            consumer.accept(new LocationReference((Reference)ref, false));
        }
    }
}

