/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.program.model.symbol.LabelHistory;
import java.util.Date;
import java.util.List;

class LabelHistoryTableModel
extends AbstractSortedTableModel<LabelHistory> {
    private static final long serialVersionUID = 1L;
    static final String ADDRESS = "Address";
    static final String ACTION = "Action";
    static final String LABEL = "Label";
    static final String USER = "User";
    static final String DATE = "Modification Date";
    private static final int ADDRESS_COL = 0;
    private static final int ACTION_COL = 1;
    private static final int LABEL_COL = 2;
    private static final int USER_COL = 3;
    private static final int DATE_COL = 4;
    private String[] columnNames = new String[]{"Address", "Action", "Label", "User", "Modification Date"};
    private int[] columnNumbers = new int[]{0, 1, 2, 3, 4};
    private static final String[] ACTION_NAMES = new String[]{"Add", "Remove", "Rename"};
    private List<LabelHistory> historyList;
    private boolean showAddress;

    LabelHistoryTableModel(List<LabelHistory> list, boolean showAddress) {
        this.historyList = list;
        this.showAddress = showAddress;
        if (!showAddress) {
            this.columnNames = new String[]{ACTION, LABEL, USER, DATE};
            this.columnNumbers = new int[]{1, 2, 3, 4};
        }
    }

    public String getName() {
        return "Label History";
    }

    public int getRowCount() {
        return this.historyList.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (this.columnNumbers[columnIndex] == 4) {
            return Date.class;
        }
        return String.class;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    int getDefaultSortColumn() {
        if (this.showAddress) {
            return 0;
        }
        return this.columnNumbers.length - 1;
    }

    int getLabelColumn() {
        return this.columnNumbers.length - 3;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public List<LabelHistory> getModelData() {
        return this.historyList;
    }

    public Object getColumnValueForRow(LabelHistory h, int columnIndex) {
        switch (this.columnNumbers[columnIndex]) {
            case 0: {
                return h.getAddress().toString();
            }
            case 1: {
                return ACTION_NAMES[h.getActionID()];
            }
            case 2: {
                return h.getLabelString();
            }
            case 3: {
                return h.getUserName();
            }
            case 4: {
                return h.getModificationDate();
            }
        }
        throw new ArrayIndexOutOfBoundsException("bad columnIndex");
    }
}

