/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.EmptyBorderButton;
import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableDataObject;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableModel;
import ghidra.app.plugin.core.instructionsearch.model.OperandMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.AbstractInstructionTable;
import ghidra.app.plugin.core.instructionsearch.ui.InsertBytesWidget;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.services.GoToService;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.OperandType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class InstructionTable
extends AbstractInstructionTable {
    private static final String HEADER_COL_MNEMONIC = "Mnemonic";
    private static final String HEADER_COL_OPERAND = "Operand";
    private static final int ICON_SIZE = 16;
    private static final String GO_HOME_ICON_OVERLAY = "images/go-home.png";
    private static final String ADDRESS_ICON_OVERLAY = "images/DOSA_A.png";
    private static final String SCALAR_ICON_OVERLAY = "images/DOSA_S.png";
    private static final String OPERAND_ICON_OVERLAY = "images/DOSA_O.png";
    private static final String UNDEFINED_ICON_OVERLAY = "images/DOSA_D.png";
    private static final String CLEAR_ICON_OVERLAY = "images/edit-clear.png";
    private static final String RELOAD_ICON_OVERLAY = "images/reload.png";
    private static final String MANUAL_ENTRY_ICON_OVERLAY = "images/editbytes.gif";
    private int selectedColumn = -1;
    private InsertBytesWidget insertBytesWidget = null;
    InstructionSearchPlugin plugin = null;

    public InstructionTable(int columns, InstructionSearchPlugin plugin, InstructionSearchDialog dialog) throws InvalidInputException {
        super(columns, dialog);
        if (plugin == null) {
            throw new InvalidInputException("plugin object cannot be null!");
        }
        this.plugin = plugin;
        this.insertBytesWidget = new InsertBytesWidget(plugin.getCurrentProgram(), dialog);
        this.setTableAttributes();
        this.createContextMenu();
        this.createMouseEvents();
        dialog.getSearchData().registerForGuiUpdates(this);
    }

    protected boolean supportsPopupActions() {
        return false;
    }

    public InsertBytesWidget getInsertBytesWidget() {
        return this.insertBytesWidget;
    }

    @Override
    protected Object[] createColumnHeaders() {
        if (this.numColumns <= 0) {
            return null;
        }
        Object[] columnNamesLocal = new Object[this.numColumns];
        columnNamesLocal[0] = HEADER_COL_MNEMONIC;
        for (int i = 1; i < this.numColumns; ++i) {
            columnNamesLocal[i] = "Operand " + i;
        }
        return columnNamesLocal;
    }

    @Override
    protected JToolBar createToolbar() {
        JToolBar toolbar1 = new JToolBar();
        toolbar1.add(Box.createHorizontalGlue());
        this.createMaskClearAllBtn(toolbar1);
        toolbar1.addSeparator();
        this.createMaskDataBtn(toolbar1);
        this.createMaskOperandsBtn(toolbar1);
        this.createMaskScalarsBtn(toolbar1);
        this.createMaskAddressesBtn(toolbar1);
        toolbar1.addSeparator();
        this.createReloadBtn(toolbar1);
        toolbar1.addSeparator();
        this.createManualEditBtn(toolbar1);
        toolbar1.addSeparator();
        this.createGoToAddressBtn(toolbar1);
        toolbar1.setFloatable(false);
        return toolbar1;
    }

    @Override
    protected InstructionTableDataObject[][] createDataObjects() {
        if (this.dialog.getSearchData().getInstructions() == null) {
            return null;
        }
        final InstructionTableDataObject[][] dataObjects = new InstructionTableDataObject[this.dialog.getSearchData().getInstructions().size()][this.numColumns];
        Task bTask = new Task("Creating Table Data", true, true, true){

            public void run(TaskMonitor monitor) {
                int numInstructions = InstructionTable.this.dialog.getSearchData().getInstructions().size();
                monitor.setMaximum((long)numInstructions);
                for (int i = 0; i < numInstructions; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    monitor.incrementProgress(1L);
                    InstructionTable.this.processInstruction(dataObjects, i);
                }
            }
        };
        new TaskLauncher(bTask, (Component)((Object)this));
        return dataObjects;
    }

    private void createContextMenu() {
        MenuElement[] elements;
        this.getTableColumnPopupMenu(1).addSeparator();
        this.getTableColumnPopupMenu(1).add(this.createColumnMaskUnmaskAllMenuItem(true, "Mask entire column"));
        this.getTableColumnPopupMenu(1).add(this.createColumnMaskUnmaskAllMenuItem(false, "Unmask entire column"));
        for (MenuElement element : elements = this.getTableColumnPopupMenu(1).getSubElements()) {
            JMenuItem item;
            if (!(element instanceof JMenuItem) || !(item = (JMenuItem)element).getText().contains("Add/Remove Columns")) continue;
            item.setEnabled(false);
        }
    }

    private void setTableAttributes() {
        this.setColumnHeaderPopupEnabled(true);
        this.setRowSelectionAllowed(false);
    }

    private void createMouseEvents() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                InstructionTable.this.selectedColumn = InstructionTable.this.columnAtPoint(arg0.getPoint());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt)) {
                    int rowSelection = InstructionTable.this.rowAtPoint(evt.getPoint());
                    int columnSelection = InstructionTable.this.columnAtPoint(evt.getPoint());
                    if (rowSelection == -1 || columnSelection == -1) {
                        return;
                    }
                    InstructionTableDataObject dataObject = InstructionTable.this.getCellData(rowSelection, columnSelection);
                    if (dataObject != null) {
                        dataObject.toggleMaskState();
                        if (InstructionTable.this.dialog.getMessagePanel() != null) {
                            InstructionTable.this.dialog.getMessagePanel().clear();
                        }
                    }
                }
            }
        });
    }

    private void createGoToAddressBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)GO_HOME_ICON_OVERLAY);
        NavAction action = new NavAction("navigation", icon, "Navigate to the address defined by this instruction set");
        this.createToolbarButton(buttonToolbar, icon, action, "nav button");
    }

    private void createMaskClearAllBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)CLEAR_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        ClearMasksAction action = new ClearMasksAction("undefined", scaledIcon, "Unmask all");
        this.createToolbarButton(buttonToolbar, icon, action, "unmask all button");
    }

    private void createReloadBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)RELOAD_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        ReloadAction action = new ReloadAction("undefined", scaledIcon, "Load selected instructions from listing");
        this.createToolbarButton(buttonToolbar, icon, action, "reload");
    }

    private void createManualEditBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)MANUAL_ENTRY_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        ManualEntryAction action = new ManualEntryAction("undefined", scaledIcon, "Enter bytes manually");
        this.createToolbarButton(buttonToolbar, icon, action, "manual entry");
    }

    private void createMaskDataBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)UNDEFINED_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        MaskUndefinedAction action = new MaskUndefinedAction("undefined", scaledIcon, "Mask all non-instructions (data)");
        this.createToolbarButton(buttonToolbar, icon, action, "mask undefined items button");
    }

    private void createMaskAddressesBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)ADDRESS_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        MaskAddressesAction action = new MaskAddressesAction("addresses", scaledIcon, "Mask all addresses");
        this.createToolbarButton(buttonToolbar, icon, action, "mask addresses button");
    }

    private void createMaskScalarsBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)SCALAR_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        MaskScalarsAction action = new MaskScalarsAction("scalars", scaledIcon, "Mask all scalars");
        this.createToolbarButton(buttonToolbar, icon, action, "mask scalars button");
    }

    private void createMaskOperandsBtn(JToolBar buttonToolbar) {
        ImageIcon icon = ResourceManager.loadImage((String)OPERAND_ICON_OVERLAY);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        MaskOperandsAction action = new MaskOperandsAction("operands", scaledIcon, "Mask all operands");
        this.createToolbarButton(buttonToolbar, icon, action, "mask operands button");
    }

    private void createToolbarButton(JToolBar toolbar1, Icon icon, Action action, String name) {
        EmptyBorderButton button = new EmptyBorderButton();
        button.setAction(action);
        button.setName(name);
        button.setHideActionText(true);
        toolbar1.add((Component)button);
    }

    private void processInstruction(InstructionTableDataObject[][] dataObjects, int instructionIndex) {
        for (int i = 0; i < this.numColumns; ++i) {
            if (i == 0) {
                this.processMnemonic(instructionIndex, i, dataObjects);
                continue;
            }
            this.processOperand(instructionIndex, i, dataObjects);
        }
    }

    private JMenuItem createColumnMaskUnmaskAllMenuItem(boolean mask, String menuLabel) {
        HelpLocation helpLocation = new HelpLocation("Tables", "GhidraTableHeaders");
        JMenuItem item = new JMenuItem(menuLabel);
        item.addActionListener(e -> {
            int rows = this.getRowCount();
            for (int row = 0; row < rows; ++row) {
                this.maskField(row, this.selectedColumn, mask);
            }
        });
        DockingWindowManager.getHelpService().registerHelp((Object)item, helpLocation);
        return item;
    }

    private InstructionTableDataObject[][] processMnemonic(int row, int col, InstructionTableDataObject[][] dataObjects) {
        dataObjects[row][col] = new InstructionTableDataObject(this.dialog.getSearchData().getInstructions().get(row).getTextRep(), this.dialog.getSearchData().getInstructions().get(row).isInstruction(), AbstractInstructionTable.OperandState.NOT_MASKED);
        return dataObjects;
    }

    private InstructionTableDataObject[][] processOperand(int row, int col, InstructionTableDataObject[][] dataObjects) {
        if (col <= 0) {
            return null;
        }
        OperandMetadata operandMetadata = null;
        List<OperandMetadata> operands = this.dialog.getSearchData().getInstructions().get(row).getOperands();
        if (operands.size() > col - 1) {
            operandMetadata = this.dialog.getSearchData().getInstructions().get(row).getOperands().get(col - 1);
        }
        if (operandMetadata != null) {
            InstructionTableDataObject obj = new InstructionTableDataObject(operandMetadata.getTextRep(), this.dialog.getSearchData().getInstructions().get(row).isInstruction(), AbstractInstructionTable.OperandState.NOT_MASKED);
            obj.setOperandCase(operandMetadata);
            dataObjects[row][col] = obj;
        } else {
            dataObjects[row][col] = new InstructionTableDataObject("", this.dialog.getSearchData().getInstructions().get(row).isInstruction(), AbstractInstructionTable.OperandState.NA);
        }
        return dataObjects;
    }

    private void maskNonInstructionsItems(final boolean mask) {
        Task bTask = new Task("Masking Non-Instructions", true, true, true){

            public void run(TaskMonitor monitor) {
                monitor.setMaximum((long)(InstructionTable.this.getRowCount() * InstructionTable.this.getColumnCount()));
                for (int i = 0; i < InstructionTable.this.getRowCount(); ++i) {
                    InstructionTableDataObject mnemonicObj = InstructionTable.this.getCellData(i, 0);
                    if (mnemonicObj.isInstruction()) continue;
                    for (int j = 0; j < InstructionTable.this.getColumnCount(); ++j) {
                        if (monitor.isCancelled()) {
                            return;
                        }
                        monitor.incrementProgress(1L);
                        InstructionTable.this.maskField(i, j, !mask);
                    }
                }
            }
        };
        new TaskLauncher(bTask, (Component)((Object)this));
        InstructionTableModel model = (InstructionTableModel)this.getModel();
        model.fireTableDataChanged();
    }

    private void clearAllMasks() {
        Task bTask = new Task("Clearing All Masks", true, true, true){

            public void run(TaskMonitor monitor) {
                monitor.setMaximum((long)(InstructionTable.this.getRowCount() * InstructionTable.this.getColumnCount()));
                for (int i = 0; i < InstructionTable.this.getRowCount(); ++i) {
                    for (int j = 0; j < InstructionTable.this.getColumnCount(); ++j) {
                        if (monitor.isCancelled()) {
                            return;
                        }
                        monitor.incrementProgress(1L);
                        InstructionTable.this.maskField(i, j, false);
                    }
                }
            }
        };
        new TaskLauncher(bTask, (Component)((Object)this));
        InstructionTableModel model = (InstructionTableModel)this.getModel();
        model.fireTableDataChanged();
    }

    private void maskAllOperands(final boolean mask) {
        Task bTask = new Task("Masking All Operands", true, true, true){

            public void run(TaskMonitor monitor) {
                monitor.setMaximum((long)(InstructionTable.this.getRowCount() * InstructionTable.this.getColumnCount()));
                for (int i = 0; i < InstructionTable.this.getRowCount(); ++i) {
                    for (int j = 0; j < InstructionTable.this.getColumnCount(); ++j) {
                        if (monitor.isCancelled()) {
                            return;
                        }
                        monitor.incrementProgress(1L);
                        InstructionTable.this.maskOperand(mask, i, j);
                    }
                }
            }
        };
        new TaskLauncher(bTask, (Component)((Object)this));
        InstructionTableModel model = (InstructionTableModel)this.getModel();
        model.fireTableDataChanged();
    }

    private void maskOperand(boolean mask, int i, int j) {
        InstructionTableDataObject obj = this.getCellData(i, j);
        if (obj != null && obj.getOperandCase() != null) {
            if (mask) {
                obj.setState(AbstractInstructionTable.OperandState.MASKED, false);
            } else {
                obj.setState(AbstractInstructionTable.OperandState.NOT_MASKED, false);
            }
        }
    }

    private void maskField(int row, int col, boolean mask) {
        InstructionTableDataObject obj = this.getCellData(row, col);
        if (obj == null || obj.getData() == null) {
            return;
        }
        if (obj.getState() != AbstractInstructionTable.OperandState.NA) {
            if (mask) {
                obj.setState(AbstractInstructionTable.OperandState.MASKED, false);
            } else {
                obj.setState(AbstractInstructionTable.OperandState.NOT_MASKED, false);
            }
        }
    }

    private void maskOperandsByType(final int opType, final boolean mask) {
        Task bTask = new Task("Masking Operands", true, true, true){

            public void run(TaskMonitor monitor) {
                monitor.setMaximum((long)(InstructionTable.this.getRowCount() * InstructionTable.this.getColumnCount()));
                for (int i = 0; i < InstructionTable.this.getRowCount(); ++i) {
                    for (int j = 0; j < InstructionTable.this.getColumnCount(); ++j) {
                        if (monitor.isCancelled()) {
                            return;
                        }
                        monitor.incrementProgress(1L);
                        InstructionTableDataObject obj = InstructionTable.this.getCellData(i, j);
                        InstructionTable.this.maskOperandByType(opType, mask, obj);
                    }
                }
            }
        };
        new TaskLauncher(bTask, (Component)((Object)this));
        InstructionTableModel model = (InstructionTableModel)this.getModel();
        model.fireTableDataChanged();
    }

    private void maskOperandByType(int opType, boolean mask, InstructionTableDataObject obj) {
        if (obj != null && obj.getOperandCase() != null) {
            switch (opType) {
                case 16384: {
                    if (!OperandType.isScalar((int)obj.getOperandCase().getOpType())) break;
                    if (mask) {
                        obj.setState(AbstractInstructionTable.OperandState.MASKED, false);
                        break;
                    }
                    obj.setState(AbstractInstructionTable.OperandState.NOT_MASKED, false);
                    break;
                }
                case 8192: {
                    if (!OperandType.isAddress((int)obj.getOperandCase().getOpType())) break;
                    if (mask) {
                        obj.setState(AbstractInstructionTable.OperandState.MASKED, false);
                        break;
                    }
                    obj.setState(AbstractInstructionTable.OperandState.NOT_MASKED, false);
                }
            }
        }
    }

    private class NavAction
    extends AbstractAction {
        public NavAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GoToService gs = (GoToService)InstructionTable.this.plugin.getTool().getService(GoToService.class);
            if (InstructionTable.this.dialog.getSearchData().getInstructions().size() <= 0) {
                return;
            }
            Address firstAddr = InstructionTable.this.dialog.getSearchData().getInstructions().get(0).getAddr();
            if (firstAddr != null) {
                gs.goTo(firstAddr);
            } else if (InstructionTable.this.dialog.getMessagePanel() != null) {
                InstructionTable.this.dialog.getMessagePanel().setMessageText("Instruction was loaded manually, no address in the listing to navigate to.", Color.BLUE);
            }
        }
    }

    private class ClearMasksAction
    extends AbstractAction {
        public ClearMasksAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionTable.this.clearAllMasks();
        }
    }

    private class ReloadAction
    extends AbstractAction {
        public ReloadAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                InstructionTable.this.dialog.loadInstructions(InstructionTable.this.plugin);
            }
            catch (InvalidInputException e1) {
                Msg.error((Object)this, (Object)("Error loading instructions: " + e));
            }
        }
    }

    private class ManualEntryAction
    extends AbstractAction {
        public ManualEntryAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionTable.this.insertBytesWidget = InstructionTable.this.getInsertBytesWidget();
            InstructionTable.this.plugin.getTool().showDialog((DialogComponentProvider)InstructionTable.this.insertBytesWidget, (Component)InstructionTable.this.plugin.getSearchDialog().getComponent());
        }
    }

    private class MaskUndefinedAction
    extends AbstractAction {
        public MaskUndefinedAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionTable.this.maskNonInstructionsItems(false);
        }
    }

    private class MaskAddressesAction
    extends AbstractAction {
        public MaskAddressesAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionTable.this.maskOperandsByType(8192, true);
        }
    }

    private class MaskScalarsAction
    extends AbstractAction {
        public MaskScalarsAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionTable.this.maskOperandsByType(16384, true);
        }
    }

    private class MaskOperandsAction
    extends AbstractAction {
        public MaskOperandsAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionTable.this.maskAllOperands(true);
        }
    }
}

