/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.JComboBox;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class PreviousFunctionAction
extends DockingAction {
    private static final String FUNCTION_NAVIGATE_GROUP = "A9_FunctionNavigate";
    private static final Icon PREVIOUS_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/arrow_up.png"), 3, 1);
    private static final Icon FUNCTION_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/FunctionScope.gif"), -5, -2);
    private static final Icon PREVIOUS_FUNCTION_ICON = new MultiIcon(PREVIOUS_ICON, new Icon[]{FUNCTION_ICON});

    public PreviousFunctionAction(MultiFunctionComparisonProvider provider) {
        super("Compare Previous Function", provider.getOwner());
        this.setKeyBindingData(new KeyBindingData('P', 192));
        this.setDescription("Compare the previous function for the side with focus.");
        this.setPopupMenuData(new MenuData(new String[]{"Compare The Previous Function"}, PREVIOUS_FUNCTION_ICON, FUNCTION_NAVIGATE_GROUP));
        ToolBarData newToolBarData = new ToolBarData(PREVIOUS_FUNCTION_ICON, FUNCTION_NAVIGATE_GROUP);
        this.setToolBarData(newToolBarData);
        HelpLocation helpLocation = new HelpLocation("FunctionComparison", "Navigate Previous");
        this.setHelpLocation(helpLocation);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context.getComponentProvider() instanceof MultiFunctionComparisonProvider)) {
            return false;
        }
        MultiFunctionComparisonProvider provider = (MultiFunctionComparisonProvider)context.getComponentProvider();
        FunctionComparisonPanel comp = provider.getComponent();
        if (!(comp instanceof MultiFunctionComparisonPanel)) {
            return false;
        }
        MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)comp;
        JComboBox<Function> focusedComponent = panel.getFocusedComponent();
        return focusedComponent.getSelectedIndex() > 0;
    }

    public void actionPerformed(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)provider.getComponent();
        JComboBox<Function> focusedComponent = panel.getFocusedComponent();
        focusedComponent.setSelectedIndex(focusedComponent.getSelectedIndex() - 1);
    }
}

