/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

class BackgroundIcon
implements Icon {
    private static Color VERSION_ICON_COLOR_DARK = new Color(130, 130, 255);
    private static Color VERSION_ICON_COLOR_LIGHT = new Color(159, 159, 255);
    private int width;
    private int height;
    private boolean isVersioned;

    BackgroundIcon(int width, int height, boolean isVersioned) {
        this.width = width;
        this.height = height;
        this.isVersioned = isVersioned;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.isVersioned) {
            g.setColor(VERSION_ICON_COLOR_LIGHT);
            g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g.setColor(VERSION_ICON_COLOR_DARK);
            g.drawLine(x + 1, y, x + this.width - 2, y);
            g.drawLine(x + this.width - 1, y + 1, x + this.width - 1, y + this.height - 2);
            g.drawLine(x + 1, y + this.height - 1, x + this.width - 2, y + this.height - 1);
            g.drawLine(x, y + 1, x, y + this.height - 2);
        } else {
            g.setColor(c.getBackground());
            g.fillRect(x, y, this.width, this.height);
        }
    }
}

