/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.actions.AnnotationHandlerDialog;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.data.AnnotationHandler;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWriter;
import ghidra.program.model.data.DefaultAnnotationHandler;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreePath;

public class ExportToHeaderAction
extends DockingAction {
    private static final String LAST_DATA_TYPE_EXPORT_DIRECTORY = "LAST_DATA_TYPE_EXPORT_DIRECTORY";
    private final DataTypeManagerPlugin plugin;

    public ExportToHeaderAction(DataTypeManagerPlugin plugin) {
        super("Export Data Types", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Export C Header..."}, null, "VeryLast"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        TreePath[] selectionPaths;
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        for (TreePath path : selectionPaths = gtree.getSelectionPaths()) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (this.isValidNode(node)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidNode(GTreeNode node) {
        if (node instanceof CategoryNode) {
            CategoryNode categoryNode = (CategoryNode)node;
            return categoryNode.isEnabled();
        }
        return node instanceof DataTypeNode;
    }

    public void actionPerformed(ActionContext context) {
        DataTypesActionContext dtActionContext = (DataTypesActionContext)context;
        GTree gTree = (GTree)dtActionContext.getContextObject();
        Program program = dtActionContext.getProgram();
        if (program == null) {
            Msg.showError((Object)((Object)this), (Component)gTree, (String)"Archive Export Failed", (Object)"A suitable program must be open and activated before\nan archive export may be performed.");
            return;
        }
        if (OptionDialog.showYesNoDialog((Component)gTree, (String)"Confirm Archive Export", (String)("Export selected archive(s) using program " + program.getName() + "'s compiler specification?")) != 1) {
            return;
        }
        this.exportToC(gTree, (DataTypeManager)program.getDataTypeManager());
    }

    private void exportToC(GTree gTree, DataTypeManager programDataTypeMgr) {
        List classes = ClassSearcher.getClasses(AnnotationHandler.class);
        ArrayList<AnnotationHandler> list = new ArrayList<AnnotationHandler>();
        Class[] constructorArgumentTypes = new Class[]{};
        for (Class clazz : classes) {
            if (clazz == DefaultAnnotationHandler.class) continue;
            try {
                Constructor constructor = clazz.getConstructor(constructorArgumentTypes);
                Object t = constructor.newInstance(new Object[0]);
                list.add((AnnotationHandler)AnnotationHandler.class.cast(t));
            }
            catch (Exception e) {
                Msg.showError((Object)((Object)this), (Component)this.plugin.getTool().getToolFrame(), (String)"Export Data Types", (Object)("Error creating " + clazz.getName() + "\n" + e.toString()), (Throwable)e);
            }
        }
        DefaultAnnotationHandler handler = null;
        if (!list.isEmpty()) {
            list.add(0, (AnnotationHandler)new DefaultAnnotationHandler());
            AnnotationHandlerDialog dlg = new AnnotationHandlerDialog(list);
            this.plugin.getTool().showDialog((DialogComponentProvider)dlg);
            if (!dlg.wasSuccessful()) {
                return;
            }
            handler = dlg.getHandler();
        } else {
            handler = new DefaultAnnotationHandler();
        }
        TreePath[] paths = gTree.getSelectionPaths();
        HashMap<DataTypeManager, List<DataType>> managersToDataTypesMap = new HashMap<DataTypeManager, List<DataType>>();
        for (TreePath treePath : paths) {
            this.addToManager(treePath, managersToDataTypesMap);
        }
        GhidraFileChooser ghidraFileChooser = new GhidraFileChooser((Component)gTree);
        String[] fileExtensions = handler.getFileExtensions();
        if (fileExtensions.length > 0) {
            ghidraFileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(fileExtensions, handler.getLanguageName() + " Files"));
        }
        Set entrySet = managersToDataTypesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            DataTypeManager dataTypeManager = (DataTypeManager)entry.getKey();
            File file = this.getFile(gTree, ghidraFileChooser, dataTypeManager, (AnnotationHandler)handler);
            if (file == null) {
                return;
            }
            List dataTypeList = (List)entry.getValue();
            new TaskLauncher((Task)new DataTypeWriterTask(gTree, programDataTypeMgr, dataTypeList, (AnnotationHandler)handler, file), (Component)gTree);
        }
    }

    private void addToManager(TreePath path, Map<DataTypeManager, List<DataType>> managersToDataTypesMap) {
        Object last = path.getLastPathComponent();
        if (last instanceof DataTypeNode) {
            DataTypeNode node = (DataTypeNode)((Object)last);
            DataType dataType = node.getDataType();
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            List<DataType> dataTypeList = managersToDataTypesMap.get(dataTypeManager);
            if (dataTypeList == null) {
                dataTypeList = new ArrayList<DataType>();
                managersToDataTypesMap.put(dataTypeManager, dataTypeList);
            }
            dataTypeList.add(dataType);
        } else if (last instanceof CategoryNode) {
            CategoryNode node = (CategoryNode)((Object)last);
            List children = node.getChildren();
            for (GTreeNode cnode : children) {
                this.addToManager(cnode.getTreePath(), managersToDataTypesMap);
            }
        }
    }

    private File getFile(GTree gTree, GhidraFileChooser fileChooser, DataTypeManager dataTypeManager, AnnotationHandler handler) {
        String[] fileExtensions;
        File file;
        fileChooser.setTitle("Select File For Export: " + dataTypeManager.getName());
        fileChooser.setSelectedFile(null);
        String defaultExtendsionSuffix = ".h";
        String lastDirSelected = Preferences.getProperty((String)LAST_DATA_TYPE_EXPORT_DIRECTORY);
        if (lastDirSelected != null && (file = new File(lastDirSelected)).exists()) {
            fileChooser.setCurrentDirectory(file);
        }
        fileChooser.rescanCurrentDirectory();
        File currentDirectory = fileChooser.getCurrentDirectory();
        File newFile = new File(currentDirectory, dataTypeManager.getName() + defaultExtendsionSuffix);
        fileChooser.setSelectedFile(newFile);
        File file2 = fileChooser.getSelectedFile();
        if (file2 == null) {
            return null;
        }
        boolean hasKnownExtension = false;
        String path = file2.getAbsolutePath();
        for (String element : fileExtensions = handler.getFileExtensions()) {
            if (!path.toLowerCase().endsWith("." + element)) continue;
            hasKnownExtension = true;
        }
        if (!hasKnownExtension) {
            file2 = new File(path + defaultExtendsionSuffix);
        }
        if (file2.exists() && OptionDialog.showYesNoDialog((Component)gTree, (String)"Overwrite Existing File?", (String)("Do you want to overwrite the existing file \"" + file2.getAbsolutePath() + "\"?")) == 2) {
            return null;
        }
        Preferences.setProperty((String)LAST_DATA_TYPE_EXPORT_DIRECTORY, (String)file2.getAbsolutePath());
        return file2;
    }

    private class DataTypeWriterTask
    extends Task {
        private final DataTypeManager programDataTypeMgr;
        private final List<DataType> dataTypeList;
        private final AnnotationHandler handler;
        private final File file;
        private final GTree gTree;

        DataTypeWriterTask(GTree gTree, DataTypeManager programDataTypeMgr, List<DataType> dataTypeList, AnnotationHandler handler, File file) {
            super("Export Data Types", true, false, true);
            this.gTree = gTree;
            this.programDataTypeMgr = programDataTypeMgr;
            this.dataTypeList = dataTypeList;
            this.handler = handler;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            try {
                monitor.setMessage("Export to " + this.file.getName() + "...");
                try (PrintWriter writer = new PrintWriter(this.file);){
                    DataTypeWriter dataTypeWriter = new DataTypeWriter(this.programDataTypeMgr, (Writer)writer, this.handler);
                    dataTypeWriter.write(this.dataTypeList, monitor, false);
                }
                ExportToHeaderAction.this.plugin.getTool().setStatusInfo("Successfully exported data type(s) to " + this.file.getAbsolutePath());
            }
            catch (CancelledException writer) {
            }
            catch (IOException e) {
                Msg.showError(((Object)((Object)this)).getClass(), (Component)this.gTree, (String)"Export Data Types Failed", (Object)("Error exporting Data Types: " + e));
                return;
            }
        }
    }
}

