/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.util.NumericUtilities;
import java.nio.ByteBuffer;

public class FridaReadKernelMemoryCommand
extends AbstractFridaCommand<RangeSet<Long>> {
    private final Address addr;
    private final ByteBuffer buf;
    private final int len;

    public FridaReadKernelMemoryCommand(FridaManagerImpl manager, Address addr, ByteBuffer buf, int len) {
        super(manager);
        this.addr = addr;
        this.buf = buf;
        this.len = len;
    }

    @Override
    public RangeSet<Long> complete(FridaPendingCommand<?> pending) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closedOpen((Comparable)Long.valueOf(this.addr.getOffset()), (Comparable)Long.valueOf(this.addr.getOffset() + (long)this.len)));
        return rangeSet;
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "read_memory", "var buf = Kernel.readByteArray(ptr(0x" + this.addr + ")" + this.len + "); result = hexdump(buf, {header:false});");
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        String payload = element.getAsString();
        String[] lines = payload.split("\n");
        int n = 0;
        for (String l : lines) {
            String[] split = l.split("  ");
            byte[] bytes = NumericUtilities.convertStringToBytes((String)split[1]);
            for (int i = 0; i < 16; ++i) {
                this.buf.put(n + i, bytes[i]);
            }
            n += 16;
        }
    }
}

