/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.LayoutLocationMap;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.layout.Row;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.renderer.ArticulatedEdgeRenderer;
import ghidra.graph.viewer.shape.ArticulatedEdgeTransformer;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractVisualGraphLayout<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractLayout<V, E>
implements VisualGraphLayout<V, E> {
    private WeakSet<LayoutListener<V, E>> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private ArticulatedEdgeTransformer<V, E> edgeShapeTransformer = new ArticulatedEdgeTransformer();
    private ArticulatedEdgeRenderer<V, E> edgeRenderer = new ArticulatedEdgeRenderer();
    protected String layoutName;
    protected boolean layoutInitialized;
    protected TaskMonitor monitor = TaskMonitor.DUMMY;

    protected AbstractVisualGraphLayout(Graph<V, E> graph, String layoutName) {
        super(graph);
        this.layoutName = layoutName;
    }

    public String getLayoutName() {
        return this.layoutName;
    }

    protected abstract GridLocationMap<V, E> performInitialGridLayout(VisualGraph<V, E> var1) throws CancelledException;

    public void setTaskMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public BasicEdgeRenderer<V, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    @Override
    public Function<E, Shape> getEdgeShapeTransformer() {
        return this.edgeShapeTransformer;
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer() {
        return null;
    }

    @Override
    public boolean usesEdgeArticulations() {
        return false;
    }

    public void reset() {
    }

    @Override
    public void dispose() {
        this.listeners.clear();
    }

    protected boolean isCondensedLayout() {
        return false;
    }

    public void initialize() {
        if (this.layoutInitialized) {
            return;
        }
        int vertexCount = this.graph.getVertexCount();
        if (vertexCount == 0) {
            return;
        }
        this.layoutInitialized = true;
        LayoutPositions<V, E> positions = this.calculateLocations(this.getVisualGraph(), this.monitor);
        this.applyNewLocations(positions.getVertexLocations());
        this.applyNewArticulations(positions.getEdgeArticulations());
        positions.dispose();
    }

    @Override
    public LayoutPositions<V, E> calculateLocations(VisualGraph<V, E> visualGraph, TaskMonitor taskMonitor) {
        int vertexCount = visualGraph.getVertexCount();
        if (vertexCount == 0) {
            return LayoutPositions.createEmptyPositions();
        }
        return this.doCalculateLocations(visualGraph, taskMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LayoutPositions<V, E> doCalculateLocations(VisualGraph<V, E> g, TaskMonitor taskMonitor) {
        GridLocationMap<V, E> gridLocations = null;
        try {
            LayoutPositions<V, E> positions;
            this.monitor = taskMonitor;
            gridLocations = this.performInitialGridLayout(g);
            LayoutPositions<V, E> layoutPositions = positions = this.positionInLayoutSpaceFromGrid(g, gridLocations);
            return layoutPositions;
        }
        catch (CancelledException ce) {
            LayoutPositions layoutPositions = LayoutPositions.createEmptyPositions();
            return layoutPositions;
        }
        finally {
            if (gridLocations != null) {
                gridLocations.dispose();
            }
            this.monitor = TaskMonitor.DUMMY;
        }
    }

    public abstract AbstractVisualGraphLayout<V, E> createClonedLayout(VisualGraph<V, E> var1);

    @Override
    public VisualGraphLayout<V, E> cloneLayout(VisualGraph<V, E> newGraph) {
        AbstractVisualGraphLayout<V, E> layout = this.createClonedLayout(newGraph);
        this.initializeClonedLayout(layout);
        return layout;
    }

    protected void initializeClonedLayout(AbstractVisualGraphLayout<V, E> newLayout) {
        AbstractVisualGraphLayout originalLayout = this;
        VisualGraph originalGraph = this.getVisualGraph();
        Collection vertices = originalGraph.getVertices();
        for (VisualVertex v : vertices) {
            Point2D location = originalLayout.apply(v);
            newLayout.setLocation(v, location);
        }
        Collection edges = originalGraph.getEdges();
        Map<VisualEdge, List> edgesToBends = edges.stream().collect(Collectors.toMap(e -> e, e -> e.getArticulationPoints()));
        VisualGraph newGraph = newLayout.getVisualGraph();
        Collection newEdges = newGraph.getEdges();
        for (VisualEdge e2 : newEdges) {
            List bends = edgesToBends.get(e2);
            if (bends == null) continue;
            ArrayList<Point2D> newBends = new ArrayList<Point2D>();
            for (Point2D p : bends) {
                newBends.add((Point2D)p.clone());
            }
            e2.setArticulationPoints(newBends);
        }
        newLayout.layoutInitialized = true;
    }

    protected void applyNewLocations(Map<V, Point2D> newLocations) {
        Set<Map.Entry<V, Point2D>> entrySet = newLocations.entrySet();
        for (Map.Entry<V, Point2D> entry : entrySet) {
            VisualVertex vertex = (VisualVertex)entry.getKey();
            Point2D location = entry.getValue();
            this.setLocation((V)vertex, location);
            vertex.setLocation(location);
        }
    }

    protected void applyNewArticulations(Map<E, List<Point2D>> edgeArticulations) {
        Set<Map.Entry<E, List<Point2D>>> entrySet = edgeArticulations.entrySet();
        for (Map.Entry<E, List<Point2D>> entry : entrySet) {
            VisualEdge edge = (VisualEdge)entry.getKey();
            List<Point2D> articulations = entry.getValue();
            edge.setArticulationPoints(articulations);
        }
    }

    protected LayoutPositions<V, E> positionInLayoutSpaceFromGrid(VisualGraph<V, E> visualGraph, GridLocationMap<V, E> gridLocations) throws CancelledException {
        VisualGraphVertexShapeTransformer transformer = new VisualGraphVertexShapeTransformer();
        Collection vertices = visualGraph.getVertices();
        Collection edges = visualGraph.getEdges();
        boolean isCondensed = this.isCondensedLayout();
        LayoutLocationMap<V, E> layoutLocations = new LayoutLocationMap<V, E>(gridLocations, transformer, isCondensed, this.monitor);
        Map vertexLayoutLocations = this.positionVerticesInLayoutSpace(transformer, vertices, layoutLocations);
        Rectangle graphBounds = this.getTotalGraphSize(vertexLayoutLocations, transformer);
        double centerX = graphBounds.getCenterX();
        double centerY = graphBounds.getCenterY();
        if (isCondensed) {
            List<Row<V>> rows = gridLocations.rows();
            this.condenseVertices(rows, vertexLayoutLocations, transformer, centerX, centerY);
        }
        Map edgeLayoutArticulations = this.positionEdgeArticulationsInLayoutSpace(transformer, vertexLayoutLocations, edges, layoutLocations);
        if (isCondensed) {
            List<Row<V>> rows = gridLocations.rows();
            this.condenseEdges(rows, edgeLayoutArticulations, centerX, centerY);
        }
        layoutLocations.dispose();
        gridLocations.dispose();
        return LayoutPositions.createNewPositions(vertexLayoutLocations, edgeLayoutArticulations);
    }

    private Map<V, Point2D> positionVerticesInLayoutSpace(VisualGraphVertexShapeTransformer<V> transformer, Collection<V> vertices, LayoutLocationMap<V, E> layoutLocations) throws CancelledException {
        HashMap<VisualVertex, Point2D> newLocations = new HashMap<VisualVertex, Point2D>();
        for (VisualVertex vertex : vertices) {
            this.monitor.checkCanceled();
            Row<VisualVertex> row = layoutLocations.row(vertex);
            Column column = layoutLocations.col(vertex);
            Shape shape = transformer.apply(vertex);
            Rectangle bounds = shape.getBounds();
            Point2D location = this.getVertexLocation(vertex, column, row, bounds);
            newLocations.put(vertex, location);
        }
        return newLocations;
    }

    protected Point2D getVertexLocation(V v, Column col, Row<V> row, Rectangle bounds) {
        int x = col.x - bounds.x;
        int y = row.y - bounds.y;
        return new Point2D.Double(x, y);
    }

    protected Point2D getCenteredVertexLocation(V v, Column col, Row<V> row, Rectangle bounds) {
        boolean isCondensed = this.isCondensedLayout();
        int x = col.x + (col.getPaddedWidth(isCondensed) >> 1);
        if (isCondensed) {
            x = col.x;
        }
        int y = row.y + (bounds.height >> 1);
        return new Point2D.Double(x, y);
    }

    protected Map<E, List<Point2D>> positionEdgeArticulationsInLayoutSpace(VisualGraphVertexShapeTransformer<V> transformer, Map<V, Point2D> vertexLayoutLocations, Collection<E> edges, LayoutLocationMap<V, E> layoutLocations) throws CancelledException {
        HashMap newEdgeArticulations = new HashMap();
        for (VisualEdge edge : edges) {
            this.monitor.checkCanceled();
            ArrayList<Point2D> newArticulations = new ArrayList<Point2D>();
            for (Point gridPoint : layoutLocations.articulations(edge)) {
                Row<V> row = layoutLocations.row(gridPoint.y);
                Column column = layoutLocations.col(gridPoint.x);
                Point2D location = this.getEdgeLocation(column, row);
                newArticulations.add(location);
            }
            newEdgeArticulations.put(edge, newArticulations);
        }
        return newEdgeArticulations;
    }

    protected Point2D getEdgeLocation(Column col, Row<V> row) {
        return new Point2D.Double(col.x, row.y);
    }

    protected Point2D getCenteredEdgeLocation(Column col, Row<V> row) {
        boolean isCondensed = this.isCondensedLayout();
        int x = col.x + (col.getPaddedWidth(isCondensed) >> 1);
        int y = row.y + (row.getPaddedHeight(isCondensed) >> 1);
        return new Point2D.Double(x, y);
    }

    private Rectangle getTotalGraphSize(Map<V, Point2D> vertexLocationMap, Function<V, Shape> vertexShapeTransformer) {
        Set<V> vertices = vertexLocationMap.keySet();
        Set edges = Collections.emptySet();
        Function vertexToBounds = v -> {
            Shape s = (Shape)vertexShapeTransformer.apply(v);
            Rectangle bounds = s.getBounds();
            Point2D p = (Point2D)vertexLocationMap.get(v);
            bounds.setLocation(new Point((int)p.getX(), (int)p.getY()));
            return bounds;
        };
        if (!this.usesEdgeArticulations()) {
            Rectangle bounds = GraphViewerUtils.getBoundsForVerticesInLayoutSpace(vertices, vertexToBounds);
            return bounds;
        }
        Function edgeToArticulations = e -> Collections.emptyList();
        Rectangle bounds = GraphViewerUtils.getTotalGraphSizeInLayoutSpace(vertices, edges, vertexToBounds, edgeToArticulations);
        return bounds;
    }

    protected void condenseVertices(List<Row<V>> rows, Map<V, Point2D> newLocations, VisualGraphVertexShapeTransformer<V> transformer, double centerX, double centerY) {
        double condenseFactor = this.getCondenseFactor();
        Collection<Point2D> vertexPoints = newLocations.values();
        for (Point2D point : vertexPoints) {
            double currentX = point.getX();
            double currentY = point.getY();
            double deltaX = centerX - currentX;
            double offsetX = deltaX * condenseFactor + currentX;
            point.setLocation(offsetX, currentY);
        }
        this.unclip(rows, newLocations, transformer);
    }

    protected void condenseEdges(List<Row<V>> rows, Map<E, List<Point2D>> newEdgeArticulations, double centerX, double centerY) {
        double condenseFactor = this.getCondenseFactor();
        Collection<List<Point2D>> edgeArticulations = newEdgeArticulations.values();
        for (List<Point2D> edgePoints : edgeArticulations) {
            for (Point2D point : edgePoints) {
                double currentX = point.getX();
                double currentY = point.getY();
                double deltaX = centerX - currentX;
                double offsetX = deltaX * condenseFactor + currentX;
                point.setLocation(offsetX, currentY);
            }
        }
    }

    protected double getCondenseFactor() {
        return 0.5;
    }

    private void unclip(List<Row<V>> rows, Map<V, Point2D> newLocations, VisualGraphVertexShapeTransformer<V> transformer) {
        for (Row<V> row : rows) {
            Integer columnCount = row.getColumnCount();
            int moveLeftStartIndex = columnCount >> 1;
            int moveRightStartIndex = Math.min(moveLeftStartIndex + 1, columnCount - 1);
            this.moveLeft(row, moveLeftStartIndex, newLocations, transformer);
            this.moveRight(row, moveRightStartIndex, newLocations, transformer);
        }
    }

    private void moveLeft(Row<V> row, int moveLeftStartIndex, Map<V, Point2D> vertexLocations, VisualGraphVertexShapeTransformer<V> transformer) {
        for (int i = moveLeftStartIndex; i >= row.getStartColumn(); --i) {
            VisualVertex vertex = (VisualVertex)row.getVertex(i);
            V rightVertex = this.getRightVertex(row, i);
            this.moveLeftIfOverlaps(vertexLocations, transformer, vertex, rightVertex);
        }
    }

    private void moveRight(Row<V> row, int moveRightStartIndex, Map<V, Point2D> vertexLocations, VisualGraphVertexShapeTransformer<V> transformer) {
        for (int i = moveRightStartIndex; i <= row.getEndColumn(); ++i) {
            VisualVertex vertex = (VisualVertex)row.getVertex(i);
            V leftVertex = this.getLeftVertex(row, i);
            this.moveRightIfOverlaps(vertexLocations, transformer, vertex, leftVertex);
        }
    }

    private V getLeftVertex(Row<V> row, int index) {
        if (index == 0) {
            return null;
        }
        VisualVertex vertex = (VisualVertex)row.getVertex(index - 1);
        if (vertex == null) {
            return this.getLeftVertex(row, index - 1);
        }
        return (V)vertex;
    }

    private V getRightVertex(Row<V> row, int index) {
        if (index == row.getColumnCount() - 1) {
            return null;
        }
        VisualVertex vertex = (VisualVertex)row.getVertex(index + 1);
        if (vertex == null) {
            return this.getRightVertex(row, index + 1);
        }
        return (V)vertex;
    }

    private void moveLeftIfOverlaps(Map<V, Point2D> vertexLocations, VisualGraphVertexShapeTransformer<V> xform, V vertex, V rightVertex) {
        this.moveIfOverlaps(vertexLocations, xform, vertex, rightVertex, false);
    }

    private void moveRightIfOverlaps(Map<V, Point2D> vertexLocations, VisualGraphVertexShapeTransformer<V> xform, V vertex, V leftVertex) {
        this.moveIfOverlaps(vertexLocations, xform, vertex, leftVertex, true);
    }

    private void moveIfOverlaps(Map<V, Point2D> vertexLocations, VisualGraphVertexShapeTransformer<V> xform, V vertex, V otherVertex, boolean moveRight) {
        if (vertex == null || otherVertex == null) {
            return;
        }
        Shape vertexShape = xform.apply(vertex);
        Point2D vertexPoint = vertexLocations.get(vertex);
        Rectangle vertexBounds = vertexShape.getBounds();
        Shape otherVertexShape = xform.apply(otherVertex);
        Point2D otherVertexPoint = vertexLocations.get(otherVertex);
        Rectangle otherVertexBounds = otherVertexShape.getBounds();
        int myWidth = vertexBounds.width >> 1;
        int myHeight = vertexBounds.height >> 1;
        double x = vertexPoint.getX();
        double y = vertexPoint.getY();
        int otherWidth = otherVertexBounds.width >> 1;
        int otherHeight = otherVertexBounds.height >> 1;
        double otherX = otherVertexPoint.getX();
        double otherY = otherVertexPoint.getY();
        Point myNewPoint = new Point((int)x - myWidth, (int)y - myHeight);
        vertexBounds.setLocation(myNewPoint);
        Point otherNewPoint = new Point((int)otherX - otherWidth, (int)otherY - otherHeight);
        otherVertexBounds.setLocation(otherNewPoint);
        boolean hasCrossed = this.hasCrossed(moveRight, myNewPoint, otherNewPoint);
        Rectangle intersection = vertexBounds.intersection(otherVertexBounds);
        if (!hasCrossed && intersection.isEmpty()) {
            return;
        }
        int spacer = 10;
        int width = myWidth + otherWidth;
        double offset = width + spacer;
        if (!moveRight) {
            offset = -offset;
        }
        double oldY = vertexPoint.getY();
        double newX = otherX + offset;
        vertexPoint.setLocation(newX, oldY);
    }

    private boolean hasCrossed(boolean moveRight, Point p1, Point p2) {
        boolean crossed = moveRight ? p1.x < p2.x : p1.x > p2.x;
        return crossed;
    }

    @Override
    public void addLayoutListener(LayoutListener<V, E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayoutListener(LayoutListener<V, E> listener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LayoutListener layoutListener = (LayoutListener)iterator.next();
            if (layoutListener != listener) continue;
            iterator.remove();
        }
    }

    private void fireVertexLocationChanged(V v, Point2D p) {
        this.fireVertexLocationChanged(v, p, LayoutListener.ChangeType.USER);
    }

    private void fireVertexLocationChanged(V v, Point2D p, LayoutListener.ChangeType type) {
        for (LayoutListener layoutListener : this.listeners) {
            layoutListener.vertexLocationChanged(v, p, type);
        }
    }

    public void setLocation(V v, Point2D location) {
        super.setLocation(v, location);
        this.fireVertexLocationChanged(v, location);
    }

    @Override
    public void setLocation(V v, Point2D location, LayoutListener.ChangeType changeType) {
        super.setLocation(v, location);
        this.fireVertexLocationChanged(v, location, changeType);
    }
}

