/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.exception.DuplicateNameException;

public abstract class FactoryStructureDataType
extends BuiltIn
implements FactoryDataType {
    protected FactoryStructureDataType(String name, DataTypeManager dtm) {
        super(null, name, dtm);
    }

    @Override
    public abstract DataType clone(DataTypeManager var1);

    @Override
    public final int getLength() {
        return -1;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getDescription() {
        return "Dynamic Data Type should not be instantiated directly";
    }

    @Override
    public DataType getDataType(MemBuffer buf) {
        Structure struct = new StructureDataType(this.getName(), 0);
        if (buf != null) {
            this.populateDynamicStructure(buf, struct);
            struct = this.setCategoryPath(struct, buf);
        }
        return struct;
    }

    protected Structure setCategoryPath(Structure struct, MemBuffer buf) {
        CategoryPath path = CategoryPath.ROOT;
        try {
            path = new CategoryPath(new CategoryPath(CategoryPath.ROOT, this.getName()), "" + buf.getAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCategory(struct, path);
        return struct;
    }

    private void setCategory(DataType dt, CategoryPath path) {
        if (dt == null) {
            return;
        }
        try {
            dt.setCategoryPath(path);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        if (dt instanceof Structure) {
            DataTypeComponent[] comps;
            Structure struct = (Structure)dt;
            for (DataTypeComponent comp : comps = struct.getDefinedComponents()) {
                this.setCategory(comp.getDataType(), path);
            }
        } else if (dt instanceof Union) {
            DataTypeComponent[] comps;
            Union union = (Union)dt;
            for (DataTypeComponent comp : comps = union.getComponents()) {
                this.setCategory(comp.getDataType(), path);
            }
        } else if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getDataType();
            this.setCategory(dt, path);
        } else if (dt instanceof Pointer) {
            this.setCategory(((Pointer)dt).getDataType(), path);
        } else if (dt instanceof Array) {
            Array array = (Array)dt;
            this.setCategory(array.getDataType(), path);
        }
    }

    protected DataTypeComponent addComponent(Structure es, DataType dt, String componentName) {
        return es.add(dt, dt.getLength(), componentName, null);
    }

    protected abstract void populateDynamicStructure(MemBuffer var1, Structure var2);
}

