/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.ArrayDBAdapterV0;
import ghidra.program.database.data.ArrayDBAdapterV1;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class ArrayDBAdapter {
    static final Schema SCHEMA = ArrayDBAdapterV1.V1_SCHEMA;
    static final int ARRAY_DT_ID_COL = 0;
    static final int ARRAY_DIM_COL = 1;
    static final int ARRAY_ELEMENT_LENGTH_COL = 2;
    static final int ARRAY_CAT_COL = 3;

    ArrayDBAdapter() {
    }

    static ArrayDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new ArrayDBAdapterV1(handle, true);
        }
        try {
            return new ArrayDBAdapterV1(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            ArrayDBAdapter adapter = ArrayDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = ArrayDBAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static ArrayDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        return new ArrayDBAdapterV0(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayDBAdapter upgrade(DBHandle handle, ArrayDBAdapter oldAdapter) throws VersionException, IOException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        ArrayDBAdapterV1 tmpAdapter = null;
        try {
            tmpAdapter = new ArrayDBAdapterV1(tmpHandle, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                ((ArrayDBAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            ArrayDBAdapterV1 newAdapter = new ArrayDBAdapterV1(handle, true);
            it = ((ArrayDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                newAdapter.updateRecord(rec);
            }
            ArrayDBAdapterV1 arrayDBAdapterV1 = newAdapter;
            return arrayDBAdapterV1;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract DBRecord createRecord(long var1, int var3, int var4, long var5) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;
}

