/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class AssemblyNumericSymbols {
    public static final AssemblyNumericSymbols EMPTY = new AssemblyNumericSymbols(Map.of(), Map.of(), Map.of());
    private final NavigableSet<String> all = new TreeSet<String>();
    public final Map<String, Set<Long>> equates;
    public final Map<String, Set<Address>> labels;
    public final Map<AddressSpace, Map<String, Set<Address>>> labelsBySpace;

    private static void collectLanguageLabels(Map<String, Set<Address>> labels, Language language) {
        for (Register reg : language.getRegisters()) {
            if (reg.getAddressSpace().isRegisterSpace()) continue;
            labels.computeIfAbsent(reg.getName(), n -> new HashSet()).add(reg.getAddress());
        }
    }

    private static void collectProgramLabels(Map<String, Set<Address>> labels, Program program) {
        SymbolIterator it = program.getSymbolTable().getAllSymbols(true);
        while (it.hasNext()) {
            Function function;
            Address[] thunks;
            Symbol sym = it.next();
            SymbolType symbolType = sym.getSymbolType();
            if (symbolType == SymbolType.LABEL) {
                if (sym.isExternal()) continue;
                labels.computeIfAbsent(sym.getName(), n -> new HashSet()).add(sym.getAddress());
                continue;
            }
            if (symbolType != SymbolType.FUNCTION) continue;
            if (!sym.getAddress().isExternalAddress()) {
                labels.computeIfAbsent(sym.getName(), n -> new HashSet()).add(sym.getAddress());
            }
            if ((thunks = (function = (Function)sym.getObject()).getFunctionThunkAddresses(true)) == null) continue;
            for (Address t : thunks) {
                if (t.isExternalAddress()) continue;
                labels.computeIfAbsent(sym.getName(), n -> new HashSet()).add(t);
            }
        }
    }

    private static void collectProgramEquates(Map<String, Set<Long>> equates, Program program) {
        Iterator<Equate> it = program.getEquateTable().getEquates();
        while (it.hasNext()) {
            Equate eq = it.next();
            equates.computeIfAbsent(eq.getDisplayName(), n -> new HashSet()).add(eq.getValue());
        }
    }

    public static AssemblyNumericSymbols fromLanguage(Language language) {
        HashMap<String, Set<Address>> labels = new HashMap<String, Set<Address>>();
        AssemblyNumericSymbols.collectLanguageLabels(labels, language);
        return AssemblyNumericSymbols.forMaps(Map.of(), labels);
    }

    public static AssemblyNumericSymbols fromProgram(Program program) {
        HashMap<String, Set<Long>> equates = new HashMap<String, Set<Long>>();
        HashMap<String, Set<Address>> labels = new HashMap<String, Set<Address>>();
        AssemblyNumericSymbols.collectLanguageLabels(labels, program.getLanguage());
        AssemblyNumericSymbols.collectProgramLabels(labels, program);
        AssemblyNumericSymbols.collectProgramEquates(equates, program);
        return AssemblyNumericSymbols.forMaps(equates, labels);
    }

    public static AssemblyNumericSymbols forMaps(Map<String, Set<Long>> equates, Map<String, Set<Address>> labels) {
        return new AssemblyNumericSymbols(Map.copyOf(equates), Map.copyOf(labels), AssemblyNumericSymbols.groupBySpace(labels));
    }

    private static Map<AddressSpace, Map<String, Set<Address>>> groupBySpace(Map<String, Set<Address>> labels) {
        HashMap<AddressSpace, Map> result = new HashMap<AddressSpace, Map>();
        for (Map.Entry<String, Set<Address>> entry : labels.entrySet()) {
            for (Address addr : entry.getValue()) {
                result.computeIfAbsent(addr.getAddressSpace(), as -> new HashMap()).computeIfAbsent(entry.getKey(), k -> new TreeSet()).add(addr);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private AssemblyNumericSymbols(Map<String, Set<Long>> equates, Map<String, Set<Address>> labels, Map<AddressSpace, Map<String, Set<Address>>> labelsBySpace) {
        this.equates = equates;
        this.labels = labels;
        this.labelsBySpace = labelsBySpace;
        this.all.addAll(equates.keySet());
        this.all.addAll(labels.keySet());
    }

    public Set<Long> chooseAll(String name) {
        TreeSet<Long> result = new TreeSet<Long>();
        result.addAll(this.equates.getOrDefault(name, Set.of()));
        for (Address address : this.labels.getOrDefault(name, Set.of())) {
            result.add(address.getAddressableWordOffset());
        }
        return result;
    }

    public Set<Long> chooseBySpace(String name, AddressSpace space) {
        return this.labelsBySpace.getOrDefault(space, Map.of()).getOrDefault(name, Set.of()).stream().map(a -> a.getAddressableWordOffset()).collect(Collectors.toSet());
    }

    public Set<Long> choose(String name, AddressSpace space) {
        if (space == null || space.isConstantSpace()) {
            return this.chooseAll(name);
        }
        return this.chooseBySpace(name, space);
    }

    private Collection<String> suggestFrom(String got, Collection<String> keys, int max, boolean sorted) {
        HashSet<String> result = new HashSet<String>();
        int count = 0;
        for (String label : keys) {
            if (count >= max) break;
            if (label.startsWith(got)) {
                result.add(label);
                ++count;
                continue;
            }
            if (!sorted) continue;
            break;
        }
        return result;
    }

    public Collection<String> suggestAny(String got, int max) {
        return this.suggestFrom(got, this.all.tailSet(got), max, true);
    }

    public Collection<String> suggestBySpace(String got, AddressSpace space, int max) {
        Map<String, Set<Address>> forSpace = this.labelsBySpace.get(space);
        if (forSpace == null) {
            return Set.of();
        }
        return this.suggestFrom(got, forSpace.keySet(), max, false);
    }

    public Collection<String> getSuggestions(String got, AddressSpace space, int max) {
        if (space == null || space.isConstantSpace()) {
            return this.suggestAny(got, max);
        }
        return this.suggestBySpace(got, space, max);
    }
}

