/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.flatapi;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.service.emulation.ProgramEmulationUtils;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.script.GhidraState;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStateEditingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.MathUtilities;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public interface FlatDebuggerAPI {
    default public <T> T waitOn(CompletableFuture<T> cf) throws InterruptedException, ExecutionException, TimeoutException {
        return cf.get(1L, TimeUnit.MINUTES);
    }

    public GhidraState getState();

    default public <T> T requireService(Class<T> cls) {
        Object service = this.getState().getTool().getService(cls);
        if (service == null) {
            throw new IllegalStateException("Tool does not have service " + cls + "! This script should be run from the Debugger tool");
        }
        return (T)service;
    }

    default public DebuggerTraceManagerService getTraceManager() {
        return this.requireService(DebuggerTraceManagerService.class);
    }

    default public void openTrace(Trace trace) {
        this.getTraceManager().openTrace(trace);
    }

    default public void closeTrace(Trace trace) {
        this.getTraceManager().closeTrace(trace);
    }

    default public DebuggerCoordinates getCurrentDebuggerCoordinates() {
        return this.getTraceManager().getCurrent();
    }

    default public Trace getCurrentTrace() {
        return this.getTraceManager().getCurrentTrace();
    }

    default public Trace requireCurrentTrace() {
        Trace trace = this.getCurrentTrace();
        if (trace == null) {
            throw new IllegalStateException("There is no current trace");
        }
        return trace;
    }

    default public Trace requireTrace(Trace trace) {
        if (trace == null) {
            throw new IllegalStateException("There is no trace");
        }
        return trace;
    }

    default public TracePlatform getCurrentPlatform() {
        return this.getTraceManager().getCurrentPlatform();
    }

    default public TracePlatform requireCurrentPlatform() {
        TracePlatform platform = this.getCurrentPlatform();
        if (platform == null) {
            throw new IllegalStateException("There is no current trace");
        }
        return platform;
    }

    default public TracePlatform requirePlatform(TracePlatform platform) {
        if (platform == null) {
            throw new IllegalStateException("There is no platform");
        }
        return platform;
    }

    default public TraceThread getCurrentThread() {
        return this.getTraceManager().getCurrentThread();
    }

    default public TraceThread requireCurrentThread() {
        TraceThread thread = this.getCurrentThread();
        if (thread == null) {
            throw new IllegalStateException("There is no current thread");
        }
        return thread;
    }

    default public TraceThread requireThread(TraceThread thread) {
        if (thread == null) {
            throw new IllegalStateException("There is no thread");
        }
        return thread;
    }

    default public TraceProgramView getCurrentView() {
        return this.getTraceManager().getCurrentView();
    }

    default public TraceProgramView requireCurrentView() {
        TraceProgramView view = this.getCurrentView();
        if (view == null) {
            throw new IllegalStateException("There is no current trace view");
        }
        return view;
    }

    default public int getCurrentFrame() {
        return this.getTraceManager().getCurrentFrame();
    }

    default public long getCurrentSnap() {
        return this.getTraceManager().getCurrentSnap();
    }

    default public TraceSchedule getCurrentEmulationSchedule() {
        return this.getTraceManager().getCurrent().getTime();
    }

    default public void activateTrace(Trace trace) {
        DebuggerTraceManagerService manager = this.getTraceManager();
        if (trace == null) {
            manager.activateTrace(null);
            return;
        }
        if (!manager.getOpenTraces().contains(trace)) {
            manager.openTrace(trace);
        }
        manager.activateTrace(trace);
    }

    default public void activateThread(TraceThread thread) {
        DebuggerTraceManagerService manager = this.getTraceManager();
        if (thread == null) {
            manager.activateThread(null);
            return;
        }
        Trace trace = thread.getTrace();
        if (!manager.getOpenTraces().contains(trace)) {
            manager.openTrace(trace);
        }
        manager.activateThread(thread);
    }

    default public void activateFrame(int frame) {
        this.getTraceManager().activateFrame(frame);
    }

    default public void activateSnap(long snap) {
        this.getTraceManager().activateSnap(snap);
    }

    default public DebuggerListingService getDebuggerListing() {
        return this.requireService(DebuggerListingService.class);
    }

    default public ProgramLocation getCurrentDebuggerProgramLocation() {
        return this.getDebuggerListing().getCurrentLocation();
    }

    default public Address getCurrentDebuggerAddress() {
        ProgramLocation loc = this.getCurrentDebuggerProgramLocation();
        return loc == null ? null : loc.getAddress();
    }

    default public boolean goToDynamic(ProgramLocation location) {
        return this.getDebuggerListing().goTo(location, true);
    }

    default public boolean goToDynamic(Address address) {
        return this.goToDynamic(this.dynamicLocation(address));
    }

    default public boolean goToDynamic(String addrString) {
        return this.goToDynamic(this.dynamicLocation(addrString));
    }

    default public DebuggerStaticMappingService getMappingService() {
        return this.requireService(DebuggerStaticMappingService.class);
    }

    default public Program getCurrentProgram() {
        return this.getState().getCurrentProgram();
    }

    default public Program requireCurrentProgram() {
        Program program = this.getCurrentProgram();
        if (program == null) {
            throw new IllegalStateException("There is no current program");
        }
        return program;
    }

    default public ProgramLocation translateStaticToDynamic(ProgramLocation location) {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        Trace trace = this.requireCurrentTrace();
        TraceLocation tloc = this.getMappingService().getOpenMappedLocation(trace, location, current.getSnap());
        return tloc == null ? null : new ProgramLocation((Program)current.getView(), tloc.getAddress());
    }

    default public Address translateStaticToDynamic(Address address) {
        Program program = this.requireCurrentProgram();
        ProgramLocation dloc = this.translateStaticToDynamic(new ProgramLocation(program, address));
        return dloc == null ? null : dloc.getByteAddress();
    }

    default public ProgramLocation translateDynamicToStatic(ProgramLocation location) {
        return this.getMappingService().getStaticLocationFromDynamic(location);
    }

    default public Address translateDynamicToStatic(Address address) {
        Program program = this.requireCurrentProgram();
        TraceProgramView view = this.requireCurrentView();
        ProgramLocation sloc = this.translateDynamicToStatic(new ProgramLocation((Program)view, address));
        return sloc == null ? null : (sloc.getProgram() != program ? null : sloc.getByteAddress());
    }

    default public DebuggerEmulationService getEmulationService() {
        return this.requireService(DebuggerEmulationService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Trace emulateLaunch(Program program, Address address) throws IOException {
        Trace trace = null;
        try {
            trace = ProgramEmulationUtils.launchEmulationTrace(program, address, this);
            DebuggerTraceManagerService traceManager = this.getTraceManager();
            traceManager.openTrace(trace);
            traceManager.activateTrace(trace);
            Swing.allowSwingToProcessEvents();
        }
        finally {
            if (trace != null) {
                trace.release((Object)this);
            }
        }
        return trace;
    }

    default public Trace emulateLaunch(Address address) throws IOException {
        return this.emulateLaunch(this.requireCurrentProgram(), address);
    }

    default public boolean emulate(TracePlatform platform, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        this.getEmulationService().emulate(platform, time, monitor);
        this.getTraceManager().activateTime(time);
        return true;
    }

    default public boolean emulate(Trace trace, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        return this.emulate(trace.getPlatformManager().getHostPlatform(), time, monitor);
    }

    default public boolean emulate(TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        return this.emulate(this.requireCurrentPlatform(), time, monitor);
    }

    default public boolean stepEmuInstruction(long count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0L ? time.steppedBackward(platform.getTrace(), -count) : time.steppedForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean stepEmuPcodeOp(int count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0 ? time.steppedPcodeBackward(-count) : time.steppedPcodeForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean skipEmuInstruction(long count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0L ? time.steppedBackward(platform.getTrace(), -count) : time.skippedForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean skipEmuPcodeOp(int count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0 ? time.steppedPcodeBackward(-count) : time.skippedPcodeForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean patchEmu(String sleigh, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule patched = time.patched(this.requireThread(thread), platform.getLanguage(), sleigh);
        return this.emulate(platform, patched, monitor);
    }

    default public AddressRange safeRange(Address start, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        long maxLength = start.getAddressSpace().getMaxAddress().subtract(start);
        try {
            return new AddressRangeImpl(start, (long)MathUtilities.unsignedMin((int)length, (long)maxLength));
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public void refreshMemoryIfLive(Trace trace, long snap, Address start, int length, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        TraceRecorder recorder = this.getModelService().getRecorder(trace);
        if (recorder == null) {
            return;
        }
        if (recorder.getSnap() != snap) {
            return;
        }
        this.waitOn(recorder.readMemoryBlocks((AddressSetView)new AddressSet(this.safeRange(start, length)), monitor));
        this.waitOn(recorder.getTarget().getModel().flushEvents());
        this.waitOn(recorder.flushTransactions());
        trace.flushEvents();
    }

    default public int readMemory(Trace trace, long snap, Address start, byte[] buffer, TaskMonitor monitor) {
        try {
            this.refreshMemoryIfLive(trace, snap, start, buffer.length, monitor);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return 0;
        }
        return trace.getMemoryManager().getViewBytes(snap, start, ByteBuffer.wrap(buffer));
    }

    default public byte[] readMemory(Trace trace, long snap, Address start, int length, TaskMonitor monitor) {
        byte[] arr = new byte[length];
        int actual = this.readMemory(trace, snap, start, arr, monitor);
        if (actual == length) {
            return arr;
        }
        return Arrays.copyOf(arr, actual);
    }

    default public int readMemory(Address start, byte[] buffer, TaskMonitor monitor) {
        TraceProgramView view = this.requireCurrentView();
        return this.readMemory(view.getTrace(), view.getSnap(), start, buffer, monitor);
    }

    default public byte[] readMemory(Address start, int length, TaskMonitor monitor) {
        TraceProgramView view = this.requireCurrentView();
        return this.readMemory(view.getTrace(), view.getSnap(), start, length, monitor);
    }

    default public Address searchMemory(Trace trace, long snap, AddressRange range, ByteBuffer data, ByteBuffer mask, boolean forward, TaskMonitor monitor) {
        return trace.getMemoryManager().findBytes(snap, range, data, mask, forward, monitor);
    }

    default public Address searchMemory(Trace trace, long snap, AddressRange range, byte[] data, byte[] mask, boolean forward, TaskMonitor monitor) {
        return this.searchMemory(trace, snap, range, ByteBuffer.wrap(data), mask == null ? null : ByteBuffer.wrap(mask), forward, monitor);
    }

    default public void refreshRegistersIfLive(TracePlatform platform, TraceThread thread, int frame, long snap, Collection<Register> registers) throws InterruptedException, ExecutionException, TimeoutException {
        Trace trace = thread.getTrace();
        TraceRecorder recorder = this.getModelService().getRecorder(trace);
        if (recorder == null) {
            return;
        }
        if (recorder.getSnap() != snap) {
            return;
        }
        Set<Register> asSet = registers instanceof Set ? (Set<Register>)registers : Set.copyOf(registers);
        this.waitOn(recorder.captureThreadRegisters(platform, thread, frame, asSet));
        this.waitOn(recorder.getTarget().getModel().flushEvents());
        this.waitOn(recorder.flushTransactions());
        trace.flushEvents();
    }

    default public List<RegisterValue> readRegisters(TracePlatform platform, TraceThread thread, int frame, long snap, Collection<Register> registers) {
        try {
            this.refreshRegistersIfLive(platform, thread, frame, snap, registers);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        TraceMemorySpace regs = thread.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, frame, false);
        if (regs == null) {
            return registers.stream().map(RegisterValue::new).collect(Collectors.toList());
        }
        return registers.stream().map(r -> regs.getValue(snap, r)).collect(Collectors.toList());
    }

    default public RegisterValue readRegister(TracePlatform platform, TraceThread thread, int frame, long snap, Register register) {
        List<RegisterValue> result = this.readRegisters(platform, thread, frame, snap, Set.of(register));
        return result == null ? null : result.get(0);
    }

    default public List<RegisterValue> readRegisters(Collection<Register> registers) {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        return this.readRegisters(this.requireCurrentPlatform(), this.requireThread(current.getThread()), current.getFrame(), current.getSnap(), registers);
    }

    default public List<Register> validateRegisterNames(Language language, Collection<String> names) {
        ArrayList<String> invalid = new ArrayList<String>();
        ArrayList<Register> result = new ArrayList<Register>();
        for (String n : names) {
            Register register = language.getRegister(n);
            if (register != null) {
                result.add(register);
                continue;
            }
            invalid.add(n);
        }
        if (!invalid.isEmpty()) {
            throw new IllegalArgumentException("One or more invalid register names: " + invalid);
        }
        return result;
    }

    default public Register validateRegisterName(Language language, String name) {
        Register register = language.getRegister(name);
        if (register == null) {
            throw new IllegalArgumentException("Invalid register name: " + name);
        }
        return register;
    }

    default public List<RegisterValue> readRegistersNamed(Collection<String> names) {
        return this.readRegisters(this.validateRegisterNames(this.requireCurrentTrace().getBaseLanguage(), names));
    }

    default public RegisterValue readRegister(TracePlatform platform, Register register) {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        if (platform.getTrace() != current.getTrace()) {
            throw new IllegalArgumentException("Given platform is not from the current trace");
        }
        Language language = platform.getLanguage();
        if (!register.equals((Object)language.getRegister(register.getName()))) {
            throw new IllegalArgumentException("Register " + register + " is not in language " + language);
        }
        return this.readRegister(platform, this.requireThread(current.getThread()), current.getFrame(), current.getSnap(), register);
    }

    default public RegisterValue readRegister(Register register) {
        return this.readRegister(this.requireCurrentPlatform(), register);
    }

    default public RegisterValue readRegister(String name) {
        TracePlatform platform = this.requireCurrentPlatform();
        Register register = this.validateRegisterName(platform.getLanguage(), name);
        return this.readRegister(platform, register);
    }

    default public Address getProgramCounter(DebuggerCoordinates coordinates) {
        TracePlatform platform = this.requirePlatform(coordinates.getPlatform());
        Language language = platform.getLanguage();
        RegisterValue value = this.readRegister(platform, this.requireThread(coordinates.getThread()), coordinates.getFrame(), coordinates.getSnap(), language.getProgramCounter());
        if (!value.hasValue()) {
            return null;
        }
        return language.getDefaultSpace().getAddress(value.getUnsignedValue().longValue());
    }

    default public Address getProgramCounter() {
        return this.getProgramCounter(this.getCurrentDebuggerCoordinates());
    }

    default public Address getStackPointer(DebuggerCoordinates coordinates) {
        TracePlatform platform = this.requirePlatform(coordinates.getPlatform());
        CompilerSpec cSpec = platform.getCompilerSpec();
        RegisterValue value = this.readRegister(platform, this.requireThread(coordinates.getThread()), coordinates.getFrame(), coordinates.getSnap(), cSpec.getStackPointer());
        if (!value.hasValue()) {
            return null;
        }
        return cSpec.getStackBaseSpace().getAddress(value.getUnsignedValue().longValue());
    }

    default public Address getStackPointer() {
        return this.getStackPointer(this.getCurrentDebuggerCoordinates());
    }

    default public DebuggerStateEditingService getEditingService() {
        return this.requireService(DebuggerStateEditingService.class);
    }

    default public void setEditingMode(Trace trace, DebuggerStateEditingService.StateEditingMode mode) {
        this.requireService(DebuggerStateEditingService.class).setCurrentMode(trace, mode);
    }

    default public void setEditingMode(DebuggerStateEditingService.StateEditingMode mode) {
        this.setEditingMode(this.requireCurrentTrace(), mode);
    }

    default public DebuggerStateEditingService.StateEditor createStateEditor(DebuggerCoordinates coordinates) {
        return this.getEditingService().createStateEditor(coordinates);
    }

    default public DebuggerStateEditingService.StateEditor createStateEditor(Trace trace, long snap) {
        return this.getEditingService().createStateEditor(this.getTraceManager().resolveTrace(trace).snap(snap));
    }

    default public DebuggerStateEditingService.StateEditor createStateEditor(TraceThread thread, int frame, long snap) {
        return this.getEditingService().createStateEditor(this.getTraceManager().resolveThread(thread).snap(snap).frame(frame));
    }

    default public DebuggerStateEditingService.StateEditor createStateEditor() {
        return this.createStateEditor(this.getCurrentDebuggerCoordinates());
    }

    default public boolean writeMemory(DebuggerStateEditingService.StateEditor editor, Address start, byte[] data) {
        if (!editor.isVariableEditable(start, data.length)) {
            return false;
        }
        try {
            this.waitOn(editor.setVariable(start, data));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean writeMemory(Trace trace, long snap, Address start, byte[] data) {
        return this.writeMemory(this.createStateEditor(trace, snap), start, data);
    }

    default public boolean writeMemory(Address start, byte[] data) {
        return this.writeMemory(this.createStateEditor(), start, data);
    }

    default public boolean writeRegister(DebuggerStateEditingService.StateEditor editor, RegisterValue rv) {
        if (!editor.isRegisterEditable(rv.getRegister())) {
            return false;
        }
        try {
            this.waitOn(editor.setRegister(rv));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean writeRegister(TraceThread thread, int frame, long snap, RegisterValue rv) {
        return this.writeRegister(this.createStateEditor(thread, frame, snap), rv);
    }

    default public boolean writeRegister(TraceThread thread, int frame, long snap, String name, BigInteger value) {
        return this.writeRegister(thread, frame, snap, new RegisterValue(this.validateRegisterName(thread.getTrace().getBaseLanguage(), name), value));
    }

    default public boolean writeRegister(RegisterValue rv) {
        return this.writeRegister(this.createStateEditor(), rv);
    }

    default public boolean writeRegister(String name, BigInteger value) {
        return this.writeRegister(new RegisterValue(this.validateRegisterName(this.requireCurrentTrace().getBaseLanguage(), name), value));
    }

    default public TraceRecorder getCurrentRecorder() {
        return this.getTraceManager().getCurrent().getRecorder();
    }

    default public DebuggerModelService getModelService() {
        return this.requireService(DebuggerModelService.class);
    }

    default public List<DebuggerProgramLaunchOffer> getLaunchOffers(Program program) {
        return this.getModelService().getProgramLaunchOffers(program).collect(Collectors.toList());
    }

    default public List<DebuggerProgramLaunchOffer> getLaunchOffers() {
        return this.getLaunchOffers(this.requireCurrentProgram());
    }

    default public DebuggerProgramLaunchOffer requireLaunchOffer(Program program) {
        Optional<DebuggerProgramLaunchOffer> offer = this.getModelService().getProgramLaunchOffers(program).findFirst();
        if (offer.isEmpty()) {
            throw new NoSuchElementException("No offers to launch " + program);
        }
        return offer.get();
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(DebuggerProgramLaunchOffer offer, final String commandLine, TaskMonitor monitor) {
        try {
            return this.waitOn(offer.launchProgram(monitor, false, new DebuggerProgramLaunchOffer.LaunchConfigurator(){

                @Override
                public Map<String, ?> configureLauncher(TargetLauncher launcher, Map<String, ?> arguments, DebuggerProgramLaunchOffer.RelPrompt relPrompt) {
                    HashMap adjusted = new HashMap(arguments);
                    adjusted.put("args", commandLine);
                    return adjusted;
                }
            }));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return DebuggerProgramLaunchOffer.LaunchResult.totalFailure(e);
        }
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(DebuggerProgramLaunchOffer offer, TaskMonitor monitor) {
        try {
            return this.waitOn(offer.launchProgram(monitor, false));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return DebuggerProgramLaunchOffer.LaunchResult.totalFailure(e);
        }
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(Program program, String commandLine, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireLaunchOffer(program), commandLine, monitor);
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(Program program, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireLaunchOffer(program), monitor);
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(String commandLine, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireCurrentProgram(), commandLine, monitor);
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireCurrentProgram(), monitor);
    }

    default public TargetObject getTarget(Trace trace) {
        TraceRecorder recorder = this.getModelService().getRecorder(trace);
        if (recorder == null) {
            return null;
        }
        return recorder.getTarget();
    }

    default public TargetThread getTargetThread(TraceThread thread) {
        TraceRecorder recorder = this.getModelService().getRecorder(thread.getTrace());
        if (recorder == null) {
            return null;
        }
        return recorder.getTargetThread(thread);
    }

    default public TargetObject getTargetFocus(Trace trace) {
        TraceRecorder recorder = this.getModelService().getRecorder(trace);
        if (recorder == null) {
            return null;
        }
        TargetObject focus = recorder.getFocus();
        return focus != null ? focus : recorder.getTarget();
    }

    default public <T extends TargetObject> T findInterface(TargetObject seed, Class<T> iface) {
        DebuggerObjectModel model = seed.getModel();
        List found = model.getRootSchema().searchForSuitable(iface, seed.getPath());
        if (found == null) {
            return null;
        }
        try {
            T value = this.waitOn(model.fetchModelValue(found));
            return (T)((TargetObject)value);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    default public <T extends TargetObject> T findInterface(TraceThread thread, Class<T> iface) {
        TargetThread targetThread = this.getTargetThread(thread);
        if (targetThread == null) {
            return null;
        }
        return this.findInterface((TargetObject)targetThread, iface);
    }

    default public <T extends TargetObject> T findInterface(Trace trace, Class<T> iface) {
        TargetObject focus = this.getTargetFocus(trace);
        if (focus == null) {
            return null;
        }
        return this.findInterface(focus, iface);
    }

    default public <T extends TargetObject> T findInterface(Class<T> iface) {
        T t;
        TraceThread thread = this.getCurrentThread();
        T t2 = t = thread == null ? null : (T)this.findInterface(thread, iface);
        if (t != null) {
            return t;
        }
        return this.findInterface(this.requireCurrentTrace(), iface);
    }

    default public boolean step(TargetSteppable steppable, TargetSteppable.TargetStepKind kind) {
        if (steppable == null) {
            return false;
        }
        try {
            this.waitOn(steppable.step(kind));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean step(TraceThread thread, TargetSteppable.TargetStepKind kind) {
        if (thread == null) {
            return false;
        }
        return this.step(this.findInterface(thread, TargetSteppable.class), kind);
    }

    default public boolean stepInto() {
        return this.step(this.findInterface(TargetSteppable.class), TargetSteppable.TargetStepKind.INTO);
    }

    default public boolean stepOver() {
        return this.step(this.findInterface(TargetSteppable.class), TargetSteppable.TargetStepKind.OVER);
    }

    default public boolean stepOut() {
        return this.step(this.findInterface(TargetSteppable.class), TargetSteppable.TargetStepKind.FINISH);
    }

    default public boolean resume(TargetResumable resumable) {
        if (resumable == null) {
            return false;
        }
        try {
            this.waitOn(resumable.resume());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean resume(TraceThread thread) {
        return this.resume(this.findInterface(thread, TargetResumable.class));
    }

    default public boolean resume(Trace trace) {
        return this.resume(this.findInterface(trace, TargetResumable.class));
    }

    default public boolean resume() {
        TargetResumable resumable;
        TraceThread thread = this.getCurrentThread();
        TargetResumable targetResumable = resumable = thread == null ? null : this.findInterface(thread, TargetResumable.class);
        if (resumable == null) {
            resumable = this.findInterface(this.requireCurrentTrace(), TargetResumable.class);
        }
        return this.resume(resumable);
    }

    default public boolean interrupt(TargetInterruptible interruptible) {
        if (interruptible == null) {
            return false;
        }
        try {
            this.waitOn(interruptible.interrupt());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean interrupt(TraceThread thread) {
        return this.interrupt(this.findInterface(thread, TargetInterruptible.class));
    }

    default public boolean interrupt(Trace trace) {
        return this.interrupt(this.findInterface(trace, TargetInterruptible.class));
    }

    default public boolean interrupt() {
        return this.interrupt(this.findInterface(TargetInterruptible.class));
    }

    default public boolean kill(TargetKillable killable) {
        if (killable == null) {
            return false;
        }
        try {
            this.waitOn(killable.kill());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean kill(TraceThread thread) {
        return this.kill(this.findInterface(thread, TargetKillable.class));
    }

    default public boolean kill(Trace trace) {
        return this.kill(this.findInterface(trace, TargetKillable.class));
    }

    default public boolean kill() {
        return this.kill(this.findInterface(TargetKillable.class));
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(TargetObject target) {
        if (!target.isValid()) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
        TargetExecutionStateful stateful = this.findInterface(target, TargetExecutionStateful.class);
        return stateful == null ? TargetExecutionStateful.TargetExecutionState.ALIVE : stateful.getExecutionState();
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(Trace trace) {
        TargetObject target = this.getTarget(trace);
        if (target == null) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
        return this.getExecutionState(target);
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(TraceThread thread) {
        TargetThread target = this.getTargetThread(thread);
        if (target == null) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
        return this.getExecutionState((TargetObject)target);
    }

    default public boolean isTargetAlive(Trace trace) {
        return this.getExecutionState(trace).isAlive();
    }

    default public boolean isTargetAlive() {
        return this.isTargetAlive(this.requireCurrentTrace());
    }

    default public boolean isThreadAlive(TraceThread thread) {
        return this.getExecutionState(thread).isAlive();
    }

    default public boolean isThreadAlive() {
        return this.isThreadAlive(this.requireThread(this.getCurrentThread()));
    }

    default public void waitForBreak(TargetObject target, long timeout, TimeUnit unit) throws TimeoutException {
        final TargetExecutionStateful stateful = this.findInterface(target, TargetExecutionStateful.class);
        if (stateful == null) {
            throw new IllegalArgumentException("Given target is not stateful");
        }
        var listener = new AnnotatedDebuggerAttributeListener(MethodHandles.lookup()){
            CompletableFuture<Void> future;
            {
                super(arg0);
                this.future = new CompletableFuture();
            }

            @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_state")
            private void stateChanged(TargetObject parent, TargetExecutionStateful.TargetExecutionState state) {
                if (parent == stateful && !state.isRunning()) {
                    this.future.complete(null);
                }
            }
        };
        target.getModel().addModelListener((DebuggerModelListener)listener);
        try {
            if (!stateful.getExecutionState().isRunning()) {
                return;
            }
            listener.future.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            target.getModel().removeModelListener((DebuggerModelListener)listener);
        }
    }

    default public void waitForBreak(Trace trace, long timeout, TimeUnit unit) throws TimeoutException {
        TargetObject target = this.getTarget(trace);
        if (target == null || !target.isValid()) {
            return;
        }
        this.waitForBreak(target, timeout, unit);
    }

    default public void waitForBreak(long timeout, TimeUnit unit) throws TimeoutException {
        this.waitForBreak(this.requireCurrentTrace(), timeout, unit);
    }

    default public String executeCapture(TargetInterpreter interpreter, String command) {
        if (interpreter == null) {
            return null;
        }
        try {
            return (String)this.waitOn(interpreter.executeCapture(command));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    default public String executeCapture(Trace trace, String command) {
        return this.executeCapture(this.findInterface(trace, TargetInterpreter.class), command);
    }

    default public String executeCapture(String command) {
        return this.executeCapture(this.requireCurrentTrace(), command);
    }

    default public boolean execute(TargetInterpreter interpreter, String command) {
        if (interpreter == null) {
            return false;
        }
        try {
            this.waitOn(interpreter.executeCapture(command));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean execute(Trace trace, String command) {
        return this.execute(this.findInterface(trace, TargetInterpreter.class), command);
    }

    default public boolean execute(String command) {
        return this.execute(this.requireCurrentTrace(), command);
    }

    default public DebuggerLogicalBreakpointService getBreakpointService() {
        return this.requireService(DebuggerLogicalBreakpointService.class);
    }

    default public ProgramLocation staticLocation(Program program, Address address) {
        if (program instanceof TraceProgramView) {
            throw new IllegalArgumentException("The given program is dynamic, i.e., a trace view");
        }
        return new ProgramLocation(program, address);
    }

    default public ProgramLocation staticLocation(Program program, String addrString) {
        return this.staticLocation(program, program.getAddressFactory().getAddress(addrString));
    }

    default public ProgramLocation staticLocation(Address address) {
        return this.staticLocation(this.requireCurrentProgram(), address);
    }

    default public ProgramLocation staticLocation(String addrString) {
        return this.staticLocation(this.requireCurrentProgram(), addrString);
    }

    default public ProgramLocation dynamicLocation(TraceProgramView view, Address address) {
        return new ProgramLocation((Program)view, address);
    }

    default public ProgramLocation dynamicLocation(TraceProgramView view, String addrString) {
        return new ProgramLocation((Program)view, view.getAddressFactory().getAddress(addrString));
    }

    default public ProgramLocation dynamicLocation(Address address) {
        return this.dynamicLocation(this.requireCurrentView(), address);
    }

    default public ProgramLocation dynamicLocation(String addrString) {
        return this.dynamicLocation(this.requireCurrentView(), addrString);
    }

    default public ProgramLocation dynamicLocation(Trace trace, Address address) {
        return this.dynamicLocation((TraceProgramView)trace.getProgramView(), address);
    }

    default public ProgramLocation dynamicLocation(Trace trace, String addrString) {
        return this.dynamicLocation((TraceProgramView)trace.getProgramView(), addrString);
    }

    default public ProgramLocation dynamicLocation(Trace trace, long snap, Address address) {
        return this.dynamicLocation(trace.getFixedProgramView(snap), address);
    }

    default public ProgramLocation dynamicLocation(Trace trace, long snap, String addrString) {
        return this.dynamicLocation(trace.getFixedProgramView(snap), addrString);
    }

    default public Set<LogicalBreakpoint> getAllBreakpoints() {
        return this.getBreakpointService().getAllBreakpoints();
    }

    default public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Program program) {
        return this.getBreakpointService().getBreakpoints(program);
    }

    default public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Trace trace) {
        return this.getBreakpointService().getBreakpoints(trace);
    }

    default public Set<LogicalBreakpoint> getBreakpointsAt(ProgramLocation location) {
        return this.getBreakpointService().getBreakpointsAt(location);
    }

    default public Set<LogicalBreakpoint> getBreakpointsNamed(String name) {
        return this.getBreakpointService().getAllBreakpoints().stream().filter(bp -> name.equals(bp.getName())).collect(Collectors.toSet());
    }

    default public ExpectingBreakpointChanges expectBreakpointChanges() {
        return new ExpectingBreakpointChanges(this, this.getBreakpointService());
    }

    default public Set<LogicalBreakpoint> breakpointsToggle(ProgramLocation location) {
        Set<LogicalBreakpoint> set;
        block8: {
            DebuggerLogicalBreakpointService service = this.getBreakpointService();
            ExpectingBreakpointChanges exp = this.expectBreakpointChanges();
            try {
                set = this.waitOn(service.toggleBreakpointsAt(location, () -> CompletableFuture.completedFuture(Set.of())));
                if (exp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (exp != null) {
                        try {
                            exp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    return null;
                }
            }
            exp.close();
        }
        return set;
    }

    default public Set<LogicalBreakpoint> breakpointSet(ProgramLocation location, long length, TraceBreakpointKind.TraceBreakpointKindSet kinds, String name) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.placeBreakpointAt(location, length, (Collection<TraceBreakpointKind>)kinds, name));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        return service.getBreakpointsAt(location).stream().filter(b -> Objects.equals(name, b.getName())).collect(Collectors.toSet());
    }

    default public Set<LogicalBreakpoint> breakpointSetSoftwareExecute(ProgramLocation location, String name) {
        return this.breakpointSet(location, 1L, TraceBreakpointKind.TraceBreakpointKindSet.SW_EXECUTE, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetHardwareExecute(ProgramLocation location, String name) {
        return this.breakpointSet(location, 1L, TraceBreakpointKind.TraceBreakpointKindSet.HW_EXECUTE, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetRead(ProgramLocation location, int length, String name) {
        return this.breakpointSet(location, length, TraceBreakpointKind.TraceBreakpointKindSet.READ, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetWrite(ProgramLocation location, int length, String name) {
        return this.breakpointSet(location, length, TraceBreakpointKind.TraceBreakpointKindSet.WRITE, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetAccess(ProgramLocation location, int length, String name) {
        return this.breakpointSet(location, length, TraceBreakpointKind.TraceBreakpointKindSet.ACCESS, name);
    }

    default public Trace getTrace(ProgramLocation location) {
        Program program = location.getProgram();
        if (program instanceof TraceProgramView) {
            return ((TraceProgramView)program).getTrace();
        }
        return null;
    }

    default public Set<LogicalBreakpoint> breakpointsEnable(ProgramLocation location) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        Set<LogicalBreakpoint> col = service.getBreakpointsAt(location);
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.enableAll(col, this.getTrace(location)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        return col;
    }

    default public Set<LogicalBreakpoint> breakpointsDisable(ProgramLocation location) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        Set<LogicalBreakpoint> col = service.getBreakpointsAt(location);
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.disableAll(col, this.getTrace(location)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        return col;
    }

    default public boolean breakpointsClear(ProgramLocation location) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        Set<LogicalBreakpoint> col = service.getBreakpointsAt(location);
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.deleteAll(col, this.getTrace(location)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public Object getModelValue(DebuggerObjectModel model, String path) {
        try {
            return this.waitOn(model.fetchModelValue(PathUtils.parse((String)path)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    default public Object getModelValue(String path) {
        TraceRecorder recorder = this.getModelService().getRecorder(this.getCurrentTrace());
        if (recorder == null) {
            return null;
        }
        return this.getModelValue(recorder.getTarget().getModel(), path);
    }

    default public Set<TargetObject> refreshObjectChildren(TargetObject object) {
        try {
            this.waitOn(object.invalidateCaches());
            this.waitOn(object.resync());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        LinkedHashSet<TargetObject> result = new LinkedHashSet<TargetObject>();
        result.addAll(object.getCachedElements().values());
        for (Object v : object.getCachedAttributes().values()) {
            if (!(v instanceof TargetObject)) continue;
            result.add((TargetObject)v);
        }
        return result;
    }

    default public boolean refreshSubtree(TargetObject object) {
        var util = new Object(){
            Set<TargetObject> visited = new HashSet<TargetObject>();

            boolean visit(TargetObject object) {
                if (!this.visited.add(object)) {
                    return true;
                }
                for (TargetObject child : FlatDebuggerAPI.this.refreshObjectChildren(object)) {
                    if (this.visit(child)) continue;
                    return false;
                }
                return true;
            }
        };
        return util.visit(object);
    }

    default public boolean flushAsyncPipelines(Trace trace) {
        try {
            TraceRecorder recorder = this.getModelService().getRecorder(trace);
            if (recorder != null) {
                this.waitOn(recorder.getTarget().getModel().flushEvents());
                this.waitOn(recorder.flushTransactions());
            }
            trace.flushEvents();
            this.waitOn(this.getMappingService().changesSettled());
            this.waitOn(this.getBreakpointService().changesSettled());
            Swing.allowSwingToProcessEvents();
            return true;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
    }

    public static class ExpectingBreakpointChanges
    implements AutoCloseable {
        private final FlatDebuggerAPI flat;
        private final CompletableFuture<Void> changesSettled;

        public ExpectingBreakpointChanges(FlatDebuggerAPI flat, DebuggerLogicalBreakpointService service) {
            this.flat = flat;
            this.changesSettled = service.changesSettled();
        }

        @Override
        public void close() throws InterruptedException, ExecutionException, TimeoutException {
            Swing.allowSwingToProcessEvents();
            this.flat.waitOn(this.changesSettled);
        }
    }
}

