/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.editing.DebuggerStateEditingServicePlugin;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

@ServiceInfo(defaultProvider={DebuggerStateEditingServicePlugin.class}, description="Centralized service for modifying machine states")
public interface DebuggerStateEditingService {
    public StateEditingMode getCurrentMode(Trace var1);

    public void setCurrentMode(Trace var1, StateEditingMode var2);

    public void addModeChangeListener(StateEditingModeChangeListener var1);

    public void removeModeChangeListener(StateEditingModeChangeListener var1);

    public StateEditor createStateEditor(DebuggerCoordinates var1);

    public StateEditor createStateEditor(Trace var1);

    public StateEditingMemoryHandler createStateEditor(TraceProgramView var1);

    public static interface StateEditingModeChangeListener {
        public void modeChanged(Trace var1, StateEditingMode var2);
    }

    public static interface StateEditingMemoryHandler
    extends StateEditor,
    LiveMemoryHandler {
    }

    public static interface StateEditor {
        public DebuggerStateEditingService getService();

        public DebuggerCoordinates getCoordinates();

        public boolean isVariableEditable(Address var1, int var2);

        default public boolean isRegisterEditable(Register register) {
            return this.isVariableEditable(register.getAddress(), register.getNumBytes());
        }

        public CompletableFuture<Void> setVariable(Address var1, byte[] var2);

        default public CompletableFuture<Void> setRegister(RegisterValue value) {
            Register register = value.getRegister();
            byte[] bytes = Utils.bigIntegerToBytes((BigInteger)value.getUnsignedValue(), (int)register.getNumBytes(), (boolean)register.isBigEndian());
            return this.setVariable(register.getAddress(), bytes);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StateEditingMode {
        READ_ONLY("Read Only", DebuggerResources.ICON_EDIT_MODE_READ_ONLY){

            @Override
            public boolean canEdit(DebuggerCoordinates coordinates) {
                return false;
            }
        }
        ,
        WRITE_TARGET("Write Target", DebuggerResources.ICON_EDIT_MODE_WRITE_TARGET){

            @Override
            public boolean canEdit(DebuggerCoordinates coordinates) {
                return coordinates.isAliveAndPresent();
            }
        }
        ,
        WRITE_TRACE("Write Trace", DebuggerResources.ICON_EDIT_MODE_WRITE_TRACE){

            @Override
            public boolean canEdit(DebuggerCoordinates coordinates) {
                return coordinates.getTrace() != null;
            }
        }
        ,
        WRITE_EMULATOR("Write Emulator", DebuggerResources.ICON_EDIT_MODE_WRITE_EMULATOR){

            @Override
            public boolean canEdit(DebuggerCoordinates coordinates) {
                return coordinates.getTrace() != null;
            }
        };

        public final String name;
        public final Icon icon;

        private StateEditingMode(String name, Icon icon) {
            this.name = name;
            this.icon = icon;
        }

        public abstract boolean canEdit(DebuggerCoordinates var1);
    }
}

