/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapEntry;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapProposal;
import ghidra.app.services.SectionMapProposal;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import java.util.Map;

public class DefaultSectionMapProposal
extends AbstractMapProposal<TraceSection, MemoryBlock, SectionMapProposal.SectionMapEntry>
implements SectionMapProposal {
    protected final TraceModule module;
    protected final SectionMatcherMap matchers = new SectionMatcherMap();

    protected DefaultSectionMapProposal(TraceModule module, Program program) {
        super(module.getTrace(), program);
        this.module = module;
        this.processModule();
        this.processProgram();
    }

    protected DefaultSectionMapProposal(TraceSection section, Program program, MemoryBlock block) {
        super(section.getTrace(), program);
        this.module = section.getModule();
        this.matchers.processFromObject(section);
        this.matchers.processToObject(block);
    }

    @Override
    public TraceModule getModule() {
        return this.module;
    }

    private void processModule() {
        for (TraceSection section : this.module.getSections()) {
            this.matchers.processFromObject(section);
        }
    }

    private void processProgram() {
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            this.matchers.processToObject(block);
        }
    }

    @Override
    public double computeScore() {
        return this.matchers.averageScore();
    }

    @Override
    public Map<TraceSection, SectionMapProposal.SectionMapEntry> computeMap() {
        return this.matchers.computeMap(m -> new DefaultSectionMapEntry((TraceSection)m.fromObject, this.program, (MemoryBlock)m.toObject));
    }

    @Override
    public MemoryBlock getToObject(TraceSection from) {
        return (MemoryBlock)this.matchers.getToObject(from);
    }

    protected static class SectionMatcherMap
    extends AbstractMapProposal.MatcherMap<String, TraceSection, MemoryBlock, SectionMatcher> {
        protected SectionMatcherMap() {
        }

        @Override
        protected SectionMatcher newMatcher(TraceSection section, MemoryBlock block) {
            return new SectionMatcher(section, block);
        }

        @Override
        protected String getFromJoinKey(TraceSection section) {
            return section.getName();
        }

        @Override
        protected String getToJoinKey(MemoryBlock block) {
            return block.getName();
        }
    }

    public static class DefaultSectionMapEntry
    extends AbstractMapEntry<TraceSection, MemoryBlock>
    implements SectionMapProposal.SectionMapEntry {
        protected DefaultSectionMapEntry(TraceSection section, Program program, MemoryBlock block) {
            super(section.getTrace(), section, program, block);
        }

        @Override
        public TraceModule getModule() {
            return ((TraceSection)this.getFromObject()).getModule();
        }

        @Override
        public TraceSection getSection() {
            return (TraceSection)this.getFromObject();
        }

        @Override
        public Range<Long> getFromLifespan() {
            return this.getModule().getLifespan();
        }

        @Override
        public AddressRange getFromRange() {
            return this.getSection().getRange();
        }

        @Override
        public MemoryBlock getBlock() {
            return (MemoryBlock)this.getToObject();
        }

        @Override
        public AddressRange getToRange() {
            return new AddressRangeImpl(this.getBlock().getStart(), this.getBlock().getEnd());
        }

        @Override
        public void setBlock(Program program, MemoryBlock block) {
            this.setToObject(program, block);
        }
    }

    protected static class SectionMatcher
    extends AbstractMapProposal.Matcher<TraceSection, MemoryBlock> {
        public SectionMatcher(TraceSection section, MemoryBlock block) {
            super(section, block);
        }

        @Override
        protected AddressRange getFromRange() {
            return this.fromObject == null ? null : ((TraceSection)this.fromObject).getRange();
        }

        @Override
        protected AddressRange getToRange() {
            return this.toObject == null ? null : new AddressRangeImpl(((MemoryBlock)this.toObject).getStart(), ((MemoryBlock)this.toObject).getEnd());
        }
    }
}

