/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapEntry;
import ghidra.app.plugin.core.debug.service.modules.AbstractMapProposal;
import ghidra.app.services.RegionMapProposal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegion;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultRegionMapProposal
extends AbstractMapProposal<TraceMemoryRegion, MemoryBlock, RegionMapProposal.RegionMapEntry>
implements RegionMapProposal {
    protected final List<TraceMemoryRegion> regions;
    protected final Address fromBase;
    protected final Address toBase;
    protected final RegionMatcherMap matchers = new RegionMatcherMap();

    protected static Trace getTrace(Collection<? extends TraceMemoryRegion> regions) {
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        return regions.iterator().next().getTrace();
    }

    protected DefaultRegionMapProposal(Collection<? extends TraceMemoryRegion> regions, Program program) {
        super(DefaultRegionMapProposal.getTrace(regions), program);
        this.regions = Collections.unmodifiableList(regions.stream().sorted(Comparator.comparing(r -> r.getMinAddress())).collect(Collectors.toList()));
        this.fromBase = this.computeFromBase();
        this.toBase = program.getImageBase();
        this.processRegions();
        this.processProgram();
    }

    protected DefaultRegionMapProposal(TraceMemoryRegion region, Program program, MemoryBlock block) {
        super(region.getTrace(), program);
        this.regions = List.of(region);
        this.fromBase = region.getMinAddress();
        this.toBase = program.getImageBase();
        this.processRegions();
        this.matchers.processToObject(block);
    }

    protected Address computeFromBase() {
        if (this.regions.isEmpty()) {
            return null;
        }
        return this.regions.get(0).getMinAddress();
    }

    private void processRegions() {
        for (TraceMemoryRegion region : this.regions) {
            this.matchers.processFromObject(region);
        }
    }

    private void processProgram() {
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            this.matchers.processToObject(block);
        }
    }

    @Override
    public double computeScore() {
        return this.matchers.averageScore();
    }

    @Override
    public Map<TraceMemoryRegion, RegionMapProposal.RegionMapEntry> computeMap() {
        return this.matchers.computeMap(m -> new DefaultRegionMapEntry((TraceMemoryRegion)m.fromObject, this.program, (MemoryBlock)m.toObject));
    }

    @Override
    public MemoryBlock getToObject(TraceMemoryRegion from) {
        return (MemoryBlock)this.matchers.getToObject(from);
    }

    protected class RegionMatcherMap
    extends AbstractMapProposal.MatcherMap<Void, TraceMemoryRegion, MemoryBlock, RegionMatcher> {
        protected RegionMatcherMap() {
        }

        @Override
        protected RegionMatcher newMatcher(TraceMemoryRegion region, MemoryBlock block) {
            return new RegionMatcher(region, block);
        }

        @Override
        protected Void getFromJoinKey(TraceMemoryRegion region) {
            return null;
        }

        @Override
        protected Void getToJoinKey(MemoryBlock block) {
            return null;
        }
    }

    public static class DefaultRegionMapEntry
    extends AbstractMapEntry<TraceMemoryRegion, MemoryBlock>
    implements RegionMapProposal.RegionMapEntry {
        public DefaultRegionMapEntry(TraceMemoryRegion region, Program program, MemoryBlock block) {
            super(region.getTrace(), region, program, block);
        }

        @Override
        public TraceMemoryRegion getRegion() {
            return (TraceMemoryRegion)this.getFromObject();
        }

        @Override
        public AddressRange getFromRange() {
            return this.getRegion().getRange();
        }

        @Override
        public Range<Long> getFromLifespan() {
            return this.getRegion().getLifespan();
        }

        @Override
        public MemoryBlock getBlock() {
            return (MemoryBlock)this.getToObject();
        }

        @Override
        public AddressRange getToRange() {
            return new AddressRangeImpl(this.getBlock().getStart(), this.getBlock().getEnd());
        }

        @Override
        public void setBlock(Program program, MemoryBlock block) {
            this.setToObject(program, block);
        }
    }

    protected class RegionMatcher
    extends AbstractMapProposal.Matcher<TraceMemoryRegion, MemoryBlock> {
        public RegionMatcher(TraceMemoryRegion region, MemoryBlock block) {
            super(region, block);
        }

        @Override
        protected AddressRange getFromRange() {
            return this.fromObject == null ? null : ((TraceMemoryRegion)this.fromObject).getRange();
        }

        @Override
        protected AddressRange getToRange() {
            return this.toObject == null ? null : new AddressRangeImpl(((MemoryBlock)this.toObject).getStart(), ((MemoryBlock)this.toObject).getEnd());
        }

        @Override
        protected double computeScore() {
            return this.computeLengthScore() + (double)this.computeOffsetScore();
        }

        protected int computeOffsetScore() {
            try {
                long fOff = this.fromRange.getMinAddress().subtract(DefaultRegionMapProposal.this.fromBase);
                long tOff = this.toRange.getMinAddress().subtract(DefaultRegionMapProposal.this.toBase);
                if (fOff == tOff) {
                    return 10;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return 0;
        }
    }
}

