/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DebuggerConnectDialog;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServiceInternal;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServiceProxyPlugin;
import ghidra.app.plugin.core.debug.service.model.DebuggerSelectMappingOfferDialog;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.ActionSource;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncFence;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.lifecycle.Internal;
import ghidra.program.model.listing.Program;
import ghidra.trace.database.DBTrace;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.TimedMsg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.datastruct.ListenerSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.CharBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;

@PluginInfo(shortDescription="Debugger models manager service", description="Manage debug sessions, connections, and trace recording", category="Debugger", packageName="Debugger", status=PluginStatus.HIDDEN, servicesRequired={}, servicesProvided={DebuggerModelService.class})
public class DebuggerModelServicePlugin
extends Plugin
implements DebuggerModelServiceInternal,
ApplicationLevelOnlyPlugin {
    private static final String PREFIX_FACTORY = "Factory_";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss-z");
    protected final Set<DebuggerModelServiceProxyPlugin> proxies = new HashSet<DebuggerModelServiceProxyPlugin>();
    protected final Set<DebuggerModelFactory> factories = new HashSet<DebuggerModelFactory>();
    protected final Map<DebuggerObjectModel, ListenersForRemovalAndFocus> listenersByModel = new LinkedHashMap<DebuggerObjectModel, ListenersForRemovalAndFocus>();
    protected final Map<TargetObject, TraceRecorder> recordersByTarget = new WeakHashMap<TargetObject, TraceRecorder>();
    protected final ListenerSet<CollectionChangeListener<DebuggerModelFactory>> factoryListeners = new ListenerSet(CollectionChangeListener.of(DebuggerModelFactory.class));
    protected final ListenerSet<CollectionChangeListener<DebuggerObjectModel>> modelListeners = new ListenerSet(CollectionChangeListener.of(DebuggerObjectModel.class));
    protected final ListenerSet<CollectionChangeListener<TraceRecorder>> recorderListeners = new ListenerSet(CollectionChangeListener.of(TraceRecorder.class));
    protected final ChangeListener classChangeListener = new ChangeListenerForFactoryInstances();
    protected final ListenerOnRecorders listenerOnRecorders = new ListenerOnRecorders();
    protected final DebuggerSelectMappingOfferDialog offerDialog;
    protected final DebuggerConnectDialog connectDialog = new DebuggerConnectDialog();
    DockingAction actionDisconnectAll;
    protected DebuggerObjectModel currentModel;

    public DebuggerModelServicePlugin(PluginTool tool) {
        super(tool);
        this.offerDialog = new DebuggerSelectMappingOfferDialog(tool);
        ClassSearcher.addChangeListener((ChangeListener)this.classChangeListener);
        this.refreshFactoryInstances();
        this.connectDialog.setModelService(this);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void createActions() {
        this.actionDisconnectAll = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.DisconnectAllAction.builder(this, this).menuPath(new String[]{"Debugger", "Disconnect All"})).onAction(this::activatedDisconnectAll)).buildAndInstall((Tool)this.tool);
    }

    private void activatedDisconnectAll(ActionContext context) {
        this.closeAllModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxy(DebuggerModelServiceProxyPlugin proxy) {
        Set<DebuggerModelServiceProxyPlugin> set = this.proxies;
        synchronized (set) {
            this.proxies.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProxy(DebuggerModelServiceProxyPlugin proxy) {
        Set<DebuggerModelServiceProxyPlugin> set = this.proxies;
        synchronized (set) {
            this.proxies.remove(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DebuggerModelFactory> getModelFactories() {
        Set<DebuggerModelFactory> set = this.factories;
        synchronized (set) {
            return Set.copyOf(this.factories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DebuggerObjectModel> getModels() {
        Map<DebuggerObjectModel, ListenersForRemovalAndFocus> map = this.listenersByModel;
        synchronized (map) {
            return Set.copyOf(this.listenersByModel.keySet());
        }
    }

    @Override
    public CompletableFuture<Void> closeAllModels() {
        AsyncFence fence = new AsyncFence();
        for (DebuggerObjectModel model : this.getModels()) {
            fence.include((CompletableFuture)model.close().exceptionally(DebuggerResources.showError(null, "Problem disconnecting")));
        }
        return fence.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TraceRecorder> getTraceRecorders() {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            return List.copyOf(this.recordersByTarget.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addModel(DebuggerObjectModel model) {
        Objects.requireNonNull(model);
        Map<DebuggerObjectModel, ListenersForRemovalAndFocus> map = this.listenersByModel;
        synchronized (map) {
            if (this.listenersByModel.containsKey(model)) {
                return false;
            }
            ListenersForRemovalAndFocus listener = new ListenersForRemovalAndFocus(model);
            listener.init().exceptionally(e -> {
                Msg.error((Object)this, (Object)("Could not add model " + model), (Throwable)e);
                Map<DebuggerObjectModel, ListenersForRemovalAndFocus> map = this.listenersByModel;
                synchronized (map) {
                    this.listenersByModel.remove(model);
                    listener.dispose();
                }
                return null;
            });
            this.listenersByModel.put(model, listener);
        }
        ((CollectionChangeListener)this.modelListeners.fire).elementAdded((Object)model);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeModel(DebuggerObjectModel model) {
        ListenersForRemovalAndFocus listener;
        Map<DebuggerObjectModel, ListenersForRemovalAndFocus> map = this.listenersByModel;
        synchronized (map) {
            listener = this.listenersByModel.remove(model);
            if (listener == null) {
                return false;
            }
        }
        listener.dispose();
        ((CollectionChangeListener)this.modelListeners.fire).elementRemoved((Object)model);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceRecorder recordTarget(TargetObject target, DebuggerTargetTraceMapper mapper, ActionSource source) throws IOException {
        TraceRecorder recorder;
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            recorder = this.recordersByTarget.get(target);
            if (recorder != null) {
                Msg.warn((Object)this, (Object)("Target is already being recorded: " + target));
                return recorder;
            }
            recorder = this.doBeginRecording(target, mapper);
            recorder.addListener(this.listenerOnRecorders);
            recorder.init().exceptionally(e -> {
                if (source == ActionSource.MANUAL) {
                    Msg.showError((Object)this, null, (String)"Record Trace", (Object)"Error initializing recorder", (Throwable)e);
                } else {
                    Msg.error((Object)this, (Object)"Error initializing recorder", (Throwable)e);
                }
                return null;
            });
            this.recordersByTarget.put(target, recorder);
        }
        ((CollectionChangeListener)this.recorderListeners.fire).elementAdded((Object)recorder);
        if (!recorder.isRecording()) {
            this.doRemoveRecorder(recorder);
        }
        return recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceRecorder recordTargetBestOffer(TargetObject target) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            TraceRecorder recorder = this.recordersByTarget.get(target);
            if (recorder != null) {
                Msg.warn((Object)this, (Object)("Target is already being recorded: " + target));
                return recorder;
            }
        }
        DebuggerTargetTraceMapper mapper = DebuggerMappingOffer.first(DebuggerMappingOpinion.queryOpinions(target, false));
        if (mapper == null) {
            throw new NoSuchElementException("No mapper for target: " + target);
        }
        try {
            return this.recordTarget(target, mapper, ActionSource.AUTOMATIC);
        }
        catch (IOException e) {
            throw new AssertionError("Could not record target: " + target, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    protected TraceRecorder doRecordTargetPromptOffers(PluginTool t, TargetObject target) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            TraceRecorder recorder = this.recordersByTarget.get(target);
            if (recorder != null) {
                Msg.warn((Object)this, (Object)("Target is already being recorded: " + target));
                return recorder;
            }
        }
        List<DebuggerMappingOffer> offers = DebuggerMappingOpinion.queryOpinions(target, true);
        this.offerDialog.setOffers(offers);
        t.showDialog((DialogComponentProvider)this.offerDialog);
        if (this.offerDialog.isCancelled()) {
            return null;
        }
        DebuggerMappingOffer selected = this.offerDialog.getSelectedOffer();
        assert (selected != null);
        DebuggerTargetTraceMapper mapper = selected.take();
        try {
            return this.recordTarget(target, mapper, ActionSource.MANUAL);
        }
        catch (IOException e) {
            throw new AssertionError("Could not record target: " + target, e);
        }
    }

    @Override
    public TraceRecorder recordTargetPromptOffers(TargetObject target) {
        return this.doRecordTargetPromptOffers(this.tool, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRecorder(TraceRecorder recorder) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            TraceRecorder old = this.recordersByTarget.remove(recorder.getTarget());
            if (old != recorder) {
                throw new AssertionError((Object)"Container-recorder mix up");
            }
            old.removeListener(this.listenerOnRecorders);
        }
        ((CollectionChangeListener)this.recorderListeners.fire).elementRemoved((Object)recorder);
    }

    @Override
    public synchronized DebuggerObjectModel getCurrentModel() {
        if (!this.currentModel.isAlive()) {
            this.currentModel = null;
        }
        return this.currentModel;
    }

    @Override
    public synchronized boolean doActivateModel(DebuggerObjectModel model) {
        if (model == this.currentModel) {
            return false;
        }
        this.currentModel = model;
        return true;
    }

    @Override
    @Internal
    public void refreshFactoryInstances() {
        List newFactories = ClassSearcher.getInstances(DebuggerModelFactory.class);
        this.setModelFactories(newFactories);
    }

    @Override
    @Internal
    public synchronized void setModelFactories(Collection<DebuggerModelFactory> newFactories) {
        HashSet<DebuggerModelFactory> diff = new HashSet<DebuggerModelFactory>();
        diff.addAll(this.factories);
        diff.removeAll(newFactories);
        for (DebuggerModelFactory factory : diff) {
            this.factories.remove(factory);
            ((CollectionChangeListener)this.factoryListeners.fire).elementRemoved((Object)factory);
        }
        diff.clear();
        diff.addAll(newFactories);
        diff.removeAll(this.factories);
        for (DebuggerModelFactory factory : diff) {
            this.factories.add(factory);
            ((CollectionChangeListener)this.factoryListeners.fire).elementAdded((Object)factory);
        }
    }

    @Override
    public void addFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> listener) {
        this.factoryListeners.add(listener);
    }

    @Override
    public void removeFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> listener) {
        this.factoryListeners.remove(listener);
    }

    @Override
    public synchronized void addModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> listener) {
        this.modelListeners.add(listener);
    }

    @Override
    public synchronized void removeModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> listener) {
        this.modelListeners.remove(listener);
    }

    @Override
    public synchronized void addTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> listener) {
        this.recorderListeners.add(listener);
    }

    @Override
    public synchronized void removeTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> listener) {
        this.recorderListeners.remove(listener);
    }

    @Override
    public TraceRecorder recordTargetAndActivateTrace(TargetObject target, DebuggerTargetTraceMapper mapper, DebuggerTraceManagerService traceManager) throws IOException {
        TraceRecorder recorder = this.recordTarget(target, mapper, ActionSource.AUTOMATIC);
        if (traceManager != null) {
            Trace trace = recorder.getTrace();
            traceManager.openTrace(trace);
            traceManager.activateTrace(trace);
        }
        return recorder;
    }

    @Override
    public TraceRecorder recordTargetAndActivateTrace(TargetObject target, DebuggerTargetTraceMapper mapper) throws IOException {
        return this.recordTargetAndActivateTrace(target, mapper, null);
    }

    protected TraceRecorder doBeginRecording(TargetObject target, DebuggerTargetTraceMapper mapper) throws IOException {
        String traceName = DebuggerModelServicePlugin.nameTrace(target);
        DBTrace trace = new DBTrace(traceName, mapper.getTraceCompilerSpec(), (Object)this);
        TraceRecorder recorder = mapper.startRecording(this, (Trace)trace);
        trace.release((Object)this);
        return recorder;
    }

    protected static String nameTrace(TargetObject target) {
        String name = target.getDisplay();
        if (name == null) {
            name = PathUtils.toString((List)target.getPath());
        }
        CharBuffer buf = CharBuffer.wrap(name.toCharArray());
        for (int i = 0; i < buf.length(); ++i) {
            if (LocalFileSystem.isValidNameCharacter((char)buf.get(i))) continue;
            buf.put(i, '_');
        }
        return AppInfo.getActiveProject().getProjectData().makeValidName(buf + " " + DATE_FORMAT.format(new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveRecorder(TraceRecorder recorder) {
        boolean removed;
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            removed = this.recordersByTarget.remove(recorder.getTarget()) != null;
        }
        if (removed) {
            ((CollectionChangeListener)this.recorderListeners.fire).elementRemoved((Object)recorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceRecorder getRecorder(TargetObject target) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            return this.recordersByTarget.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceRecorder getRecorderForSuccessor(TargetObject successor) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            while (successor != null) {
                TraceRecorder recorder = this.recordersByTarget.get(successor);
                if (recorder != null) {
                    return recorder;
                }
                successor = successor.getParent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceRecorder getRecorder(Trace trace) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            for (TraceRecorder recorder : this.recordersByTarget.values()) {
                if (recorder.getTrace() != trace) continue;
                return recorder;
            }
            return null;
        }
    }

    @Override
    public TargetThread getTargetThread(TraceThread thread) {
        TraceRecorder recorder = this.getRecorder(thread.getTrace());
        if (recorder == null) {
            return null;
        }
        return recorder.getTargetThread(thread);
    }

    @Override
    public TargetObject getTarget(Trace trace) {
        TraceRecorder recorder = this.getRecorder(trace);
        if (recorder == null) {
            return null;
        }
        return recorder.getTarget();
    }

    @Override
    public Trace getTrace(TargetObject target) {
        TraceRecorder recorder = this.getRecorder(target);
        if (recorder == null) {
            return null;
        }
        return recorder.getTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceThread getTraceThread(TargetThread thread) {
        Map<TargetObject, TraceRecorder> map = this.recordersByTarget;
        synchronized (map) {
            for (TraceRecorder recorder : this.recordersByTarget.values()) {
                if (!PathUtils.isAncestor((List)recorder.getTarget().getPath(), (List)thread.getPath())) continue;
                return recorder.getTraceThread(thread);
            }
        }
        return null;
    }

    @Override
    public TraceThread getTraceThread(TargetObject target, TargetThread thread) {
        TraceRecorder recorder = this.getRecorder(target);
        if (recorder == null) {
            return null;
        }
        return recorder.getTraceThread(thread);
    }

    @Override
    public TargetObject getTargetFocus(TargetObject target) {
        TraceRecorder recorder = this.getRecorder(target);
        if (recorder == null) {
            return null;
        }
        return recorder.getFocus();
    }

    public void writeConfigState(SaveState saveState) {
        for (DebuggerModelFactory factory : this.getModelFactories()) {
            String stateName = PREFIX_FACTORY + factory.getClass().getName();
            SaveState factoryState = new SaveState();
            factory.writeConfigState(factoryState);
            saveState.putXmlElement(stateName, factoryState.saveToXml());
        }
        this.connectDialog.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        for (DebuggerModelFactory factory : this.getModelFactories()) {
            String stateName = PREFIX_FACTORY + factory.getClass().getName();
            Element factoryElement = saveState.getXmlElement(stateName);
            if (factoryElement == null) continue;
            SaveState factoryState = new SaveState(factoryElement);
            factory.readConfigState(factoryState);
        }
        this.connectDialog.readConfigState(saveState);
    }

    protected Stream<DebuggerProgramLaunchOffer> doGetProgramLaunchOffers(PluginTool tool, Program program) {
        return ClassSearcher.getInstances(DebuggerProgramLaunchOpinion.class).stream().flatMap(opinion -> opinion.getOffers(program, tool, this).stream());
    }

    @Override
    public Stream<DebuggerProgramLaunchOffer> getProgramLaunchOffers(Program program) {
        return this.doGetProgramLaunchOffers(this.tool, program);
    }

    protected CompletableFuture<DebuggerObjectModel> doShowConnectDialog(PluginTool tool, DebuggerModelFactory factory) {
        CompletableFuture<DebuggerObjectModel> future = this.connectDialog.reset(factory);
        tool.showDialog((DialogComponentProvider)this.connectDialog);
        return future;
    }

    @Override
    public CompletableFuture<DebuggerObjectModel> showConnectDialog(DebuggerModelFactory factory) {
        return this.doShowConnectDialog(this.tool, factory);
    }

    protected class ChangeListenerForFactoryInstances
    implements ChangeListener {
        protected ChangeListenerForFactoryInstances() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DebuggerModelServicePlugin.this.refreshFactoryInstances();
        }
    }

    protected class ListenerOnRecorders
    implements TraceRecorderListener {
        protected ListenerOnRecorders() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void snapAdvanced(TraceRecorder recorder, long snap) {
            List<DebuggerModelServiceProxyPlugin> copy;
            TimedMsg.debug((Object)this, (String)"Got snapAdvanced callback");
            DebuggerModelServicePlugin.this.fireSnapEvent(recorder, snap);
            Set<DebuggerModelServiceProxyPlugin> set = DebuggerModelServicePlugin.this.proxies;
            synchronized (set) {
                copy = List.copyOf(DebuggerModelServicePlugin.this.proxies);
            }
            for (DebuggerModelServiceProxyPlugin proxy : copy) {
                TimedMsg.debug((Object)this, (String)("Firing SnapEvent on " + proxy));
                proxy.fireSnapEvent(recorder, snap);
            }
        }

        @Override
        public void recordingStopped(TraceRecorder recorder) {
            DebuggerModelServicePlugin.this.removeRecorder(recorder);
        }
    }

    protected class ListenersForRemovalAndFocus {
        protected final DebuggerObjectModel model;
        protected TargetObject root;
        protected TargetFocusScope focusScope;
        protected DebuggerModelListener forRemoval = new DebuggerModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invalidated(TargetObject object, TargetObject branch, String reason) {
                Map<DebuggerObjectModel, ListenersForRemovalAndFocus> map = DebuggerModelServicePlugin.this.listenersByModel;
                synchronized (map) {
                    ListenersForRemovalAndFocus listener = DebuggerModelServicePlugin.this.listenersByModel.remove(ListenersForRemovalAndFocus.this.model);
                    if (listener == null) {
                        return;
                    }
                    assert (listener.forRemoval == this);
                    ListenersForRemovalAndFocus.this.dispose();
                }
                ((CollectionChangeListener)DebuggerModelServicePlugin.this.modelListeners.fire).elementRemoved((Object)ListenersForRemovalAndFocus.this.model);
                DebuggerModelServicePlugin.this.activateModel(null);
            }
        };
        protected DebuggerModelListener forFocus = new AnnotatedDebuggerAttributeListener(MethodHandles.lookup()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
            public void focusChanged(TargetObject object, TargetObject focused) {
                List<DebuggerModelServiceProxyPlugin> copy;
                DebuggerModelServicePlugin.this.fireFocusEvent(focused);
                Set<DebuggerModelServiceProxyPlugin> set = DebuggerModelServicePlugin.this.proxies;
                synchronized (set) {
                    copy = List.copyOf(DebuggerModelServicePlugin.this.proxies);
                }
                for (DebuggerModelServiceProxyPlugin proxy : copy) {
                    proxy.fireFocusEvent(focused);
                }
            }
        };

        protected ListenersForRemovalAndFocus(DebuggerObjectModel model) {
            this.model = model;
        }

        protected CompletableFuture<Void> init() {
            return ((CompletableFuture)this.model.fetchModelRoot().thenCompose(r -> {
                ListenersForRemovalAndFocus listenersForRemovalAndFocus = this;
                synchronized (listenersForRemovalAndFocus) {
                    this.root = r;
                }
                boolean isInvalid = false;
                try {
                    r.addListener(this.forRemoval);
                }
                catch (IllegalStateException e) {
                    isInvalid = true;
                }
                if (isInvalid |= !r.isValid()) {
                    this.forRemoval.invalidated(this.root, this.root, "Who knows?");
                }
                CompletableFuture findSuitable = DebugModelConventions.findSuitable(TargetFocusScope.class, (TargetObject)r);
                return findSuitable;
            })).thenAccept(fs -> {
                ListenersForRemovalAndFocus listenersForRemovalAndFocus = this;
                synchronized (listenersForRemovalAndFocus) {
                    this.focusScope = fs;
                }
                if (fs != null) {
                    fs.addListener(this.forFocus);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            TargetFocusScope savedFocusScope;
            TargetObject savedRoot;
            ListenersForRemovalAndFocus listenersForRemovalAndFocus = this;
            synchronized (listenersForRemovalAndFocus) {
                savedRoot = this.root;
                savedFocusScope = this.focusScope;
            }
            if (savedRoot != null) {
                savedRoot.removeListener(this.forRemoval);
            }
            if (savedFocusScope != null) {
                savedFocusScope.removeListener(this.forFocus);
            }
        }
    }
}

