/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.service.emulation.EmulatorOutOfMemoryException;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.database.DBTrace;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.ComparatorMath;
import ghidra.util.DifferenceAddressSetView;
import ghidra.util.NumericUtilities;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ProgramEmulationUtils
extends Enum<ProgramEmulationUtils> {
    public static final String EMULATION_STARTED_AT = "Emulation started at ";
    private static final /* synthetic */ ProgramEmulationUtils[] $VALUES;

    public static ProgramEmulationUtils[] values() {
        return (ProgramEmulationUtils[])$VALUES.clone();
    }

    public static ProgramEmulationUtils valueOf(String name) {
        return Enum.valueOf(ProgramEmulationUtils.class, name);
    }

    public static String getTraceName(Program program) {
        DomainFile df = program.getDomainFile();
        if (df != null) {
            return "Emulate " + df.getName();
        }
        return "Emulate " + program.getName();
    }

    public static String getModuleName(Program program) {
        String executablePath = program.getExecutablePath();
        if (executablePath != null) {
            return executablePath;
        }
        DomainFile df = program.getDomainFile();
        if (df != null) {
            return df.getName();
        }
        return program.getName();
    }

    public static Set<TraceMemoryFlag> getRegionFlags(MemoryBlock block) {
        EnumSet<TraceMemoryFlag> result = EnumSet.noneOf(TraceMemoryFlag.class);
        int mask = block.getPermissions();
        if ((mask & 4) != 0) {
            result.add(TraceMemoryFlag.READ);
        }
        if ((mask & 2) != 0) {
            result.add(TraceMemoryFlag.WRITE);
        }
        if ((mask & 1) != 0) {
            result.add(TraceMemoryFlag.EXECUTE);
        }
        if ((mask & 8) != 0) {
            result.add(TraceMemoryFlag.VOLATILE);
        }
        return result;
    }

    public static void loadExecutable(TraceSnapshot snapshot, Program program) {
        Trace trace = snapshot.getTrace();
        HashMap<AddressSpace, Extrema> extremaBySpace = new HashMap<AddressSpace, Extrema>();
        try {
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!block.isLoaded() || block.isOverlay()) continue;
                AddressRangeImpl range = new AddressRangeImpl(block.getStart(), block.getEnd());
                extremaBySpace.computeIfAbsent(range.getAddressSpace(), s -> new Extrema()).consider((AddressRange)range);
                String modName = ProgramEmulationUtils.getModuleName(program);
                String path = "Modules[" + modName + "].Sections[" + block.getName() + "-" + block.getStart() + "]";
                trace.getMemoryManager().createRegion(path, snapshot.getKey(), (AddressRange)range, ProgramEmulationUtils.getRegionFlags(block));
            }
            for (Extrema extrema : extremaBySpace.values()) {
                DebuggerStaticMappingUtils.addMapping((TraceLocation)new DefaultTraceLocation(trace, null, Range.atLeast((Comparable)Long.valueOf(snapshot.getKey())), extrema.min), new ProgramLocation(program, extrema.min), extrema.max.subtract(extrema.min), false);
            }
        }
        catch (TraceOverlappedRegionException | TraceConflictedMappingException | DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TraceThread spawnThread(Trace trace, long snap) {
        TraceThreadManager tm = trace.getThreadManager();
        long next = tm.getAllThreads().size();
        while (!tm.getThreadsByPath("Threads[" + next + "]").isEmpty()) {
            ++next;
        }
        try {
            return tm.createThread("Threads[" + next + "]", "[" + next + "]", snap);
        }
        catch (DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void initializeRegisters(Trace trace, long snap, TraceThread thread, Program program, Address tracePc, Address programPc, TraceMemoryRegion stack) {
        Register regPC;
        TraceMemoryManager memory = trace.getMemoryManager();
        TraceMemorySpace regSpace = memory.getMemoryRegisterSpace(thread, true);
        if (program != null) {
            ProgramContext ctx = program.getProgramContext();
            for (Register reg : Stream.of(ctx.getRegistersWithValues()).map(Register::getBaseRegister).collect(Collectors.toSet())) {
                RegisterValue rv = ctx.getRegisterValue(reg, programPc);
                if (rv == null || !rv.hasAnyValue()) continue;
                TraceMemorySpace space = reg.getAddressSpace().isRegisterSpace() ? regSpace : memory;
                space.setValue(snap, new RegisterValue(reg, BigInteger.ZERO).combineValues(rv));
            }
        }
        TraceMemorySpace spacePC = (regPC = trace.getBaseLanguage().getProgramCounter()).getAddressSpace().isRegisterSpace() ? regSpace : memory;
        spacePC.setValue(snap, new RegisterValue(regPC, NumericUtilities.unsignedLongToBigInteger((long)tracePc.getAddressableWordOffset())));
        if (stack != null) {
            CompilerSpec cSpec = trace.getBaseCompilerSpec();
            Address sp = cSpec.stackGrowsNegative() ? stack.getMaxAddress().addWrap(1L) : stack.getMinAddress();
            Register regSP = cSpec.getStackPointer();
            if (regSP != null) {
                TraceMemorySpace spaceSP = regSP.getAddressSpace().isRegisterSpace() ? regSpace : memory;
                spaceSP.setValue(snap, new RegisterValue(regSP, NumericUtilities.unsignedLongToBigInteger((long)sp.getAddressableWordOffset())));
            }
        }
    }

    public static TraceMemoryRegion allocateStack(Trace trace, long snap, TraceThread thread, long size) {
        AddressSpace space = trace.getBaseCompilerSpec().getStackBaseSpace();
        AddressSet except0 = new AddressSet(space.getAddress(4096L), space.getMaxAddress());
        TraceMemoryManager mm = trace.getMemoryManager();
        DifferenceAddressSetView left = new DifferenceAddressSetView((AddressSetView)except0, mm.getRegionsAddressSet(snap));
        try {
            for (AddressRange candidate : left) {
                if (Long.compareUnsigned(candidate.getLength(), size) <= 0) continue;
                AddressRangeImpl alloc = new AddressRangeImpl(candidate.getMinAddress(), size);
                return mm.createRegion(thread.getPath() + ".Stack", snap, (AddressRange)alloc, new TraceMemoryFlag[]{TraceMemoryFlag.READ, TraceMemoryFlag.WRITE});
            }
        }
        catch (AddressOverflowException | TraceOverlappedRegionException | DuplicateNameException e) {
            throw new AssertionError((Object)e);
        }
        throw new EmulatorOutOfMemoryException();
    }

    public static Trace launchEmulationTrace(Program program, Address pc, Object consumer) throws IOException {
        DBTrace trace = null;
        boolean success = false;
        try {
            trace = new DBTrace(ProgramEmulationUtils.getTraceName(program), program.getCompilerSpec(), consumer);
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Emulate");){
                TraceSnapshot initial = trace.getTimeManager().createSnapshot(EMULATION_STARTED_AT + pc);
                long snap = initial.getKey();
                ProgramEmulationUtils.loadExecutable(initial, program);
                ProgramEmulationUtils.doLaunchEmulationThread((Trace)trace, snap, program, pc, pc);
            }
            success = true;
            tid = trace;
            return tid;
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (!success && trace != null) {
                trace.release(consumer);
            }
        }
    }

    public static TraceThread doLaunchEmulationThread(Trace trace, long snap, Program program, Address tracePc, Address programPc) {
        TraceThread thread = ProgramEmulationUtils.spawnThread(trace, snap);
        TraceMemoryRegion stack = ProgramEmulationUtils.allocateStack(trace, snap, thread, 16384L);
        ProgramEmulationUtils.initializeRegisters(trace, snap, thread, program, tracePc, programPc, stack);
        return thread;
    }

    public static TraceThread launchEmulationThread(Trace trace, long snap, Program program, Address tracePc, Address programPc) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Emulate new Thread");){
            TraceThread thread;
            TraceThread traceThread = thread = ProgramEmulationUtils.doLaunchEmulationThread(trace, snap, program, tracePc, programPc);
            return traceThread;
        }
    }

    public static boolean isEmulatedProgram(Trace trace) {
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(0L, false);
        if (snapshot == null) {
            return false;
        }
        return snapshot.getDescription().startsWith(EMULATION_STARTED_AT);
    }

    private static /* synthetic */ ProgramEmulationUtils[] $values() {
        return new ProgramEmulationUtils[0];
    }

    static {
        $VALUES = ProgramEmulationUtils.$values();
    }

    static class Extrema {
        Address min = null;
        Address max = null;

        Extrema() {
        }

        void consider(AddressRange range) {
            this.min = this.min == null ? range.getMinAddress() : (Address)ComparatorMath.cmin((Comparable)this.min, (Comparable)range.getMinAddress());
            this.max = this.max == null ? range.getMaxAddress() : (Address)ComparatorMath.cmax((Comparable)this.max, (Comparable)range.getMaxAddress());
        }
    }
}

