/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.editing;

import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStateEditingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.program.model.mem.LiveMemoryListener;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewMemory;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@PluginInfo(shortDescription="Debugger machine-state editing service plugin", description="Centralizes machine-state editing across the tool", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerEmulationService.class}, servicesProvided={DebuggerStateEditingService.class})
public class DebuggerStateEditingServicePlugin
extends AbstractDebuggerPlugin
implements DebuggerStateEditingService {
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerEmulationService emulationSerivce;
    @AutoServiceConsumed
    private DebuggerModelService modelService;
    protected final ListenerForEditorInstallation listenerForEditorInstallation = new ListenerForEditorInstallation();
    private static final DebuggerStateEditingService.StateEditingMode DEFAULT_MODE = DebuggerStateEditingService.StateEditingMode.WRITE_TARGET;
    private final Map<Trace, DebuggerStateEditingService.StateEditingMode> currentModes = new HashMap<Trace, DebuggerStateEditingService.StateEditingMode>();
    private final ListenerSet<DebuggerStateEditingService.StateEditingModeChangeListener> listeners = new ListenerSet(DebuggerStateEditingService.StateEditingModeChangeListener.class);

    public DebuggerStateEditingServicePlugin(PluginTool tool) {
        super(tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerStateEditingService.StateEditingMode getCurrentMode(Trace trace) {
        Map<Trace, DebuggerStateEditingService.StateEditingMode> map = this.currentModes;
        synchronized (map) {
            return this.currentModes.getOrDefault(Objects.requireNonNull(trace), DEFAULT_MODE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentMode(Trace trace, DebuggerStateEditingService.StateEditingMode mode) {
        boolean fire = false;
        Map<Trace, DebuggerStateEditingService.StateEditingMode> map = this.currentModes;
        synchronized (map) {
            DebuggerStateEditingService.StateEditingMode old = this.currentModes.getOrDefault(Objects.requireNonNull(trace), DEFAULT_MODE);
            if (mode != old) {
                this.currentModes.put(trace, mode);
                fire = true;
            }
        }
        if (fire) {
            ((DebuggerStateEditingService.StateEditingModeChangeListener)this.listeners.fire).modeChanged(trace, mode);
            this.tool.contextChanged(null);
        }
    }

    @Override
    public void addModeChangeListener(DebuggerStateEditingService.StateEditingModeChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeModeChangeListener(DebuggerStateEditingService.StateEditingModeChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public DebuggerStateEditingService.StateEditor createStateEditor(DebuggerCoordinates coordinates) {
        return new DefaultStateEditor(coordinates);
    }

    @Override
    public DebuggerStateEditingService.StateEditor createStateEditor(Trace trace) {
        return new FollowsManagerStateEditor(trace);
    }

    @Override
    public DebuggerStateEditingService.StateEditingMemoryHandler createStateEditor(TraceProgramView view) {
        return new FollowsViewStateEditor(view);
    }

    protected void installMemoryEditor(TraceProgramView view) {
        TraceProgramViewMemory memory = view.getMemory();
        if (memory.getLiveMemoryHandler() != null) {
            return;
        }
        memory.setLiveMemoryHandler((LiveMemoryHandler)this.createStateEditor(view));
    }

    protected void uninstallMemoryEditor(TraceProgramView view) {
        TraceProgramViewMemory memory = view.getMemory();
        LiveMemoryHandler handler = memory.getLiveMemoryHandler();
        if (!(handler instanceof DebuggerStateEditingService.StateEditingMemoryHandler)) {
            return;
        }
        DebuggerStateEditingService.StateEditingMemoryHandler editor = (DebuggerStateEditingService.StateEditingMemoryHandler)handler;
        if (editor.getService() != this) {
            return;
        }
        memory.setLiveMemoryHandler(null);
    }

    protected void installAllMemoryEditors(Trace trace) {
        trace.addProgramViewListener((Trace.TraceProgramViewListener)this.listenerForEditorInstallation);
        for (TraceProgramView view : trace.getAllProgramViews()) {
            this.installMemoryEditor(view);
        }
    }

    protected void installAllMemoryEditors() {
        if (this.traceManager == null) {
            return;
        }
        for (Trace trace : this.traceManager.getOpenTraces()) {
            this.installAllMemoryEditors(trace);
        }
    }

    protected void uninstallAllMemoryEditors(Trace trace) {
        trace.removeProgramViewListener((Trace.TraceProgramViewListener)this.listenerForEditorInstallation);
        for (TraceProgramView view : trace.getAllProgramViews()) {
            this.uninstallMemoryEditor(view);
        }
    }

    protected void uninstallAllMemoryEditors() {
        if (this.traceManager == null) {
            return;
        }
        for (Trace trace : this.traceManager.getOpenTraces()) {
            this.uninstallAllMemoryEditors(trace);
        }
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent ev = (TraceOpenedPluginEvent)event;
            this.installAllMemoryEditors(ev.getTrace());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.uninstallAllMemoryEditors(ev.getTrace());
        }
    }

    @AutoServiceConsumed
    private void setTraceManager(DebuggerTraceManagerService traceManager) {
        this.uninstallAllMemoryEditors();
        this.traceManager = traceManager;
        this.installAllMemoryEditors();
    }

    protected class ListenerForEditorInstallation
    implements Trace.TraceProgramViewListener {
        protected ListenerForEditorInstallation() {
        }

        public void viewCreated(TraceProgramView view) {
            DebuggerStateEditingServicePlugin.this.installMemoryEditor(view);
        }
    }

    protected class DefaultStateEditor
    extends AbstractStateEditor {
        private final DebuggerCoordinates coordinates;

        public DefaultStateEditor(DebuggerCoordinates coordinates) {
            this.coordinates = Objects.requireNonNull(coordinates);
        }

        @Override
        public DebuggerStateEditingService getService() {
            return DebuggerStateEditingServicePlugin.this;
        }

        @Override
        public DebuggerCoordinates getCoordinates() {
            return this.coordinates;
        }
    }

    protected class FollowsManagerStateEditor
    extends AbstractStateEditor {
        private final Trace trace;

        public FollowsManagerStateEditor(Trace trace) {
            this.trace = trace;
        }

        @Override
        public DebuggerStateEditingService getService() {
            return DebuggerStateEditingServicePlugin.this;
        }

        @Override
        public DebuggerCoordinates getCoordinates() {
            if (!DebuggerStateEditingServicePlugin.this.traceManager.getOpenTraces().contains(this.trace)) {
                throw new IllegalStateException("Trace " + this.trace + " is not opened in the trace manager.");
            }
            return DebuggerStateEditingServicePlugin.this.traceManager.resolveTrace(this.trace);
        }
    }

    public class FollowsViewStateEditor
    extends AbstractStateEditor
    implements DebuggerStateEditingService.StateEditingMemoryHandler {
        private final TraceProgramView view;

        public FollowsViewStateEditor(TraceProgramView view) {
            this.view = view;
        }

        @Override
        public DebuggerStateEditingService getService() {
            return DebuggerStateEditingServicePlugin.this;
        }

        @Override
        public DebuggerCoordinates getCoordinates() {
            return DebuggerStateEditingServicePlugin.this.traceManager.resolveView(this.view);
        }

        public void clearCache() {
        }

        public byte getByte(Address addr) throws MemoryAccessException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            this.view.getTrace().getMemoryManager().getViewBytes(this.view.getSnap(), addr, buf);
            return buf.get(0);
        }

        public int getBytes(Address address, byte[] buffer, int startIndex, int size) throws MemoryAccessException {
            return this.view.getTrace().getMemoryManager().getViewBytes(this.view.getSnap(), address, ByteBuffer.wrap(buffer, startIndex, size));
        }

        public void putByte(Address address, byte value) throws MemoryAccessException {
            try {
                this.setVariable(address, new byte[]{value}).get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw new MemoryAccessException("Failed to write " + address + ": " + e.getCause());
            }
            catch (InterruptedException | TimeoutException e) {
                throw new MemoryAccessException("Failed to write " + address + ": " + e);
            }
        }

        public int putBytes(Address address, byte[] source, int startIndex, int size) throws MemoryAccessException {
            try {
                this.setVariable(address, Arrays.copyOfRange(source, startIndex, startIndex + size)).get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw new MemoryAccessException("Failed to write " + address + ": " + e.getCause());
            }
            catch (InterruptedException | TimeoutException e) {
                throw new MemoryAccessException("Failed to write " + address + ": " + e);
            }
            return size;
        }

        public void addLiveMemoryListener(LiveMemoryListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeLiveMemoryListener(LiveMemoryListener listener) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class AbstractStateEditor
    implements DebuggerStateEditingService.StateEditor {
        protected AbstractStateEditor() {
        }

        @Override
        public boolean isVariableEditable(Address address, int length) {
            DebuggerCoordinates coordinates = this.getCoordinates();
            Trace trace = coordinates.getTrace();
            switch (DebuggerStateEditingServicePlugin.this.getCurrentMode(trace)) {
                case READ_ONLY: {
                    return false;
                }
                case WRITE_TARGET: {
                    return this.isTargetVariableEditable(coordinates, address, length);
                }
                case WRITE_TRACE: {
                    return this.isTraceVariableEditable(coordinates, address, length);
                }
                case WRITE_EMULATOR: {
                    return this.isEmulatorVariableEditable(coordinates, address, length);
                }
            }
            throw new AssertionError();
        }

        protected boolean isTargetVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            if (!coordinates.isAliveAndPresent()) {
                return false;
            }
            TraceRecorder recorder = coordinates.getRecorder();
            return recorder.isVariableOnTarget(coordinates.getThread(), address, length);
        }

        protected boolean isTraceVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            return address.isMemoryAddress() || coordinates.getThread() != null;
        }

        protected boolean isEmulatorVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            if (!this.isTraceVariableEditable(coordinates, address, length)) {
                return false;
            }
            Register ctxReg = coordinates.getTrace().getBaseLanguage().getContextBaseRegister();
            if (ctxReg == Register.NO_CONTEXT) {
                return true;
            }
            AddressRange ctxRange = TraceRegisterUtils.rangeForRegister((Register)ctxReg);
            return !ctxRange.contains(address);
        }

        @Override
        public CompletableFuture<Void> setVariable(Address address, byte[] data) {
            DebuggerCoordinates coordinates = this.getCoordinates();
            Trace trace = coordinates.getTrace();
            DebuggerStateEditingService.StateEditingMode mode = DebuggerStateEditingServicePlugin.this.getCurrentMode(trace);
            switch (mode) {
                case READ_ONLY: {
                    return CompletableFuture.failedFuture(new MemoryAccessException("Read-only mode"));
                }
                case WRITE_TARGET: {
                    return this.writeTargetVariable(coordinates, address, data);
                }
                case WRITE_TRACE: {
                    return this.writeTraceVariable(coordinates, address, data);
                }
                case WRITE_EMULATOR: {
                    return this.writeEmulatorVariable(coordinates, address, data);
                }
            }
            throw new AssertionError();
        }

        protected CompletableFuture<Void> writeTargetVariable(DebuggerCoordinates coordinates, Address address, byte[] data) {
            TraceRecorder recorder = coordinates.getRecorder();
            if (recorder == null) {
                return CompletableFuture.failedFuture(new MemoryAccessException("Trace has no live target"));
            }
            if (!coordinates.isPresent()) {
                return CompletableFuture.failedFuture(new MemoryAccessException("View is not the present"));
            }
            return recorder.writeVariable(coordinates.getPlatform(), coordinates.getThread(), coordinates.getFrame(), address, data);
        }

        protected CompletableFuture<Void> writeTraceVariable(DebuggerCoordinates coordinates, Address guestAddress, byte[] data) {
            Trace trace = coordinates.getTrace();
            TracePlatform platform = coordinates.getPlatform();
            long snap = coordinates.getViewSnap();
            Address hostAddress = platform.mapGuestToHost(guestAddress);
            if (hostAddress == null) {
                throw new IllegalArgumentException("Guest address " + guestAddress + " is not mapped");
            }
            try (UndoableTransaction txid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Edit Variable");){
                Address overlayAddress;
                TraceMemoryManager memOrRegs;
                if (hostAddress.isRegisterAddress()) {
                    TraceThread thread = coordinates.getThread();
                    if (thread == null) {
                        throw new IllegalArgumentException("Register edits require a thread.");
                    }
                    TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(thread, coordinates.getFrame(), true);
                    memOrRegs = regs;
                    overlayAddress = regs.getAddressSpace().getOverlayAddress(hostAddress);
                } else {
                    memOrRegs = trace.getMemoryManager();
                    overlayAddress = hostAddress;
                }
                if (memOrRegs.putBytes(snap, overlayAddress, ByteBuffer.wrap(data)) != data.length) {
                    CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new MemoryAccessException());
                    return completableFuture;
                }
            }
            return AsyncUtils.NIL;
        }

        protected CompletableFuture<Void> writeEmulatorVariable(DebuggerCoordinates coordinates, Address address, byte[] data) {
            if (!(coordinates.getView() instanceof TraceVariableSnapProgramView)) {
                throw new IllegalArgumentException("Cannot emulate using a Fixed Program View");
            }
            TraceThread thread = coordinates.getThread();
            if (thread == null) {
                throw new IllegalArgumentException("Emulator edits require a thread.");
            }
            Language language = coordinates.getPlatform().getLanguage();
            TraceSchedule time = coordinates.getTime().patched(thread, language, PatchStep.generateSleigh((Language)language, (Address)address, (byte[])data));
            DebuggerCoordinates withTime = coordinates.time(time);
            Long found = DebuggerStateEditingServicePlugin.this.traceManager.findSnapshot(withTime);
            if (found == null) {
                try {
                    DebuggerStateEditingServicePlugin.this.emulationSerivce.emulate(coordinates.getPlatform(), time, TaskMonitor.DUMMY);
                }
                catch (CancelledException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return DebuggerStateEditingServicePlugin.this.traceManager.activateAndNotify(withTime, false);
        }
    }
}

