/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import com.google.common.collect.Range;
import generic.CatenatedCollection;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.plugin.core.debug.service.breakpoint.LoneLogicalBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.MappedLogicalBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.TrackedTooSoonException;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.LogicalBreakpointsChangeListener;
import ghidra.app.services.TraceRecorder;
import ghidra.async.SwingExecutorService;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;

@PluginInfo(shortDescription="Debugger logical breakpoints service plugin", description="Aggregates breakpoints from open programs and live traces", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerModelService.class, DebuggerStaticMappingService.class}, servicesProvided={DebuggerLogicalBreakpointService.class})
public class DebuggerLogicalBreakpointServicePlugin
extends Plugin
implements DebuggerLogicalBreakpointService {
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerStaticMappingService mappingService;
    private final AutoService.Wiring autoServiceWiring;
    private final Object lock = new Object();
    private final ListenerSet<LogicalBreakpointsChangeListener> changeListeners = new ListenerSet(LogicalBreakpointsChangeListener.class);
    private final TrackRecordersListener recorderListener = new TrackRecordersListener();
    private final TrackMappingsListener mappingListener = new TrackMappingsListener();
    private final Map<Trace, InfoPerTrace> traceInfos = new HashMap<Trace, InfoPerTrace>();
    private final Map<Program, InfoPerProgram> programInfos = new HashMap<Program, InfoPerProgram>();
    private final Collection<AbstractInfo> allInfos = new CatenatedCollection(new Collection[]{this.traceInfos.values(), this.programInfos.values()});
    private final ExecutorService executor = SwingExecutorService.MAYBE_NOW;

    public DebuggerLogicalBreakpointServicePlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    protected void processChange(Consumer<ChangeCollector> processor, String description) {
        this.executor.submit(() -> {
            try (ChangeCollector c = new ChangeCollector((LogicalBreakpointsChangeListener)this.changeListeners.fire);){
                Object object = this.lock;
                synchronized (object) {
                    processor.accept(c);
                }
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Could not process event " + description), (Throwable)t);
            }
        });
    }

    protected void evtMappingsChanged(ChangeCollector c, Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
        AbstractInfo info;
        HashSet<Trace> additionalTraces = new HashSet<Trace>(affectedTraces);
        HashSet<Program> additionalPrograms = new HashSet<Program>(affectedPrograms);
        for (Trace t : affectedTraces) {
            info = this.traceInfos.get(t);
            if (info == null) continue;
            info.forgetMismappedBreakpoints(c.r, additionalTraces, additionalPrograms);
        }
        for (Program p : affectedPrograms) {
            info = this.programInfos.get(p);
            if (info == null) continue;
            info.forgetMismappedBreakpoints(c.r, additionalTraces, additionalPrograms);
        }
        for (Trace t : additionalTraces) {
            info = this.traceInfos.get(t);
            if (info == null) continue;
            ((InfoPerTrace)info).reloadBreakpoints(c);
        }
        for (Program p : additionalPrograms) {
            info = this.programInfos.get(p);
            if (info == null) continue;
            ((InfoPerProgram)info).reloadBreakpoints(c);
        }
    }

    protected void removeLogicalBreakpointGlobally(LogicalBreakpoint lb) {
        InfoPerProgram info;
        ProgramLocation pLoc = lb.getProgramLocation();
        if (pLoc != null && (info = this.programInfos.get(pLoc.getProgram())) != null) {
            info.removeLogicalBreakpoint(pLoc.getByteAddress(), lb);
        }
        for (Trace t : lb.getMappedTraces()) {
            Address tAddr = lb.getTraceAddress(t);
            InfoPerTrace info2 = this.traceInfos.get(t);
            if (info2 == null) continue;
            info2.removeLogicalBreakpoint(tAddr, lb);
        }
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeTraceRecordersChangedListener(this.recorderListener);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addTraceRecordersChangedListener(this.recorderListener);
        }
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener(this.mappingListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener(this.mappingListener);
        }
    }

    private void programOpened(Program program) {
        this.processChange(c -> this.evtProgramOpened((ChangeCollector)c, program), "programOpened");
    }

    private void evtProgramOpened(ChangeCollector c, Program program) {
        if (program instanceof TraceProgramView) {
            return;
        }
        InfoPerProgram info = new InfoPerProgram(program);
        if (this.programInfos.put(program, info) != null) {
            throw new AssertionError((Object)"Already tracking program breakpoints");
        }
        info.reloadBreakpoints(c);
    }

    private void programClosed(Program program) {
        this.processChange(c -> this.evtProgramClosed((ChangeCollector)c, program), "programClosed");
    }

    private void evtProgramClosed(ChangeCollector c, Program program) {
        if (program instanceof TraceProgramView) {
            return;
        }
        this.programInfos.remove(program).dispose(c.r);
    }

    private void doTrackTrace(ChangeCollector c, Trace trace, TraceRecorder recorder) {
        if (this.traceInfos.containsKey(trace)) {
            Msg.warn((Object)this, (Object)"Already tracking trace breakpoints");
            return;
        }
        InfoPerTrace info = new InfoPerTrace(recorder);
        this.traceInfos.put(trace, info);
        info.reloadBreakpoints(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUntrackTrace(ChangeCollector c, Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace tInfo = this.traceInfos.remove(trace);
            if (tInfo == null) {
                return;
            }
            tInfo.dispose(c.r);
            for (InfoPerProgram pInfo : this.programInfos.values()) {
                for (Set set : pInfo.breakpointsByAddress.values()) {
                    for (LogicalBreakpointInternal lb : set) {
                        lb.removeTrace(trace);
                        c.a.updated(lb);
                    }
                }
            }
        }
    }

    private void evtTraceRecordingStarted(ChangeCollector c, TraceRecorder recorder) {
        Trace trace = recorder.getTrace();
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            return;
        }
        this.doTrackTrace(c, trace, recorder);
    }

    private void evtTraceRecordingStopped(ChangeCollector c, TraceRecorder recorder) {
        this.doUntrackTrace(c, recorder.getTrace());
    }

    private void traceOpened(Trace trace) {
        this.processChange(c -> {
            TraceRecorder recorder = this.modelService.getRecorder(trace);
            if (recorder == null) {
                return;
            }
            this.doTrackTrace((ChangeCollector)c, trace, recorder);
        }, "traceOpened");
    }

    private void traceClosed(Trace trace) {
        this.processChange(c -> this.doUntrackTrace((ChangeCollector)c, trace), "traceClosed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalBreakpoint> getAllBreakpoints() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<LogicalBreakpoint> records = new HashSet<LogicalBreakpoint>();
            for (AbstractInfo info : this.allInfos) {
                for (Set recsAtAddress : info.breakpointsByAddress.values()) {
                    records.addAll(recsAtAddress);
                }
            }
            return records;
        }
    }

    protected static <K, V> NavigableMap<K, Set<V>> copyOf(NavigableMap<? extends K, ? extends Set<? extends V>> map) {
        TreeMap result = new TreeMap();
        for (Map.Entry ent : map.entrySet()) {
            result.put(ent.getKey(), new HashSet((Collection)ent.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Program program) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.programInfos.get(program);
            if (info == null) {
                return Collections.emptyNavigableMap();
            }
            return DebuggerLogicalBreakpointServicePlugin.copyOf(info.breakpointsByAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return Collections.emptyNavigableMap();
            }
            return DebuggerLogicalBreakpointServicePlugin.copyOf(info.breakpointsByAddress);
        }
    }

    protected Set<LogicalBreakpoint> doGetBreakpointsAt(AbstractInfo info, Address address) {
        Set set = (Set)info.breakpointsByAddress.get(address);
        if (set == null) {
            return Set.of();
        }
        return new HashSet<LogicalBreakpoint>(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalBreakpoint> getBreakpointsAt(Program program, Address address) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.programInfos.get(program);
            if (info == null) {
                return Set.of();
            }
            return this.doGetBreakpointsAt(info, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LogicalBreakpoint> getBreakpointsAt(Trace trace, Address address) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return Set.of();
            }
            return this.doGetBreakpointsAt(info, address).stream().filter(lb -> lb.computeStateForTrace(trace) != LogicalBreakpoint.State.NONE).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicalBreakpoint getBreakpoint(TraceBreakpoint bpt) {
        Trace trace = bpt.getTrace();
        Object object = this.lock;
        synchronized (object) {
            for (LogicalBreakpoint lb : this.getBreakpointsAt(trace, bpt.getMinAddress())) {
                if (!lb.getTraceBreakpoints(trace).contains(bpt)) continue;
                return lb;
            }
        }
        return null;
    }

    @Override
    public Set<LogicalBreakpoint> getBreakpointsAt(ProgramLocation loc) {
        return DebuggerLogicalBreakpointService.programOrTrace(loc, this::getBreakpointsAt, this::getBreakpointsAt);
    }

    @Override
    public void addChangeListener(LogicalBreakpointsChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    @Override
    public void removeChangeListener(LogicalBreakpointsChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    @Override
    public CompletableFuture<Void> changesSettled() {
        return CompletableFuture.supplyAsync(() -> null, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MappedLogicalBreakpoint synthesizeLogicalBreakpoint(Program program, Address address, long length, Collection<TraceBreakpointKind> kinds) {
        MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(program, address, length, kinds);
        Object object = this.lock;
        synchronized (object) {
            for (InfoPerTrace ti : this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (loc == null) continue;
                lb.setTraceAddress(ti.recorder, loc.getAddress());
            }
        }
        return lb;
    }

    @Override
    public CompletableFuture<Void> placeBreakpointAt(Program program, Address address, long length, Collection<TraceBreakpointKind> kinds, String name) {
        MappedLogicalBreakpoint lb = this.synthesizeLogicalBreakpoint(program, address, length, kinds);
        return lb.enableWithName(name);
    }

    @Override
    public CompletableFuture<Void> placeBreakpointAt(Trace trace, Address address, long length, Collection<TraceBreakpointKind> kinds, String name) {
        TraceRecorder recorder = this.modelService.getRecorder(trace);
        if (recorder == null) {
            throw new IllegalArgumentException("Given trace is not live");
        }
        ProgramLocation staticLocation = this.mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(trace, null, Range.singleton((Comparable)Long.valueOf(recorder.getSnap())), address));
        if (staticLocation == null) {
            return new LoneLogicalBreakpoint(recorder, address, length, kinds).enableForTrace(trace);
        }
        MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(staticLocation.getProgram(), staticLocation.getByteAddress(), length, kinds);
        lb.setTraceAddress(recorder, address);
        lb.enableForProgramWithName(name);
        return lb.enableForTrace(trace);
    }

    @Override
    public CompletableFuture<Void> placeBreakpointAt(ProgramLocation loc, long length, Collection<TraceBreakpointKind> kinds, String name) {
        return DebuggerLogicalBreakpointService.programOrTrace(loc, (p, a) -> this.placeBreakpointAt((Program)p, (Address)a, length, kinds, name), (t, a) -> this.placeBreakpointAt((Trace)t, (Address)a, length, kinds, name));
    }

    protected CompletableFuture<Void> actOnAll(Collection<LogicalBreakpoint> col, Trace trace, Consumer<LogicalBreakpoint> consumerForProgram, BiConsumer<BreakpointActionSet, LogicalBreakpointInternal> consumerForTarget) {
        BreakpointActionSet actions = new BreakpointActionSet();
        for (LogicalBreakpoint lb : col) {
            Set<Trace> participants = lb.getParticipatingTraces();
            if (trace == null || participants.isEmpty() || participants.equals(Set.of(trace))) {
                consumerForProgram.accept(lb);
            }
            if (!(lb instanceof LogicalBreakpointInternal)) continue;
            LogicalBreakpointInternal lbi = (LogicalBreakpointInternal)lb;
            consumerForTarget.accept(actions, lbi);
        }
        return actions.execute();
    }

    @Override
    public String generateStatusEnable(Collection<LogicalBreakpoint> col, Trace trace) {
        for (LogicalBreakpoint lb : col) {
            String message = lb.generateStatusEnable(trace);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> enableAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::enableForProgram, (actions, lbi) -> lbi.planEnable((BreakpointActionSet)actions, trace));
    }

    @Override
    public CompletableFuture<Void> disableAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::disableForProgram, (actions, lbi) -> lbi.planDisable((BreakpointActionSet)actions, trace));
    }

    @Override
    public CompletableFuture<Void> deleteAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, lb -> {
            if (trace == null) {
                lb.deleteForProgram();
            }
        }, (actions, lbi) -> lbi.planDelete((BreakpointActionSet)actions, trace));
    }

    protected CompletableFuture<Void> actOnLocs(Collection<TraceBreakpoint> col, BiConsumer<BreakpointActionSet, TargetBreakpointLocation> locConsumer, Consumer<LogicalBreakpoint> progConsumer) {
        BreakpointActionSet actions = new BreakpointActionSet();
        for (TraceBreakpoint tb : col) {
            TraceRecorder recorder;
            LogicalBreakpoint lb = this.getBreakpoint(tb);
            if (col.containsAll(lb.getTraceBreakpoints())) {
                progConsumer.accept(lb);
            }
            if ((recorder = this.modelService.getRecorder(tb.getTrace())) == null) continue;
            List path = PathUtils.parse((String)tb.getPath());
            TargetObject object = recorder.getTarget().getModel().getModelObject(path);
            if (!(object instanceof TargetBreakpointLocation)) {
                Msg.error((Object)this, (Object)(tb.getPath() + " is not a target breakpoint location"));
                continue;
            }
            TargetBreakpointLocation loc = (TargetBreakpointLocation)object;
            locConsumer.accept(actions, loc);
        }
        return actions.execute();
    }

    @Override
    public CompletableFuture<Void> enableLocs(Collection<TraceBreakpoint> col) {
        return this.actOnLocs(col, BreakpointActionSet::planEnable, LogicalBreakpoint::enableForProgram);
    }

    @Override
    public CompletableFuture<Void> disableLocs(Collection<TraceBreakpoint> col) {
        return this.actOnLocs(col, BreakpointActionSet::planDisable, LogicalBreakpoint::disableForProgram);
    }

    @Override
    public CompletableFuture<Void> deleteLocs(Collection<TraceBreakpoint> col) {
        return this.actOnLocs(col, BreakpointActionSet::planDelete, lb -> {});
    }

    @Override
    public String generateStatusToggleAt(ProgramLocation loc) {
        Set<LogicalBreakpoint> bs = this.getBreakpointsAt(loc);
        if (bs == null || bs.isEmpty()) {
            return null;
        }
        LogicalBreakpoint.State state = this.computeState(bs, loc);
        Trace trace = DebuggerLogicalBreakpointService.programOrTrace(loc, (p, a) -> null, (t, a) -> t);
        boolean mapped = this.anyMapped(bs, trace);
        if (!mapped) {
            return "No breakpoint at this location is mapped to a live trace. Cannot toggle on target. Is there a target? Check your module map.";
        }
        LogicalBreakpoint.State toggled = state.getToggled(mapped);
        if (!toggled.isEnabled()) {
            return null;
        }
        return this.generateStatusEnable(bs, trace);
    }

    @Override
    public CompletableFuture<Set<LogicalBreakpoint>> toggleBreakpointsAt(ProgramLocation loc, Supplier<CompletableFuture<Set<LogicalBreakpoint>>> placer) {
        Trace trace;
        boolean mapped;
        Set<LogicalBreakpoint> bs = this.getBreakpointsAt(loc);
        if (bs == null || bs.isEmpty()) {
            return placer.get();
        }
        LogicalBreakpoint.State state = this.computeState(bs, loc);
        LogicalBreakpoint.State toggled = state.getToggled(mapped = this.anyMapped(bs, trace = DebuggerLogicalBreakpointService.programOrTrace(loc, (p, a) -> null, (t, a) -> t)));
        if (toggled.isEnabled()) {
            return this.enableAll(bs, trace).thenApply(__ -> bs);
        }
        return this.disableAll(bs, trace).thenApply(__ -> bs);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent openedEvt = (ProgramOpenedPluginEvent)event;
            this.programOpened(openedEvt.getProgram());
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent closedEvt = (ProgramClosedPluginEvent)event;
            this.programClosed(closedEvt.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent openedEvt = (TraceOpenedPluginEvent)event;
            this.traceOpened(openedEvt.getTrace());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent closedEvt = (TraceClosedPluginEvent)event;
            this.traceClosed(closedEvt.getTrace());
        }
    }

    protected class TrackRecordersListener
    implements CollectionChangeListener<TraceRecorder> {
        protected TrackRecordersListener() {
        }

        public void elementAdded(TraceRecorder element) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtTraceRecordingStarted((ChangeCollector)c, element), "recordingStarted");
        }

        public void elementRemoved(TraceRecorder element) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtTraceRecordingStopped((ChangeCollector)c, element), "recordingStopped");
        }
    }

    protected class TrackMappingsListener
    implements DebuggerStaticMappingChangeListener {
        protected TrackMappingsListener() {
        }

        @Override
        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtMappingsChanged((ChangeCollector)c, affectedTraces, affectedPrograms), "mappingsChanged");
        }
    }

    protected class InfoPerTrace
    extends AbstractInfo {
        final TraceRecorder recorder;
        final Trace trace;
        final TraceBreakpointsListener breakpointListener;

        public InfoPerTrace(TraceRecorder recorder) {
            this.recorder = recorder;
            this.trace = recorder.getTrace();
            this.breakpointListener = new TraceBreakpointsListener(this);
            this.trace.addListener((DomainObjectListener)this.breakpointListener);
        }

        @Override
        protected LogicalBreakpointInternal createLogicalBreakpoint(Address address, long length, Collection<TraceBreakpointKind> kinds) {
            return new LoneLogicalBreakpoint(this.recorder, address, length, kinds);
        }

        @Override
        protected void dispose(RemoveCollector r) {
            this.trace.removeListener((DomainObjectListener)this.breakpointListener);
            this.forgetAllBreakpoints(r);
        }

        protected void reloadBreakpoints(ChangeCollector c) {
            this.forgetTraceInvalidBreakpoints(c.r);
            this.trackTraceLiveBreakpoints(c.a);
        }

        protected void forgetAllBreakpoints(RemoveCollector r) {
            ArrayList live = new ArrayList();
            for (AddressRange range : this.trace.getBaseAddressFactory().getAddressSet()) {
                live.addAll(this.trace.getBreakpointManager().getBreakpointsIntersecting(Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), range));
            }
            for (TraceBreakpoint tb : live) {
                this.forgetTraceBreakpoint(r, tb);
            }
        }

        protected void forgetTraceInvalidBreakpoints(RemoveCollector r) {
            for (Set set : List.copyOf(this.breakpointsByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    for (TraceBreakpoint tb : Set.copyOf(lb.getTraceBreakpoints(this.trace))) {
                        if (!this.trace.getBreakpointManager().getAllBreakpoints().contains(tb)) {
                            this.forgetTraceBreakpoint(r, tb);
                            continue;
                        }
                        ProgramLocation progLoc = this.computeStaticLocation(tb);
                        if (Objects.equals(lb.getProgramLocation(), progLoc)) continue;
                        this.forgetTraceBreakpoint(r, tb);
                    }
                }
            }
        }

        protected void trackTraceLiveBreakpoints(AddCollector a) {
            ArrayList<TraceBreakpoint> live = new ArrayList<TraceBreakpoint>();
            for (AddressRange range : this.trace.getBaseAddressFactory().getAddressSet()) {
                live.addAll(this.trace.getBreakpointManager().getBreakpointsIntersecting(Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), range));
            }
            this.trackTraceBreakpoints(a, live);
        }

        protected void trackTraceBreakpoints(AddCollector a, Collection<TraceBreakpoint> breakpoints) {
            for (TraceBreakpoint tb : breakpoints) {
                try {
                    this.trackTraceBreakpoint(a, tb, false);
                }
                catch (TrackedTooSoonException e) {
                    Msg.warn((Object)this, (Object)("Might have lost track of a breakpoint: " + tb));
                }
            }
        }

        protected ProgramLocation computeStaticLocation(TraceBreakpoint tb) {
            if (DebuggerLogicalBreakpointServicePlugin.this.traceManager == null || !DebuggerLogicalBreakpointServicePlugin.this.traceManager.getOpenTraces().contains(tb.getTrace())) {
                return null;
            }
            return DebuggerLogicalBreakpointServicePlugin.this.mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(this.trace, null, Range.singleton((Comparable)Long.valueOf(this.recorder.getSnap())), tb.getMinAddress()));
        }

        protected void trackTraceBreakpoint(AddCollector a, TraceBreakpoint tb, boolean forceUpdate) throws TrackedTooSoonException {
            LogicalBreakpointInternal lb;
            Address traceAddr = tb.getMinAddress();
            ProgramLocation progLoc = this.computeStaticLocation(tb);
            if (progLoc != null) {
                InfoPerProgram progInfo = DebuggerLogicalBreakpointServicePlugin.this.programInfos.get(progLoc.getProgram());
                lb = progInfo.getOrCreateLogicalBreakpointFor(a, progLoc.getByteAddress(), tb);
            } else {
                lb = this.getOrCreateLogicalBreakpointFor(a, traceAddr, tb);
            }
            assert (((Set)this.breakpointsByAddress.get(traceAddr)).contains(lb));
            if (lb.trackBreakpoint(tb) || forceUpdate) {
                a.updated(lb);
            }
        }

        protected void forgetTraceBreakpoint(RemoveCollector r, TraceBreakpoint tb) {
            LogicalBreakpointInternal lb = this.removeFromLogicalBreakpoint(r, tb.getMinAddress(), tb);
            if (lb == null) {
                return;
            }
            assert (lb.isEmpty() == (this.breakpointsByAddress.get(tb.getMinAddress()) == null || !((Set)this.breakpointsByAddress.get(tb.getMinAddress())).contains(lb)));
        }

        public TraceLocation toDynamicLocation(ProgramLocation loc) {
            return DebuggerLogicalBreakpointServicePlugin.this.mappingService.getOpenMappedLocation(this.trace, loc, this.recorder.getSnap());
        }
    }

    private static class ChangeCollector
    implements AutoCloseable {
        private final AddCollector a;
        private final RemoveCollector r;

        public ChangeCollector(LogicalBreakpointsChangeListener l) {
            HashSet<LogicalBreakpoint> updated = new HashSet<LogicalBreakpoint>();
            this.a = new AddCollector(l, updated);
            this.r = new RemoveCollector(l, updated);
        }

        @Override
        public void close() {
            this.r.deconflict();
            this.a.deconflict();
            this.r.close();
            this.a.close();
        }
    }

    private static class RemoveCollector
    implements AutoCloseable {
        private final LogicalBreakpointsChangeListener l;
        private final Set<LogicalBreakpoint> removed = new HashSet<LogicalBreakpoint>();
        private final Set<LogicalBreakpoint> updated;

        public RemoveCollector(LogicalBreakpointsChangeListener l, Set<LogicalBreakpoint> updated) {
            this.l = l;
            this.updated = updated;
        }

        protected void updated(LogicalBreakpoint lb) {
            this.updated.add(lb);
        }

        protected void removed(LogicalBreakpoint lb) {
            this.removed.add(lb);
        }

        protected void deconflict() {
            this.updated.removeAll(this.removed);
        }

        @Override
        public void close() {
            this.deconflict();
            if (!this.removed.isEmpty()) {
                this.l.breakpointsRemoved(this.removed);
            }
            if (!this.updated.isEmpty()) {
                this.l.breakpointsUpdated(this.updated);
            }
            this.updated.clear();
        }
    }

    protected class InfoPerProgram
    extends AbstractInfo {
        final Program program;
        final ProgramBreakpointsListener breakpointListener;

        public InfoPerProgram(Program program) {
            this.program = program;
            this.breakpointListener = new ProgramBreakpointsListener(this);
            program.addListener((DomainObjectListener)this.breakpointListener);
        }

        protected void mapTraceAddresses(LogicalBreakpointInternal lb) {
            for (InfoPerTrace ti : DebuggerLogicalBreakpointServicePlugin.this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (loc == null) continue;
                lb.setTraceAddress(ti.recorder, loc.getAddress());
                ti.breakpointsByAddress.computeIfAbsent(loc.getAddress(), __ -> new HashSet()).add(lb);
            }
        }

        @Override
        protected LogicalBreakpointInternal createLogicalBreakpoint(Address address, long length, Collection<TraceBreakpointKind> kinds) {
            MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(this.program, address, length, kinds);
            this.mapTraceAddresses(lb);
            return lb;
        }

        protected LogicalBreakpointInternal getOrCreateLogicalBreakpointFor(AddCollector a, Bookmark pb) {
            Address address = pb.getAddress();
            Set set = this.breakpointsByAddress.computeIfAbsent(address, __ -> new HashSet());
            for (LogicalBreakpointInternal lb : set) {
                if (!lb.canMerge(this.program, pb)) continue;
                return lb;
            }
            LogicalBreakpointInternal lb = this.createLogicalBreakpoint(address, LogicalBreakpointInternal.ProgramBreakpoint.lengthFromBookmark(pb), LogicalBreakpointInternal.ProgramBreakpoint.kindsFromBookmark(pb));
            set.add(lb);
            a.added(lb);
            return lb;
        }

        protected LogicalBreakpointInternal removeFromLogicalBreakpoint(RemoveCollector r, Bookmark pb, boolean forChange) {
            Address address = pb.getAddress();
            Set set = (Set)this.breakpointsByAddress.get(address);
            if (set == null) {
                Msg.error((Object)this, (Object)("Breakpoint " + pb + " was not tracked before removal!"));
                return null;
            }
            for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                if (!lb.untrackBreakpoint(this.program, pb)) continue;
                if (lb.isEmpty() && !forChange) {
                    this.removeLogicalBreakpoint(address, lb);
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    r.removed(lb);
                } else {
                    r.updated(lb);
                }
                return lb;
            }
            Msg.error((Object)this, (Object)("Breakpoint " + pb + " was not tracked before removal!"));
            return null;
        }

        @Override
        protected void dispose(RemoveCollector r) {
            this.program.removeListener((DomainObjectListener)this.breakpointListener);
            this.forgetAllBreakpoints(r);
        }

        protected void reloadBreakpoints(ChangeCollector c) {
            this.forgetProgramInvalidBreakpoints(c.r);
            this.trackAllProgramBreakpoints(c.a);
        }

        protected void forgetAllBreakpoints(RemoveCollector r) {
            ArrayList marks = new ArrayList();
            this.program.getBookmarkManager().getBookmarksIterator("BreakpointEnabled").forEachRemaining(marks::add);
            this.program.getBookmarkManager().getBookmarksIterator("BreakpointDisabled").forEachRemaining(marks::add);
            for (Bookmark pb : marks) {
                this.forgetProgramBreakpoint(r, pb, false);
            }
        }

        protected void forgetProgramInvalidBreakpoints(RemoveCollector r) {
            for (Set set : List.copyOf(this.breakpointsByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    Bookmark pb = lb.getProgramBookmark();
                    if (pb == null) continue;
                    if (pb != this.program.getBookmarkManager().getBookmark(pb.getId())) {
                        this.forgetProgramBreakpoint(r, pb, false);
                        continue;
                    }
                    if (lb.getProgramLocation().getByteAddress().equals((Object)pb.getAddress())) continue;
                    this.forgetProgramBreakpoint(r, pb, false);
                }
            }
        }

        protected void trackAllProgramBreakpoints(AddCollector a) {
            BookmarkManager bookmarks = this.program.getBookmarkManager();
            this.trackProgramBreakpoints(a, IteratorUtils.asIterable((Iterator)bookmarks.getBookmarksIterator("BreakpointEnabled")));
            this.trackProgramBreakpoints(a, IteratorUtils.asIterable((Iterator)bookmarks.getBookmarksIterator("BreakpointDisabled")));
        }

        protected void trackProgramBreakpoints(AddCollector a, Iterable<Bookmark> bptMarks) {
            for (Bookmark pb : bptMarks) {
                this.trackProgramBreakpoint(a, pb);
            }
        }

        protected void trackProgramBreakpoint(AddCollector a, Bookmark pb) {
            LogicalBreakpointInternal lb = this.getOrCreateLogicalBreakpointFor(a, pb);
            assert (((Set)this.breakpointsByAddress.get(pb.getAddress())).contains(lb));
            if (lb.trackBreakpoint(pb)) {
                a.updated(lb);
            }
        }

        protected void forgetProgramBreakpoint(RemoveCollector r, Bookmark pb, boolean forChange) {
            LogicalBreakpointInternal lb = this.removeFromLogicalBreakpoint(r, pb, forChange);
            if (lb == null) {
                return;
            }
            assert (this.isConsistentAfterRemoval(pb, lb, forChange));
        }

        private boolean isConsistentAfterRemoval(Bookmark pb, LogicalBreakpointInternal lb, boolean forChange) {
            Set present = (Set)this.breakpointsByAddress.get(pb.getAddress());
            boolean shouldBeAbsent = lb.isEmpty() && !forChange;
            boolean isAbsent = present == null || !present.contains(lb);
            return shouldBeAbsent == isAbsent;
        }
    }

    private static class AddCollector
    implements AutoCloseable {
        private final LogicalBreakpointsChangeListener l;
        private final Set<LogicalBreakpoint> added = new HashSet<LogicalBreakpoint>();
        private final Set<LogicalBreakpoint> updated;

        public AddCollector(LogicalBreakpointsChangeListener l, Set<LogicalBreakpoint> updated) {
            this.l = l;
            this.updated = updated;
        }

        protected void added(LogicalBreakpoint lb) {
            this.added.add(lb);
        }

        protected void updated(LogicalBreakpoint lb) {
            this.updated.add(lb);
        }

        protected void deconflict() {
            this.updated.removeAll(this.added);
        }

        @Override
        public void close() {
            this.deconflict();
            if (!this.updated.isEmpty()) {
                this.l.breakpointsUpdated(this.updated);
            }
            if (!this.added.isEmpty()) {
                this.l.breakpointsAdded(this.added);
            }
        }
    }

    protected abstract class AbstractInfo {
        final NavigableMap<Address, Set<LogicalBreakpointInternal>> breakpointsByAddress = new TreeMap<Address, Set<LogicalBreakpointInternal>>();

        protected abstract void dispose(RemoveCollector var1);

        protected abstract LogicalBreakpointInternal createLogicalBreakpoint(Address var1, long var2, Collection<TraceBreakpointKind> var4);

        protected LogicalBreakpointInternal getOrCreateLogicalBreakpointFor(AddCollector a, Address address, TraceBreakpoint tb) throws TrackedTooSoonException {
            Set set = this.breakpointsByAddress.computeIfAbsent(address, __ -> new HashSet());
            for (LogicalBreakpointInternal lb : set) {
                if (!lb.canMerge(tb)) continue;
                return lb;
            }
            LogicalBreakpointInternal lb = this.createLogicalBreakpoint(address, tb.getLength(), tb.getKinds());
            set.add(lb);
            a.added(lb);
            return lb;
        }

        protected LogicalBreakpointInternal removeFromLogicalBreakpoint(RemoveCollector r, Address address, TraceBreakpoint tb) {
            Set set = (Set)this.breakpointsByAddress.get(address);
            if (set == null) {
                Msg.warn((Object)this, (Object)("Breakpoint to remove is not present: " + tb + ", trace=" + tb.getTrace()));
                return null;
            }
            for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                if (!lb.untrackBreakpoint(tb)) continue;
                if (lb.isEmpty()) {
                    this.removeLogicalBreakpoint(address, lb);
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    r.removed(lb);
                } else {
                    r.updated(lb);
                }
                return lb;
            }
            Msg.warn((Object)this, (Object)("Breakpoint to remove is not present: " + tb + ", trace=" + tb.getTrace()));
            return null;
        }

        protected boolean removeLogicalBreakpoint(Address address, LogicalBreakpoint lb) {
            Set set = (Set)this.breakpointsByAddress.get(address);
            if (set == null) {
                return false;
            }
            if (!set.remove(lb)) {
                return false;
            }
            if (set.isEmpty()) {
                this.breakpointsByAddress.remove(address);
            }
            return true;
        }

        protected boolean isMismapped(LogicalBreakpointInternal lb) {
            if (!(lb instanceof MappedLogicalBreakpoint)) {
                return false;
            }
            HashSet<Trace> extraneous = new HashSet<Trace>(lb.getMappedTraces());
            extraneous.removeAll(DebuggerLogicalBreakpointServicePlugin.this.traceInfos.keySet());
            if (!extraneous.isEmpty()) {
                return true;
            }
            for (InfoPerTrace ti : DebuggerLogicalBreakpointServicePlugin.this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (!(loc == null ? lb.getTraceAddress(ti.trace) != null : !loc.getAddress().equals((Object)lb.getTraceAddress(ti.trace)))) continue;
                return true;
            }
            return false;
        }

        protected void forgetMismappedBreakpoints(RemoveCollector r, Set<Trace> additionalTraces, Set<Program> additionalPrograms) {
            for (Set set : List.copyOf(this.breakpointsByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    if (!this.isMismapped(lb)) continue;
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    r.removed(lb);
                    additionalTraces.addAll(lb.getParticipatingTraces());
                }
            }
        }
    }

    private class ProgramBreakpointsListener
    extends TraceDomainObjectListener {
        private final InfoPerProgram info;
        private ChangeCollector c;

        public ProgramBreakpointsListener(InfoPerProgram info) {
            this.info = info;
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenForUntyped(122, this.onBreakpoint(this::breakpointBookmarkAdded));
            this.listenForUntyped(124, this.onBreakpoint(this::breakpointBookmarkChanged));
            this.listenForUntyped(123, this.onBreakpoint(this::breakpointBookmarkDeleted));
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> {
                this.c = c;
                super.domainObjectChanged(ev);
                this.c = null;
            }, "program-domainObjectChanged");
        }

        private void objectRestored() {
            this.info.reloadBreakpoints(this.c);
        }

        private Consumer<DomainObjectChangeRecord> onBreakpoint(Consumer<Bookmark> handler) {
            return rec -> {
                ProgramChangeRecord pcrec = (ProgramChangeRecord)rec;
                Bookmark pb = (Bookmark)pcrec.getObject();
                String bmType = pb.getTypeString();
                if ("BreakpointEnabled".equals(bmType) || "BreakpointDisabled".equals(bmType)) {
                    handler.accept(pb);
                }
            };
        }

        private void breakpointBookmarkAdded(Bookmark pb) {
            this.info.trackProgramBreakpoint(this.c.a, pb);
        }

        private void breakpointBookmarkChanged(Bookmark pb) {
            this.breakpointBookmarkDeleted(pb, true);
            this.breakpointBookmarkAdded(pb);
        }

        private void breakpointBookmarkDeleted(Bookmark pb) {
            this.breakpointBookmarkDeleted(pb, false);
        }

        private void breakpointBookmarkDeleted(Bookmark pb, boolean forChange) {
            this.info.forgetProgramBreakpoint(this.c.r, pb, forChange);
        }
    }

    private class TraceBreakpointsListener
    extends TraceDomainObjectListener {
        private final InfoPerTrace info;
        private ChangeCollector c;

        public TraceBreakpointsListener(InfoPerTrace info) {
            this.info = info;
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.ADDED, this::breakpointAdded);
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.CHANGED, this::breakpointChanged);
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.LIFESPAN_CHANGED, this::breakpointLifespanChanged);
            this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.DELETED, this::breakpointDeleted);
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> {
                this.c = c;
                super.domainObjectChanged(ev);
                this.c = null;
            }, "trace-domainObjectChanged");
        }

        private void objectRestored() {
            this.info.reloadBreakpoints(this.c);
        }

        private void breakpointAdded(TraceBreakpoint tb) {
            if (!tb.getLifespan().contains((Comparable)Long.valueOf(this.info.recorder.getSnap()))) {
                return;
            }
            try {
                this.info.trackTraceBreakpoint(this.c.a, tb, false);
            }
            catch (TrackedTooSoonException e) {
                Msg.info((Object)((Object)this), (Object)("Ignoring " + tb + " added until service has finished loading its trace"));
            }
        }

        private void breakpointChanged(TraceBreakpoint tb) {
            if (!tb.getLifespan().contains((Comparable)Long.valueOf(this.info.recorder.getSnap()))) {
                return;
            }
            try {
                this.info.trackTraceBreakpoint(this.c.a, tb, true);
            }
            catch (TrackedTooSoonException e) {
                Msg.info((Object)((Object)this), (Object)("Ignoring " + tb + " changed until service has finished loading its trace"));
            }
            catch (NoSuchElementException e) {
                Msg.error((Object)((Object)this), (Object)("!!!! Object-based breakpoint emitted event without a spec: " + tb));
            }
        }

        private void breakpointLifespanChanged(TraceAddressSpace spaceIsNull, TraceBreakpoint tb, Range<Long> oldSpan, Range<Long> newSpan) {
            boolean isInNew;
            boolean isInOld = oldSpan.contains((Comparable)Long.valueOf(this.info.recorder.getSnap()));
            if (isInOld == (isInNew = newSpan.contains((Comparable)Long.valueOf(this.info.recorder.getSnap())))) {
                return;
            }
            if (isInOld) {
                this.info.forgetTraceBreakpoint(this.c.r, tb);
            } else {
                try {
                    this.info.trackTraceBreakpoint(this.c.a, tb, false);
                }
                catch (TrackedTooSoonException e) {
                    Msg.info((Object)((Object)this), (Object)("Ignoring " + tb + " span changed until service has finished loading its trace"));
                }
            }
        }

        private void breakpointDeleted(TraceBreakpoint tb) {
            if (!tb.getLifespan().contains((Comparable)Long.valueOf(this.info.recorder.getSnap()))) {
                return;
            }
            this.info.forgetTraceBreakpoint(this.c.r, tb);
        }
    }
}

