/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredAction;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.PluginTool;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.service.graph.GraphType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class DisplayFilteredGraphAction
extends DisplayFilteredAction {
    protected GraphDisplayBroker graphBroker;
    protected static ImageIcon ICON_GRAPH = ResourceManager.loadImage((String)"images/breakpoints.png");

    public DisplayFilteredGraphAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("DisplayFilteredGraph", tool, owner, provider);
        String[] path = new String[]{"Display filtered...", "Graph"};
        this.setPopupMenuData(new MenuData(path, (Icon)ICON_GRAPH));
        this.setKeyBindingData(new KeyBindingData(71, 192));
        this.setHelpLocation(new HelpLocation(owner, "display_filtered_graph"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    protected void doAction(ObjectContainer container, List<String> path) {
        this.graphBroker = this.provider.getGraphBroker();
        if (this.graphBroker == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"DisplayAsGraph Error", (Object)"GraphBroker not found: Please add a graph provider to your tool");
            return;
        }
        ObjectContainer clone = ObjectContainer.clone(container);
        clone.setImmutable(true);
        this.getOffspring(clone, path);
    }

    private void graphContainer(ObjectContainer container, AttributedGraph graph, AttributedVertex start) {
        Set<ObjectContainer> children = container.getCurrentChildren();
        for (ObjectContainer c : children) {
            AttributedVertex end = graph.addVertex(c.getName(), c.toString());
            graph.addEdge(start, end, c.getTargetObject().getName());
            if (!c.hasElements()) continue;
            this.graphContainer(c, graph, end);
        }
    }

    @Override
    protected void finishGetOffspring(ObjectContainer container, List<String> path) {
        GraphDisplayProvider graphProvider = this.graphBroker.getDefaultGraphDisplayProvider();
        AttributedGraph graph = new AttributedGraph(container.getName(), (GraphType)new EmptyGraphType());
        AttributedVertex start = graph.addVertex(container.getName(), container.toString());
        this.graphContainer(container, graph, start);
        try {
            GraphDisplay graphDisplay = graphProvider.getGraphDisplay(true, TaskMonitor.DUMMY);
            graphDisplay.setGraph(graph, container.getName(), false, TaskMonitor.DUMMY);
        }
        catch (GraphException e) {
            e.printStackTrace();
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }
}

