/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTableModel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueLifeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueLifePlotColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueValColumn;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.framework.plugintool.Plugin;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectTableModel
extends AbstractQueryTableModel<ValueRow> {
    private TraceValueValColumn valueColumn;
    private TraceValueLifePlotColumn lifePlotColumn;
    private Map<ColKey, TraceValueObjectAttributeColumn> columnCache = new HashMap<ColKey, TraceValueObjectAttributeColumn>();

    protected static Stream<? extends TraceObjectValue> distinctCanonical(Stream<? extends TraceObjectValue> stream) {
        HashSet seen = new HashSet();
        return stream.filter(value -> {
            if (!value.isCanonical()) {
                return true;
            }
            return seen.add(value.getChild());
        });
    }

    protected ValueRow rowForValue(TraceObjectValue value) {
        if (value.getValue() instanceof TraceObject) {
            return new ObjectRow(value);
        }
        return new PrimitiveRow(value);
    }

    protected ObjectTableModel(Plugin plugin) {
        super("Object Model", plugin);
    }

    @Override
    protected void traceChanged() {
        this.reloadAttributeColumns();
        this.updateTimelineMax();
        super.traceChanged();
    }

    @Override
    protected void queryChanged() {
        this.reloadAttributeColumns();
        super.queryChanged();
    }

    @Override
    protected void showHiddenChanged() {
        this.reloadAttributeColumns();
        super.showHiddenChanged();
    }

    @Override
    protected void maxSnapChanged() {
        this.updateTimelineMax();
        this.refresh();
    }

    protected void updateTimelineMax() {
        Long max = this.getTrace() == null ? null : this.getTrace().getTimeManager().getMaxSnap();
        Range fullRange = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(max == null ? 1L : max + 1L));
        this.lifePlotColumn.setFullRange((Range<Long>)fullRange);
    }

    protected List<TargetObjectSchema.AttributeSchema> computeAttributeSchemas() {
        Trace trace = this.getTrace();
        ModelQuery query = this.getQuery();
        if (trace == null || query == null) {
            return List.of();
        }
        TargetObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return List.of();
        }
        SchemaContext ctx = rootSchema.getContext();
        return query.computeAttributes(trace).filter(a -> this.isShowHidden() || !a.isHidden()).filter(a -> !ctx.getSchema(a.getSchema()).isCanonicalContainer()).collect(Collectors.toList());
    }

    protected void reloadAttributeColumns() {
        List<Object> attributes;
        Trace trace = this.getTrace();
        ModelQuery query = this.getQuery();
        if (trace == null || query == null || trace.getObjectManager().getRootSchema() == null) {
            attributes = List.of();
        } else {
            SchemaContext ctx = trace.getObjectManager().getRootSchema().getContext();
            attributes = query.computeAttributes(trace).filter(a -> this.isShowHidden() || !a.isHidden()).filter(a -> !ctx.getSchema(a.getSchema()).isCanonicalContainer()).collect(Collectors.toList());
        }
        this.resyncAttributeColumns(attributes);
    }

    protected Set<DynamicTableColumn<ValueRow, ?, ?>> computeAttributeColumns(Collection<TargetObjectSchema.AttributeSchema> attributes) {
        Trace trace = this.getTrace();
        if (trace == null) {
            return Set.of();
        }
        TargetObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return Set.of();
        }
        SchemaContext ctx = rootSchema.getContext();
        return attributes.stream().map(as -> this.columnCache.computeIfAbsent(ColKey.fromSchema(ctx, as), ck -> TraceValueObjectAttributeColumn.fromSchema(ctx, as))).collect(Collectors.toSet());
    }

    protected void resyncAttributeColumns(Collection<TargetObjectSchema.AttributeSchema> attributes) {
        HashSet columns = new HashSet(this.computeAttributeColumns(attributes));
        HashSet<DynamicTableColumn> toRemove = new HashSet<DynamicTableColumn>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            DynamicTableColumn exists = this.getColumn(i);
            if (!(exists instanceof TraceValueObjectAttributeColumn) || columns.remove(exists)) continue;
            toRemove.add(exists);
        }
        this.removeTableColumns(toRemove);
        this.addTableColumns(columns);
    }

    @Override
    protected Stream<ValueRow> streamRows(Trace trace, ModelQuery query, Range<Long> span) {
        return ObjectTableModel.distinctCanonical(query.streamValues(trace, span).filter(v -> this.isShowHidden() || !v.isHidden())).map(this::rowForValue);
    }

    protected TableColumnDescriptor<ValueRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new TraceValueKeyColumn());
        this.valueColumn = new TraceValueValColumn();
        descriptor.addVisibleColumn((DynamicTableColumn)this.valueColumn);
        descriptor.addVisibleColumn((DynamicTableColumn)new TraceValueLifeColumn());
        this.lifePlotColumn = new TraceValueLifePlotColumn();
        descriptor.addHiddenColumn((DynamicTableColumn)this.lifePlotColumn);
        return descriptor;
    }

    @Override
    public ValueRow findTraceObject(TraceObject object) {
        for (ValueRow row : this.getModelData()) {
            if (row.getValue().getValue() != object || !row.getValue().isCanonical()) continue;
            return row;
        }
        return null;
    }

    @Override
    public void setDiffColor(Color diffColor) {
        this.valueColumn.setDiffColor(diffColor);
        for (TraceValueObjectAttributeColumn column : this.columnCache.values()) {
            column.setDiffColor(diffColor);
        }
    }

    @Override
    public void setDiffColorSel(Color diffColorSel) {
        this.valueColumn.setDiffColorSel(diffColorSel);
        for (TraceValueObjectAttributeColumn column : this.columnCache.values()) {
            column.setDiffColorSel(diffColorSel);
        }
    }

    @Override
    protected void snapChanged() {
        super.snapChanged();
        this.lifePlotColumn.setSnap(this.getSnap());
    }

    @Override
    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        this.lifePlotColumn.addSeekListener(listener);
    }

    protected class ObjectRow
    extends AbstractValueRow {
        private final TraceObject object;

        public ObjectRow(TraceObjectValue value) {
            super(value);
            this.object = value.getChild();
        }

        public TraceObject getTraceObject() {
            return this.object;
        }

        @Override
        public String getDisplay() {
            return ObjectTableModel.this.display.getEdgeDisplay(this.value);
        }

        @Override
        public String getHtmlDisplay() {
            return ObjectTableModel.this.display.getEdgeHtmlDisplay(this.value);
        }

        @Override
        public String getToolTip() {
            return ObjectTableModel.this.display.getEdgeToolTip(this.value);
        }

        @Override
        public TraceObjectValue getAttribute(String attributeName) {
            return this.object.getAttribute(ObjectTableModel.this.getSnap(), attributeName);
        }

        @Override
        public String getAttributeDisplay(String attributeName) {
            return ObjectTableModel.this.display.getEdgeDisplay(this.getAttribute(attributeName));
        }

        @Override
        public String getAttributeHtmlDisplay(String attributeName) {
            return ObjectTableModel.this.display.getEdgeHtmlDisplay(this.getAttribute(attributeName));
        }

        @Override
        public String getAttributeToolTip(String attributeName) {
            return ObjectTableModel.this.display.getEdgeToolTip(this.getAttribute(attributeName));
        }

        @Override
        public boolean isAttributeModified(String attributeName) {
            return ObjectTableModel.this.isValueModified(this.getAttribute(attributeName));
        }
    }

    protected class PrimitiveRow
    extends AbstractValueRow {
        public PrimitiveRow(TraceObjectValue value) {
            super(value);
        }

        @Override
        public String getDisplay() {
            return ObjectTableModel.this.display.getPrimitiveValueDisplay(this.value.getValue());
        }

        @Override
        public String getHtmlDisplay() {
            return "<html>" + HTMLUtilities.escapeHTML((String)ObjectTableModel.this.display.getPrimitiveValueDisplay(this.value.getValue()));
        }

        @Override
        public String getToolTip() {
            return ObjectTableModel.this.display.getPrimitiveEdgeToolTip(this.value);
        }

        @Override
        public TraceObjectValue getAttribute(String attributeName) {
            return null;
        }

        @Override
        public String getAttributeDisplay(String attributeName) {
            return null;
        }

        @Override
        public String getAttributeHtmlDisplay(String attributeName) {
            return null;
        }

        @Override
        public String getAttributeToolTip(String attributeName) {
            return null;
        }

        @Override
        public boolean isAttributeModified(String attributeName) {
            return false;
        }
    }

    public static interface ValueRow {
        public String getKey();

        public RangeSet<Long> getLife();

        public TraceObjectValue getValue();

        public String getDisplay();

        public String getHtmlDisplay();

        public String getToolTip();

        public boolean isModified();

        public TraceObjectValue getAttribute(String var1);

        public String getAttributeDisplay(String var1);

        public String getAttributeHtmlDisplay(String var1);

        public String getAttributeToolTip(String var1);

        public boolean isAttributeModified(String var1);
    }

    protected static class ColKey {
        private final String name;
        private final Class<?> type;
        private final int hash;

        public static ColKey fromSchema(SchemaContext ctx, TargetObjectSchema.AttributeSchema attributeSchema) {
            String name = attributeSchema.getName();
            Class<?> type = TraceValueObjectAttributeColumn.computeColumnType(ctx, attributeSchema);
            return new ColKey(name, type);
        }

        public ColKey(String name, Class<?> type) {
            this.name = name;
            this.type = type;
            this.hash = Objects.hash(name, type);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ColKey)) {
                return false;
            }
            ColKey that = (ColKey)obj;
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    protected abstract class AbstractValueRow
    implements ValueRow {
        protected final TraceObjectValue value;

        public AbstractValueRow(TraceObjectValue value) {
            this.value = value;
        }

        @Override
        public TraceObjectValue getValue() {
            return this.value;
        }

        @Override
        public String getKey() {
            return this.value.getEntryKey();
        }

        @Override
        public RangeSet<Long> getLife() {
            TreeRangeSet life = TreeRangeSet.create();
            life.add(this.value.getLifespan());
            return life;
        }

        @Override
        public boolean isModified() {
            return ObjectTableModel.this.isValueModified(this.getValue());
        }
    }
}

