/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFileUtilities;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable;
import ghidra.file.formats.android.oat.tlt.TypeLookupTableFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class OatDexFile_S_T
extends OatDexFile {
    private int dex_file_location_;
    private String canonical_dex_file_location_;
    private int dex_file_location_checksum_;
    private int dex_file_pointer_;
    private int lookup_table_data_;
    private int method_bss_mapping_;
    private int type_bss_mapping_;
    private int public_type_bss_mapping_;
    private int package_type_bss_mapping_;
    private int string_bss_mapping_;
    private int oat_class_offsets_pointer_;
    private int lookup_table_;
    private int dex_layout_sections_;
    private TypeLookupTable typeLookupTable;
    private long _offset;
    private DexHeader dexHeader;

    public OatDexFile_S_T(BinaryReader reader, OatBundle bundle) throws IOException {
        this._offset = reader.getPointerIndex();
        this.dex_file_location_ = reader.readNextInt();
        this.canonical_dex_file_location_ = reader.readNextAsciiString(this.dex_file_location_);
        this.dex_file_location_checksum_ = reader.readNextInt();
        this.dex_file_pointer_ = reader.readNextInt();
        this.lookup_table_data_ = reader.readNextInt();
        this.method_bss_mapping_ = reader.readNextInt();
        this.type_bss_mapping_ = reader.readNextInt();
        this.public_type_bss_mapping_ = reader.readNextInt();
        this.package_type_bss_mapping_ = reader.readNextInt();
        this.string_bss_mapping_ = reader.readNextInt();
        this.oat_class_offsets_pointer_ = reader.readNextInt();
        this.lookup_table_ = reader.readNextInt();
        BinaryReader typeLookupTableReader = reader.clone((long)this.lookup_table_);
        this.typeLookupTable = TypeLookupTableFactory.getTypeLookupTable(typeLookupTableReader, bundle.getOatHeader().getVersion());
        this.dexHeader = bundle.getDexHeaderByChecksum(this.dex_file_location_checksum_);
    }

    @Override
    public int getDexFileChecksum() {
        return this.dex_file_location_checksum_;
    }

    @Override
    public String getDexFileLocation() {
        return this.canonical_dex_file_location_;
    }

    @Override
    public int getDexFileOffset() {
        return this.dex_file_pointer_;
    }

    @Override
    public DexHeader getDexHeader() {
        return this.dexHeader;
    }

    @Override
    public boolean isDexHeaderExternal() {
        return true;
    }

    @Override
    public void markup(OatHeader oatHeader, Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        Address address = oatDataSymbol.getAddress();
        Address dataAddress = address.add(this._offset);
        program.getListing().setComment(dataAddress, 3, this.getDexFileLocation());
        program.getListing().clearCodeUnits(dataAddress, dataAddress, false, monitor);
        Data data = program.getListing().createData(dataAddress, this.toDataType());
        for (int i = 0; i < data.getNumComponents(); ++i) {
            Scalar scalar;
            monitor.checkCanceled();
            Data componentI = data.getComponent(i);
            if (!componentI.getFieldName().startsWith("lookup_table_data_") && !componentI.getFieldName().startsWith("oat_class_offsets_pointer_") && !componentI.getFieldName().startsWith("lookup_table_data_") && !componentI.getFieldName().startsWith("method_bss_mapping_") && !componentI.getFieldName().startsWith("type_bss_mapping_") && !componentI.getFieldName().startsWith("public_type_bss_mapping_") && !componentI.getFieldName().startsWith("package_type_bss_mapping_") && !componentI.getFieldName().startsWith("string_bss_mapping_") && !componentI.getFieldName().startsWith("oat_class_offsets_pointer_") && !componentI.getFieldName().startsWith("lookup_table_") && !componentI.getFieldName().startsWith("dex_layout_sections_") || (scalar = componentI.getScalar(0)).getUnsignedValue() == 0L) continue;
            Address destinationAddress = address.add(scalar.getUnsignedValue());
            program.getReferenceManager().addMemoryReference(componentI.getMinAddress(), destinationAddress, RefType.DATA, SourceType.ANALYSIS, 0);
            program.getSymbolTable().createLabel(destinationAddress, componentI.getFieldName(), SourceType.ANALYSIS);
            if (componentI.getFieldName().startsWith("lookup_table_data_")) {
                OatDexFileUtilities.markupLookupTableData(this.getClass(), destinationAddress, this.dexHeader, oatHeader, program, monitor, log);
                continue;
            }
            if (!componentI.getFieldName().startsWith("lookup_table_") || this.typeLookupTable == null) continue;
            DataType dataType = this.typeLookupTable.toDataType();
            program.getListing().createData(destinationAddress, dataType);
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatDexFile_S_T.class.getSimpleName() + "_" + this.dex_file_location_, 0);
        structure.add(DWORD, "dex_file_location_", null);
        structure.add(STRING, this.dex_file_location_, "canonical_dex_file_location_", null);
        structure.add(DWORD, "dex_file_location_checksum_", null);
        structure.add(DWORD, "dex_file_pointer_", null);
        structure.add(DWORD, "lookup_table_data_", null);
        structure.add(DWORD, "method_bss_mapping_", null);
        structure.add(DWORD, "type_bss_mapping_", null);
        structure.add(DWORD, "public_type_bss_mapping_", null);
        structure.add(DWORD, "package_type_bss_mapping_", null);
        structure.add(DWORD, "string_bss_mapping_", null);
        structure.add(DWORD, "oat_class_offsets_pointer_", null);
        structure.add(DWORD, "lookup_table_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }

    public int getLookupTableData() {
        return this.lookup_table_data_;
    }

    public int getTypeBssMapping() {
        return this.type_bss_mapping_;
    }

    public int getPublicTypeBssMapping() {
        return this.public_type_bss_mapping_;
    }

    public int getStringBssMapping() {
        return this.string_bss_mapping_;
    }

    public int getOatClassOffsetsPointer() {
        return this.oat_class_offsets_pointer_;
    }

    public int getDexLayoutSections() {
        return this.dex_layout_sections_;
    }

    public int getMethodBssMapping() {
        return this.method_bss_mapping_;
    }

    public int getPackageTypeBssMapping() {
        return this.package_type_bss_mapping_;
    }

    public int getLookupTable() {
        return this.lookup_table_;
    }
}

