/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.dex.format.EncodedCatchHandler;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EncodedCatchHandlerList
implements StructConverter {
    private int size;
    private int sizeLength;
    private List<EncodedCatchHandler> handlers = new ArrayList<EncodedCatchHandler>();

    public EncodedCatchHandlerList(BinaryReader reader) throws IOException {
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.size = leb128.asUInt32();
        this.sizeLength = leb128.getLength();
        for (int i = 0; i < this.size; ++i) {
            this.handlers.add(new EncodedCatchHandler(reader));
        }
    }

    public int getSize() {
        return this.size;
    }

    public List<EncodedCatchHandler> getHandlers() {
        return this.handlers;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "encoded_catch_handler_list_" + this.sizeLength;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.sizeLength, BYTE.getLength()), "size", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_catch_handler_list"));
        return structure;
    }
}

