/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.dialogs.StringChoices;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class SettingsDialog
extends DialogComponentProvider {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 150;
    private SettingsDefinition[] settingsDefs;
    private Settings settings;
    private SettingsTableModel settingsTableModel;
    private GTable settingsTable;

    public SettingsDialog(HelpLocation help) {
        super("Settings", true, false, true, false);
        if (help != null) {
            this.setHelpLocation(help);
        }
        this.setTransient(true);
        this.addWorkPanel(this.buildWorkPanel());
        this.addDismissButton();
        this.setHelpLocation(new HelpLocation("Tables/GhidraTableHeaders.html", "ColumnSettings"));
    }

    public void show(Component parent, String title, SettingsDefinition[] newSettingsDefs, Settings newSettings) {
        this.settingsDefs = newSettingsDefs;
        this.settings = newSettings;
        this.setTitle(title);
        this.settingsTableModel.setSettingsDefinitions(this.settingsDefs);
        DockingWindowManager.showDialog(parent, this);
    }

    @Override
    public void dispose() {
        this.settingsTable.editingStopped(null);
        this.settingsTable.dispose();
        this.close();
        this.settingsDefs = null;
        this.settings = null;
    }

    private JPanel buildWorkPanel() {
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.settingsTableModel = new SettingsTableModel();
        this.settingsTable = new GTable(this.settingsTableModel);
        this.settingsTable.setAutoscrolls(true);
        this.settingsTable.setRowSelectionAllowed(false);
        this.settingsTable.setColumnSelectionAllowed(false);
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTable.setColumnHeaderPopupEnabled(false);
        this.settingsTable.setUserSortingEnabled(false);
        this.settingsTable.setDefaultRenderer(Settings.class, new DefaultTableCellRenderer());
        this.settingsTable.setDefaultEditor(Settings.class, new SettingsEditor());
        JScrollPane scrollpane = new JScrollPane(this.settingsTable);
        scrollpane.setPreferredSize(new Dimension(300, 150));
        workPanel.add((Component)scrollpane, "Center");
        return workPanel;
    }

    @Override
    protected void cancelCallback() {
        this.dispose();
    }

    public GTable getTable() {
        return this.settingsTable;
    }

    private class SettingsTableModel
    extends AbstractSortedTableModel<SettingsRowObject> {
        private List<SettingsRowObject> rows = new ArrayList<SettingsRowObject>();

        private SettingsTableModel() {
        }

        void setSettingsDefinitions(SettingsDefinition[] settingsDefs) {
            for (SettingsDefinition sd : settingsDefs) {
                this.rows.add(new SettingsRowObject(sd));
            }
            SettingsDialog.this.settingsTableModel.fireTableDataChanged();
        }

        @Override
        public List<SettingsRowObject> getModelData() {
            return this.rows;
        }

        @Override
        public String getName() {
            return "Settings Definition Model";
        }

        @Override
        public boolean isSortable(int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Settings";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Settings.class;
                }
            }
            return null;
        }

        @Override
        public Object getColumnValueForRow(SettingsRowObject t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return t.getName();
                }
                case 1: {
                    return t.getSettingsChoices();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            SettingsRowObject rowObject = this.rows.get(row);
            switch (col) {
                case 1: {
                    if (!rowObject.setSettingsChoice(value)) break;
                    this.fireTableDataChanged();
                    break;
                }
                case 2: {
                    if (!((Boolean)value).booleanValue()) break;
                    rowObject.clear(SettingsDialog.this.settings);
                    this.fireTableDataChanged();
                }
            }
        }
    }

    private class SettingsEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    PopupMenuListener {
        static final int ENUM = 0;
        static final int BOOLEAN = 1;
        private int mode;
        private GComboBox<String> comboBox = new GComboBox();
        private GCheckBox checkBox = new GCheckBox();
        private final Runnable editStopped = () -> this.fireEditingStopped();

        SettingsEditor() {
            this.comboBox.addPopupMenuListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            switch (this.mode) {
                case 0: {
                    return this.getComboBoxEnum();
                }
                case 1: {
                    return this.checkBox.isSelected();
                }
            }
            throw new AssertException();
        }

        private StringChoices getComboBoxEnum() {
            String[] items = new String[this.comboBox.getItemCount()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (String)this.comboBox.getItemAt(i);
            }
            StringChoices choices = new StringChoices(items);
            choices.setSelectedValue(this.comboBox.getSelectedIndex());
            return choices;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof StringChoices) {
                this.initComboBox((StringChoices)value);
                return this.comboBox;
            }
            if (value instanceof Boolean) {
                this.initCheckBox((Boolean)value);
                return this.checkBox;
            }
            throw new AssertException("SettingsEditor: " + value.getClass().getName() + " not supported");
        }

        private void initCheckBox(Boolean b) {
            this.mode = 1;
            this.checkBox.setSelected(b);
        }

        private void initComboBox(StringChoices choices) {
            String[] items;
            this.mode = 0;
            this.comboBox.removeAllItems();
            for (String item : items = choices.getValues()) {
                this.comboBox.addItem(item);
            }
            this.comboBox.setSelectedIndex(choices.getSelectedValueIndex());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(this.editStopped);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class SettingsRowObject {
        private SettingsDefinition definition;

        SettingsRowObject(SettingsDefinition definition) {
            this.definition = definition;
        }

        public String getName() {
            return this.definition.getName();
        }

        Object getSettingsChoices() {
            if (this.definition instanceof EnumSettingsDefinition) {
                EnumSettingsDefinition def = (EnumSettingsDefinition)this.definition;
                StringChoices choices = new StringChoices(def.getDisplayChoices(SettingsDialog.this.settings));
                choices.setSelectedValue(def.getChoice(SettingsDialog.this.settings));
                return choices;
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                BooleanSettingsDefinition def = (BooleanSettingsDefinition)this.definition;
                return def.getValue(SettingsDialog.this.settings);
            }
            return "<Unsupported>";
        }

        boolean setSettingsChoice(Object value) {
            if (this.definition instanceof EnumSettingsDefinition) {
                EnumSettingsDefinition def = (EnumSettingsDefinition)this.definition;
                StringChoices choices = (StringChoices)value;
                def.setChoice(SettingsDialog.this.settings, choices.getSelectedValueIndex());
                return true;
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                BooleanSettingsDefinition def = (BooleanSettingsDefinition)this.definition;
                def.setValue(SettingsDialog.this.settings, (Boolean)value);
                return true;
            }
            return false;
        }

        void clear(Settings s) {
            this.definition.clear(s);
        }
    }
}

