/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.shapes.Location;
import docking.widgets.shapes.PopupWindowPlacer;
import docking.widgets.shapes.PopupWindowPlacerBuilder;
import generic.util.WindowUtilities;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PopupWindow {
    private static final int X_PADDING = 25;
    private static final int Y_PADDING = 25;
    private static final List<WeakReference<PopupWindow>> VISIBLE_POPUPS = new ArrayList<WeakReference<PopupWindow>>();
    private static final PopupWindowPlacer DEFAULT_WINDOW_PLACER = new PopupWindowPlacerBuilder().rightEdge(Location.BOTTOM).leftEdge(Location.BOTTOM).bottomEdge(Location.RIGHT).topEdge(Location.CENTER).leastOverlapCorner().throwsAssertException().build();
    private Rectangle mouseMovementArea;
    private JWindow popup;
    private Component sourceComponent;
    private MouseMotionListener sourceMouseMotionListener;
    private MouseListener sourceMouseListener;
    private Timer closeTimer;
    private JComponent displayComponent;

    public static void hideAllWindows() {
        for (WeakReference<PopupWindow> weakReference : VISIBLE_POPUPS) {
            PopupWindow popupWindow = (PopupWindow)weakReference.get();
            if (popupWindow == null) continue;
            popupWindow.hide();
        }
    }

    public PopupWindow(JComponent displayComponent) {
        this(PopupWindow.getDefaultParentWindow(), displayComponent);
    }

    public PopupWindow(Component sourceComponent, JComponent displayComponent) {
        this(PopupWindow.getParentWindow(sourceComponent), displayComponent);
    }

    private static Window getParentWindow(Component sourceComponent) {
        if (sourceComponent == null) {
            return PopupWindow.getDefaultParentWindow();
        }
        Window window = WindowUtilities.windowForComponent((Component)sourceComponent);
        if (window != null) {
            return window;
        }
        return PopupWindow.getDefaultParentWindow();
    }

    private static Window getDefaultParentWindow() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            activeWindow = JOptionPane.getRootFrame();
        }
        return activeWindow;
    }

    public PopupWindow(Window parentWindow, JComponent displayComponent) {
        this.displayComponent = displayComponent;
        this.popup = new JWindow(parentWindow);
        this.popup.setFocusableWindowState(false);
        this.popup.getContentPane().add(displayComponent);
        this.popup.pack();
        this.closeTimer = new Timer(750, event -> this.hide());
        this.closeTimer.setRepeats(false);
        MouseAdapter closeWindowListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PopupWindow.this.closeTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PopupWindow.this.closeTimer.start();
            }
        };
        this.addMouseListener(this.popup, closeWindowListener);
        this.sourceMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point localPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(localPoint, e.getComponent());
                if (!PopupWindow.this.mouseMovementArea.contains(localPoint)) {
                    PopupWindow.this.hide();
                } else {
                    PopupWindow.this.closeTimer.restart();
                }
                e.consume();
            }
        };
        this.sourceMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PopupWindow.this.hide();
            }
        };
    }

    private void addMouseListener(Container c, MouseListener listener) {
        Component[] children;
        c.addMouseListener(listener);
        for (Component element : children = c.getComponents()) {
            if (element instanceof Container) {
                this.addMouseListener((Container)element, listener);
                continue;
            }
            element.addMouseListener(listener);
        }
    }

    public JComponent getDisplayComponent() {
        return this.displayComponent;
    }

    public void setWindowName(String name) {
        this.popup.setName(name);
    }

    public void addComponentListener(ComponentListener listener) {
        this.popup.addComponentListener(listener);
    }

    public boolean isShowing() {
        return this.popup.isShowing();
    }

    public void hide() {
        this.popup.setVisible(false);
        if (this.sourceComponent != null) {
            this.sourceComponent.removeMouseMotionListener(this.sourceMouseMotionListener);
            this.sourceComponent.removeMouseListener(this.sourceMouseListener);
        }
        this.sourceComponent = null;
    }

    public void dispose() {
        this.hide();
        this.popup.dispose();
        this.removeOldPopupReferences();
    }

    private void removeOldPopupReferences() {
        Iterator<WeakReference<PopupWindow>> iterator = VISIBLE_POPUPS.iterator();
        while (iterator.hasNext()) {
            WeakReference<PopupWindow> reference = iterator.next();
            PopupWindow window = (PopupWindow)reference.get();
            if (window != this) continue;
            reference.clear();
            iterator.remove();
            return;
        }
    }

    public void pack() {
        this.popup.pack();
    }

    public void setCloseWindowDelay(int delayInMillis) {
        this.closeTimer = new Timer(delayInMillis, event -> this.hide());
        this.closeTimer.setRepeats(false);
    }

    public void showOffsetPopup(MouseEvent e, Rectangle keepVisibleSize) {
        this.doShowPopup(e, keepVisibleSize, DEFAULT_WINDOW_PLACER);
    }

    public void showPopup(MouseEvent e) {
        this.doShowPopup(e, null, DEFAULT_WINDOW_PLACER);
    }

    private void doShowPopup(MouseEvent e, Rectangle keepVisibleSize, PopupWindowPlacer placer) {
        PopupWindow.hideAllWindows();
        this.sourceComponent = e.getComponent();
        this.sourceComponent.addMouseListener(this.sourceMouseListener);
        this.sourceComponent.addMouseMotionListener(this.sourceMouseMotionListener);
        Dimension popupDimension = this.popup.getSize();
        this.ensureSize(popupDimension);
        Rectangle keepVisibleArea = this.createKeepVisibleArea(e, keepVisibleSize);
        Rectangle screenBounds = WindowUtilities.getVisibleScreenBounds().getBounds();
        Rectangle placement = placer.getPlacement(popupDimension, keepVisibleArea, screenBounds);
        this.mouseMovementArea = this.createMovementArea(placement, keepVisibleArea);
        this.installDebugPainter(e);
        this.popup.setBounds(placement);
        this.popup.setVisible(true);
        this.removeOldPopupReferences();
        VISIBLE_POPUPS.add(new WeakReference<PopupWindow>(this));
    }

    private Rectangle createKeepVisibleArea(MouseEvent e, Rectangle keepVisibleAea) {
        Rectangle newArea;
        Point point;
        if (keepVisibleAea == null) {
            point = new Point(e.getPoint());
            newArea = new Rectangle(point);
            newArea.grow(25, 25);
        } else {
            newArea = new Rectangle(keepVisibleAea);
        }
        point = newArea.getLocation();
        SwingUtilities.convertPointToScreen(point, this.sourceComponent);
        newArea.setLocation(point);
        return newArea;
    }

    private void ensureSize(Dimension popupDimension) {
        Dimension screenDimension = WindowUtilities.getVisibleScreenBounds().getBounds().getSize();
        if (screenDimension.width < popupDimension.width) {
            popupDimension.width = screenDimension.width / 2;
        }
        if (screenDimension.height < popupDimension.height) {
            popupDimension.height = screenDimension.height / 2;
        }
    }

    private Rectangle createMovementArea(Rectangle popupBounds, Rectangle hoverRectangle) {
        Rectangle result = popupBounds.union(hoverRectangle);
        return result;
    }

    private void installDebugPainter(MouseEvent e) {
    }

    private class ShapeDebugPainter
    implements GGlassPanePainter {
        private MouseEvent sourceEvent;
        private Rectangle bounds;

        ShapeDebugPainter(MouseEvent sourceEvent, Rectangle bounds) {
            this.sourceEvent = sourceEvent;
            this.bounds = bounds;
        }

        public void paint(GGlassPane glassPane, Graphics g) {
            if (this.bounds != null) {
                Rectangle r = this.bounds;
                Point p = new Point(r.getLocation());
                SwingUtilities.convertPointFromScreen(p, (Component)glassPane);
                Color c = new Color(50, 50, 200, 125);
                g.setColor(c);
                g.fillRect(p.x, p.y, r.width, r.height);
            }
            if (this.sourceEvent != null) {
                Point p = this.sourceEvent.getPoint();
                p = SwingUtilities.convertPoint(this.sourceEvent.getComponent(), p.x, p.y, (Component)glassPane);
                g.setColor(Color.RED);
                int offset = 10;
                g.fillRect(p.x - offset, p.y - offset, offset * 2, offset * 2);
            }
        }
    }
}

