/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLocalSymbolInOptimizedCodeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefinedSingleAddressRangeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class LocalOptimizedSymbolApplier
extends MsSymbolApplier {
    private AbstractLocalSymbolInOptimizedCodeMsSymbol symbol;

    public LocalOptimizedSymbolApplier(DefaultPdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractLocalSymbolInOptimizedCodeMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractLocalSymbolInOptimizedCodeMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.pdbLogAndInfoMessage(this, "Cannot apply " + this.getClass().getSimpleName() + " directly to program");
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) throws PdbException, CancelledException {
        if (!this.applicator.getPdbApplicatorOptions().applyFunctionVariables()) {
            return;
        }
        if (applyToApplier instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applyToApplier;
            this.doWork(functionSymbolApplier);
        }
    }

    private void doWork(FunctionSymbolApplier functionSymbolApplier) throws CancelledException, PdbException {
        this.symbol.getLocalVariableFlags();
        this.symbol.getName();
        this.symbol.getTypeRecordNumber();
        while (this.iter.hasNext() && this.iter.peek() instanceof AbstractDefinedSingleAddressRangeMsSymbol) {
            this.applicator.checkCanceled();
            DefinedSingleAddressRangeSymbolApplier rangeApplier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, this.iter);
            rangeApplier.applyTo(this);
        }
    }
}

