/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13CoffSymbolRva;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeExports;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeImports;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FileChecksums;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FrameData;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FuncMdTokenMap;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13IlLines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13InlineeLines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Lines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13MergedAssemblyInput;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13StringTable;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Symbols;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Type;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13TypeMdTokenMap;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.UnknownC13Section;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;

abstract class C13Section {
    protected static final String dashes = "------------------------------------------------------------\n";
    private boolean ignore;

    protected C13Section(boolean ignore) {
        this.ignore = ignore;
    }

    boolean ignore() {
        return this.ignore;
    }

    void dump(Writer writer) throws IOException {
        String n = this.getClass().getSimpleName();
        int len = n.length();
        writer.write(n + dashes.substring(len));
        writer.write("End " + n + dashes.substring(len + 4));
    }

    static C13Section parse(PdbByteReader reader, TaskMonitor monitor) throws CancelledException, PdbException {
        int typeVal = reader.parseInt();
        boolean ignore = C13Type.ignore(typeVal);
        C13Type type = C13Type.fromValue(typeVal);
        int length = reader.parseInt();
        PdbByteReader recordReader = reader.getSubPdbByteReader(length);
        switch (type) {
            case SYMBOLS: {
                return C13Symbols.parse(recordReader, ignore, monitor);
            }
            case LINES: {
                return C13Lines.parse(recordReader, ignore, monitor);
            }
            case STRING_TABLE: {
                return C13StringTable.parse(recordReader, ignore, monitor);
            }
            case FILE_CHECKSUMS: {
                return C13FileChecksums.parse(recordReader, ignore, monitor);
            }
            case FRAMEDATA: {
                return C13FrameData.parse(recordReader, ignore, monitor);
            }
            case INLINEE_LINES: {
                return C13InlineeLines.parse(recordReader, ignore, monitor);
            }
            case CROSS_SCOPE_IMPORTS: {
                return C13CrossScopeImports.parse(recordReader, ignore, monitor);
            }
            case CROSS_SCOPE_EXPORTS: {
                return C13CrossScopeExports.parse(recordReader, ignore, monitor);
            }
            case IL_LINES: {
                return C13IlLines.parse(recordReader, ignore, monitor);
            }
            case FUNC_MDTOKEN_MAP: {
                return C13FuncMdTokenMap.parse(recordReader, ignore, monitor);
            }
            case TYPE_MDTOKEN_MAP: {
                return C13TypeMdTokenMap.parse(recordReader, ignore, monitor);
            }
            case MERGED_ASSEMBLY_INPUT: {
                return C13MergedAssemblyInput.parse(recordReader, ignore, monitor);
            }
            case COFF_SYMBOL_RVA: {
                return C13CoffSymbolRva.parse(recordReader, ignore, monitor);
            }
        }
        return UnknownC13Section.parse(recordReader, ignore, monitor);
    }
}

